; [ griesse >-----------------------------------< griesse@hotmail.com ]
;                                                                     |
; nibbles2.asm                                                        |
;                                                                     :
; my entry for the hugi size coding competition (hugi #11)            :
;                                                                     .
; may 15th, 1998 - 95 byte                                            .
; -------------------------------------------------  ----  ---  --  - 
.model tiny
.286
codeseg
org 0100h
start:
	; ax=0, bx=0, ch=0, di=fffeh
	mov al, 13h     ;
	int 10h         ; gfxmode (320x200x256)

	push 0a000h     ;
	pop es          ; get video address        

	inc di		;
	inc di		; need less space then add di,2
	mov cx,320      ; number of pixels (x) to draw
hor:
	mov byte ptr [es:di+320*199],al         ; draw pixel at bottom
	stosb					; draw pixel at top
	loop hor 

	mov cl,199      ; number of pixels (y) to draw
ver:
	mov ax,320      ;
	mul cx          ;
	xchg di,ax      ; get yposition of the pixels
	mov al,13h      ; for stosb (dark grey)
	stosb           		; draw left side pixel (inc di)
	mov byte ptr [es:di+318],al     ; draw right side pixel
	loop ver                        ;

; ----- main ----------------------------------------------------------

bigloop:
	mov al,14       ; yellow
	stosb           ; draw nibble head

	mov ah,0Bh      ; key pressed?
	int 21h         ;
	cmp al,0        ; if al = 0 no key was pressed
	je comp         ;

	mov ah,7        ; get key
	int 21h         ;
	mov bl, al      ;
	sub bl, 50      ; '2' = 50
	
comp:
	add di, [bx + offset datas]     ; add data for direction

	mov dx,3dah     ; wait for retrace
delay_l1:
	in al,dx
	test al,8
	jne delay_l1
delay_l2:
	in al,dx
	test al,8
	je delay_l2

	cmp byte ptr [es:di], cl        ; if cl <> 0 (black) nibble is dead
	je bigloop                      ;

	mov ax,3        ;
	int 10h         ; back to textmode
	ret             ; back to dos

datas:  dw       319
	dw        -2
	dw         0
	dw      -321
end start
