;ͻ
; tinyNiBBLES for the HUGI competition :)                               
;                                                  Jibz  &  x-otic  '98 
;ͼ

    .MODEL TINY
    .386
    CODESEG
    LOCALS
    ORG 100h

START:
    mov     al, 13h                ; set mode13h
    int     10h

    push    0a000h                 ; segm of video mem
    pop     es

    mov     bx, offset (ktable-8)  ; bh = 1 for the retrace. bx also used
                                   ; for the table lookup ;)

    mov     ax, 0303h              ; border color

    not     di                     ; di was 0fffeh, so now it is 0001h :)

    mov     cl, 199                ; draw side borders
drawborder:
    lea     di, [di+bx+13h]        ; yep, it's a cheesy hack..
    stosw                          ; REMEMBER to change 13h if size changes!
    loop    drawborder

    mov     cx,0880h               ; draw bottom and top borders
    rep     stosb

    xchg    ax, di                 ; use 0303h as start position

mainloop:
    dec     di                     ; compensate for the scasb at the end

    mov     ah, 0bh                ; retrace (set palette), bh = 1
    int     10h

    in      al, 60h                ; get keystroke and convert to offset
    and     ax, 0000000000011110b
    xchg    si, ax

    mov     al, 03h                ; set next pixel
    stosb

    add     di, [bx + si]          ; update position (lookup in table)
    scasb                          ; collision check
    jne     mainloop

exit:
    int     10h                    ; ax = 0003h

ktable dw -321
       dw -2
       dw 0
       db 000h                     ; waste
       db 0c3h                     ; waste, used as ret...
       dw 319

END START
