;>>>mikenib.asm<<<
;  by Mike Ferenduros
;     m.ferenduros@btinternet.com
;        Crappy nibbles variant optimised for size
;
;  Assembled & linked using Borland TASM5
;  Assembles to 86 bytes
;
;  Use numpad arrow keys (numlock on) to move
;  Pressing any other keys will have weird results


;***change this if trails are too dark or black
;***keep between 0EDh and 0FFh
colour         equ   0EDh

.386
.model tiny


code           segment  byte  use16
assume         cs:code,ds:code
org            100h

start:
   jmp   codestart

move_table     dw    320
               dw    -1
               dw    1
               dw    -320

codestart:
   mov   ax,13h
   int   10h
   push  0A000h
   pop   es


   mov   di,63680
   mov   cx,2175
;***if the borders are drawn wrong, insert a cld here
   rep   stosb

   mov   ah,al
   mov   si,318
   mov   cl,199
borderloop:
   stosw
   add   di,si
   loop  borderloop

   shr   si,1
   mov   bx,0102h

mainloop:

   mov   ah,6
   mov   dl,0FFh
   int   21h
   jz    nokeypress

   and   al,1110b
   mov   bl,al

nokeypress:
   add   si,[bx]

   mov   dx,3DAh
   delay_l1:
   in    al,dx
   test  al,8
   jne   delay_l1
   delay_l2:
   in    al,dx
   test  al,8
   je    delay_l2

   add   byte ptr es:[si],colour
   jnc   mainloop

done:
   mov   ax,03h
   int   10h
   mov   ah,4Ch
   int   21h

code  ends
end   start
