; hugi nibbles-compo entry - red xiii & kb / may98

.model tiny
.386

.code
.startup
  mov al, 13h                           ; set mode 13h
  int 10h

  push 0a000h                           ; es = video seg
  pop es

  inc di

  mov cl, 199                           ; for all 199 lines of the screen:
  @fl:
    stosb                               ; put left-end pixel
    stosb                               ; put right-end pixel
    add di, 318                         ; skip 318 pixels
  loop @fl

  mov cx, 2178                          ; something like -erhm- wrap-around
  rep                                   ; used to get this one tighter ;)

  @ml:
    stosb

    in al, 60h                          ; get key
    and al, 07fh                        ; scancode = release scancode (keypad)

    sub al, 04ch                        ; calc increment
    cbw
    test al, 3
    jnz @horz
    imul ax, 80

  @horz:
    dec ax                              ; decrease ax (stosb!)
    add di, ax                          ; update snake's direction

    mov ax, 0b03h                       ; wait for vretrace by changing
    int 10h                             ; the palette... ;)

    test al, es:[di]                    ; check if snake hit anything
  je @ml

  cbw                                   ; return to textmode
  int 10h
  ret                                   ; exit to dos
end
