;
;
;                       another 4x4 example by TAD
;                     ( flamez:  tad.uk@dtn.ntl.com )
;
; compile:
;               tasm example
;               tlink /t example        <--- assemble as a .COM file
;
; fire prevention:
;       Please don't flame me, the code is meant to be this big
;       its just an EXAMPLE...
;
;

; Adopted for the test suite by ruud, made some tiny changes


        .model tiny
        .data

msgWin          db 'Winning field after $'
msgEsc          db 'You have quit after $'
msgMoves        db ' moves',0dh,0ah,'$'
bNum            db 6 dup (?)

szOutFile       db      'keys',0
wHandle         dw      ?

MovesCounter    dw      ?
HolePos         dw      ?

Grid            db       0, 13, 10, 07
                db      04, 01, 14, 11
                db      08, 05, 02, 15
                db      12, 09, 06, 03


;                       UDLR
;                       ----
ValidMoves      db      0101b           ; [0]   - allow  DOWN or RIGHT moves
                db      0111b           ; [1]
                db      0111b           ; [2]
                db      0110b           ; [3]

                db      1101b           ; [4]
                db      1111b           ; [5]
                db      1111b           ; [6]
                db      1110b           ; [7]

                db      1101b           ; [8]
                db      1111b           ; [9]
                db      1111b           ; [10]
                db      1110b           ; [11]

                db      1001b           ; [12]
                db      1011b           ; [13]
                db      1011b           ; [14]
                db      1010b           ; [15]

;; 7x 1-bit flags for the LED char sections ;;
;;
;;       777777         <------ each of the 7 LED line sections
;;      6      5                are described usings bit #7 ... bit #1
;;      6      5
;;       444444                             76543210 <-- bit
;;      3      2                (eg. '9' =  11110100 binary )
;;      3      2
;;      3      2
;;       111111


;;                      7654321
LedDigits       db      11101110b       ;[0]    '0' char
                db      00100100b       ;[1]    '1' char
                db      10111010b       ;[2]    '2' char
                db      10110110b       ;[3]    '3' char
                db      01110100b       ;[4]    '4' char
                db      11010110b       ;[5]    '5' char
                db      11011110b       ;[6]    '6' char
                db      11100100b       ;[7]    '7' char
                db      11111110b       ;[8]    '8' char
                db      11110110b       ;[9]    '9' char


;; the 7 LED section lines (scrdisp, rep, step) ;;

LedLines        dw      1+(15*320), 6, +1       ;[0] bot edge   bit #1
                dw      7+(8*320),  7, +320     ;[1] bot-right  bit #2
                dw      0+(8*320),  7, +320     ;[2] bot-left   bit #3
                dw      1+(7*320),  6, +1       ;[3] middle     bit #4
                dw      7+(1*320),  6, +320     ;[4] top-right  bit #5
                dw      0+(1*320),  6, +320     ;[5] top-left   bit #6
                dw      1+(0*320),  6, +1       ;[6] top line   bit #7

;; List of screen-coords for the 16 tiles ;;

ScrOffs         dw       97+(37*320)            ;[0]    coords  (97,37)
                dw      129+(37*320)            ;[1]    coords (129,37)
                dw      161+(37*320)            ;[2]    coords (161,37)
                dw      193+(37*320)            ;[3]    coords (193,37)

                dw       97+(69*320)            ;[4]    coords  (97,69)
                dw      129+(69*320)            ;[5]    coords (129,69)
                dw      161+(69*320)            ;[6]    coords (161,69)
                dw      193+(69*320)            ;[7]    coords (193,69)

                dw       97+(101*320)           ;[8]    coords  (97,101)
                dw      129+(101*320)           ;[9]    coords (129,101)
                dw      161+(101*320)           ;[10]   coords (161,101)
                dw      193+(101*320)           ;[11]   coords (193,101)

                dw       97+(133*320)           ;[12]   coords  (97,133)
                dw      129+(133*320)           ;[13]   coords (129,133)
                dw      161+(133*320)           ;[14]   coords (161,133)
                dw      193+(133*320)           ;[15]   coords (193,133)



        .code
        org 256
go:
        mov     dx,offset szOutFile
        xor     cx,cx			; Attributes = 0 !!
        mov     ah,3ch
        int     21h
        mov     wHandle,ax

        mov     ax, 00013h
        int     10h                     ; screen 13h

        mov     ax, 0A000h
        mov     ES, ax                  ; [ES:0000] --> VRAM

        ;; init the game stuff ;;

        mov     [MovesCounter], 0
        mov     [HolePos], 0

        ;; draw 1 pixel border color(7) ;;

        mov     di, 95+(35*320)         ; coords (95, 35)
        mov     cx, 130
        mov     al, 7
        rep     stosb                   ; top line

        mov     di, 95+(164*320)        ; coords (95, 164)
        mov     cx, 130
        mov     al, 7
        rep     stosb                   ; top line

        mov     di, 95+(35*320)         ; coords (95, 35)
        mov     cx, 130
sides:
        mov     ES:[di], al             ; coords (95, y)
        mov     ES:[di+129], al         ; coords (95+129, y)
        add     di, 320
        loop    sides                   ; sides


        ;; Draw initial state of 4x4 grid ;;
        
        call    DrawGrid

        ;; enter the main game loop ;;

MainLoop:
        call    CheckWin
        mov     dx,offset msgWin
        jz      short Quit              ; Won ?

        ;; wait/read key press ;;

        mov     ah, 0
        int     16h
        push    ax
        mov     cx,1
        mov     dx,sp
        mov     bx,wHandle
        mov     ah,40h
        int     21h
        pop     ax

        ;; check [QUIT] key

        cmp     al, 20h
        mov     dx,offset msgEsc
        jz      short Quit             ; [SPACE] ?

        ;; check the [2] [4] [6] or [8] keys ;;

        mov     di,  4                  ;               (+0, +1)
        mov     cl, 0100b               ; down
        cmp     al, '8'
        jz      short TryMove           ; [8] ?

        mov     di,  -4                 ;               (+0, -1)
        mov     cl, 1000b               ; up
        cmp     al, '2'
        jz      short TryMove           ; [2] ?

        mov     di,  1                  ;               (+1, +0)
        mov     cl, 0001b               ; right
        cmp     al, '4'
        jz      short TryMove           ; [4] ?

        mov     di,  -1                 ;               (-1, +0)
        mov     cl, 0010b               ; left
        cmp     al, '6'
        jz      short TryMove           ; [6] ?

        jmp     short MainLoop

        ;; display exit message ;;
Quit:
        mov     ax, 0003h
        int     10h                     ; text mode
        mov     bx,wHandle
        mov     ah,3eh
        int     21h

        push    ds
        pop     es
        mov     ah,9
        int     21h                     ; print win/esc message

        mov     ax,MovesCounter
        mov     di,offset bNum
        call    Ax2Dec
        mov     al,'$'
        stosb
        mov     dx,offset bNum
        mov     ah,9
        int     21h                     ; display MovesCounter

        mov     dx,offset msgMoves
        mov     ah,9
        int     21h                     ; print " moves",0Dh,0Ah

        mov     ax,  4C00h
        int     21h                     ; quit...

;; Output(AX) into[ES:DI] as decimal ASCII string -- Ruud's code ;;
Ax2Dec: mov     cx,10
        xor     dx,dx
        div     cx
        or      ax,ax
        je      @@DecDone
        push    dx
        call    Ax2Dec
        pop     dx
@@DecDone:
        or      dl,30h
        xchg    ax,dx
        stosb
        ret

;; Attempt Move(DI) direction(CL)  ;;
TryMove:
        mov     bx, [HolePos]
        test    ValidMoves[bx],  cl
        jz      short BadMove           ; is it a bad move (ie. at border) ?

        mov     al, Grid[bx+di]
        mov     Grid[bx], al            ; Move tile
        mov     Grid[bx+di], 0          ; replace hole
        add     [HolePos],  di          ; update hole (x, y) position

        inc     [MovesCounter]          ; MovesCounter + 1
        call    DrawGrid
BadMove:
        jmp     MainLoop


;; ZF=Check for WIN condition ::
CheckWin:
        mov     bx, 15                  ; n = 15 ... 0
cw_loop:
        cmp     Grid[bx], bl
        jnz     short cw_nope           ; is grid[n] <> n ?
        dec     bx
        jns     short cw_loop
cw_nope:
        inc     bx                      ; ZF = done,    NZ = fail
        ret

;; Draw entire grid ;;
DrawGrid:
        mov     si,  15                 ; n = 15 ... 0
dg_LOOP:
        mov     al, Grid[si]            ; al = grid[x,y]   (the tile value)

        shl     si, 1
        mov     di,  ScrOffs[si]        ; [ES:DI] --> screen pixel

        ;; draw the 30x30 pixel box ;;

        mov     dx,30                   ; 30 lines high
dg_BOX:
        mov     cx,30                   ; 30 pixels wide
        rep     stosb           
        add     di,320-30
        dec     dx
        jnz     short dg_BOX

        ;; draw the LED digits ;;

        aam     10                      ; ah = al/10,   al = al MOD 10
        push    ax
        mov     al,ah                   ; 10's
        mov     di, 6+(7*320)           ; draw at (+6, +7)
        call    DrawLED

        pop     ax                      ; 1's
        mov     di, 16+(7*320)          ; draw at (+16, +7)
        call    DrawLED

        shr     si,1
        dec     si
        jns     short dg_LOOP           ; repeat for 16 tiles...
        ret

;; Draw LED char(AL) at( DI+Scroffs[si] ) ;;
DrawLED:
        add     di, ScrOffs[si]         ; [ES:DI] --> screen pixel

        mov     ah, 0
        mov     bx, ax
        mov     ah, LedDigits[bx]       ; al = 7654321-  (LED section flags)

        mov     al,0                    ; color 0 (all LED use color 0)

        mov     bx, (6*6)               ; n = 6 ... 0   (7 LED sections)
dl_LOOP:
        shl     ah, 1
        jnc     short dl_NEXT           ; don't draw line section ?

        ;; now draw a LED section (either vert or horz line) ;;

        push    di
        add     di, LedLines[bx]        ; [ES:DI] --> scr pixel
        mov     cx, LedLines[bx+2]      ; CX = rep count
dl_DRAW:
        mov     ES:[di], al             ; plot pixel color(0)
        add     di, LedLines[bx+4]      ; advance DI by +1 or +320
        loop    dl_DRAW
        pop     di
dl_NEXT:
        sub     bx, 6
        jns     short dl_LOOP           ; repeat for all 7 LED sections
        ret


        end     go
