    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;                                                                   ;
    ;                          Taquin game                              ;
    ;                                                                   ;
    ;    Written for the Hugi Size Competition #10 by Chaos / Germany   ;
    ;                                                                   ;
    ;     Version 3, 329 bytes, and suposed to be compiled with NASM    ;
    ;                                                                   ;
    ;    Complains, bugs, etc. can be sent to BinderEdgar@T-Online.de   ;
    ;                                                                   ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


[BITS 16]		         ;Set code generation to 16 bit mode

[ORG 0x0100]		         ;Set code start address to 0100h

%define D 256
%define LD 46h                   ; LedDigits-D
%define MD 50h                   ; Moves-D
%define MOD 58h                  ; MoveOfs-D

[SEGMENT .text]	                 ; Main code segment

         add dl,16               ; DX = DX + 16 <-- DX = DS
         mov ds,dx               ; DS = DS + 16


                                 ; I generate the grid at offset 256
                                 ; It's "safe" to rewrite this data...
                                 ; This increment brings the grid at the
                                 ; position DS:0, and I can save for each
                                 ; grid access 2 bytes (that makes a total
                                 ; of 10 bytes)

         xor bp,bp               ; initializing counter
         xor si,si               ; initializing hole

         mov dx,szOutFile-D      ; setting pointer to file name
         sub cx,cx	         ; attributes = 0


         push word 0a000h        ; push vmem address
         pop es                  ; es = 0a000h

                                 ; Moved the data here because the code
                                 ; needed to access it becomes smaller
         jmp short Start

msgMoves        db      ' after $ moves',0dh,0ah,'$'

msgWin          db      'Winning field$'

msgEsc          db      'You have quit$'

szOutFile       db      'keys',0

LedDigits       db      00010001b
                db      11011101b
                db      00111000b
                db      10001000b
                db      11000100b
                db      10000010b
                db      00000010b
                db      11010001b
                db      00000000b
                db      10000000b

Moves           dw      0000000000001111b
                dw      1000100010001000b
                dw      0001000100010001b
                dw      1111000000000000b

MoveOfs         db      -4,1,-1,4


                                 ; There is a simple function that
                                 ; creates the initial grid, namely
                                 ; G[i] = (G[i-1]-3) and 0Fh, G[0]=0
                                 ; The shortest routine I found that
                                 ; creates the grid is 9 bytes long so
                                 ; there is a 7 byte gain from using it
                                 ; instead of the given table
Start:
         mov [bx],al             ; Grid[BX] = AL
         inc bx                  ; BX = BX + 1
         sub al,3                ; AL = AL - 3
         and al,0Fh              ; AL = AL & 0Fh
         jnz Start               ; if not zero yet, loop
                                 ; Grid[16] would be zero, according to this
                                 ; function, so I use it as loop terminator

         mov ah,3ch              ; selecting function
         int 21h                 ; rewrite file
         push ax                 ; save handle

         mov al,13h              ; demanding 320x200x256
         int 10h                 ; graphic mode initialized

                                 ; the border is drawn as the 11th digit,
                                 ; with bigger line size and color 7

         mov di,320*180+89       ; set start position for the border
         mov ah,17               ; set special digit to generate border
         mov dl,7                ; set color DL = 7
         call DrawLED            ; draw border

                                 ; CH = 0, DH = 0 the whole main loop

MainLoop:

         mov di,320*(37+96)+193  ; set start position for grid (bottom, right)
         mov bl,15               ; set tile counter

L1:
         mov al,[bx]             ; AL = Grid[BX]

         mov dl,30               ; DX = 30, line counter initialized
L2:      mov cl,30               ; CL = 30, line size initialized
         rep stosb               ; draw line
         add di,290              ; update draw pointer to new line position
         dec dx                  ; DX = DX - 1
         jnz short L2            ; if not zero, loop

         aam                     ; get digits out of AL

         call DrawLED            ; draw LED digit AH
         call DrawLED            ; draw LED digit AL

         sub di,320*30+52        ; set draw pointer to new tile position

         test bl,3               ; test if grid line changed
         jnz short L3            ; if not, goto L3
         sub di,316*32           ; otherwise update draw pointer
L3:
         dec bx                  ; BX = BX - 1
         jns short L1            ; if not below zero yet, loop

         sub ax,ax               ; AX = 0
         int 16h                 ; fetch key

         pop bx                  ; get handle in BX
         push bx                 ; restore stack

         pusha                   ; save all registers
         mov [di],al             ; save AL
         inc cx                  ; one byte to write
         mov dx,di               ; dx --> al, SS <> DS so I can't use SP
         mov ah,40h              ; selecting function
         int 21h                 ; write key to output file
         popa                    ; restore all registers

         mov dl,msgEsc-D         ; set escape message

         cmp al,32               ; test quit key
         je short End            ; if pressed, terminate the program

         sub al,'2'              ; AL = AL - 50
         test al,249             ; If the key is allowed this test will
         jnz short MainLoop      ; return 0


         mov bl,al               ; BX = AL, BH is assumed 0
         bt [MD+bx],si           ; test if the move is allowed
         jc short MainLoop       ; if not, loop

         shr bx,1                ; BX = BX / 2
         movsx bx,[MOD+bx]       ; set increment to new hole position

         xchg ch,[si+bx]         ; this exchanges the values of grid[si] and
         xchg ch,[si]            ; grid[si+bx]. CH is assumed zero

         lea si,[si+bx]          ; update hole position

         inc bp                  ; update counter

         mov bx,15               ; initialize loop counter

Tst:     cmp [bx],bl             ; compare Grid[BX] with BL
         jne short MainLoop      ; if not equal, no win
Cont:    dec bx                  ; decrease counter
         jnz short Tst           ; if not zero yet, loop
                                 ; I don't have to test the zero value
                                 ; because if all other are correct Grid[0]
                                 ; must be correct, too. Saves one byte in
                                 ; the drawing routine, I can assume
                                 ; BH = 0

         mov dl,msgWin-D         ; set win message, the grid passed the test
End:
         pop ax                  ; dummy pop in order to clean the stack

         mov al,3                ; set AX=3
         int 10h                 ; return to text mode

         mov ah,9                ; set DOS function
         int 21h                 ; print exit message, DX is already set

         mov dl,msgMoves-D       ; DX --> "after $..."
         int 21h                 ; print message, AH is assumed 9

         mov ax,bp               ; set AX = Counter
         mov bl,msgMoves+8-D     ; set BX <-- BH = 0
         mov cl,10               ; preparing for conversion

                                 ; At this moment BX points to :
                                 ; ' moves',0Dh,0Ah

                                 ; decimal conversion routine
Convert:
         dec bx                  ; decrease BX
         cwd                     ; if AX > -1 then DX = 0
         div cx                  ; divide with 10
         add dl,'0'              ; make the reminder an ASCII digit
         mov [bx],dl             ; store the digit
         or ax,ax                ; test AX=0
         jnz short Convert       ; if not, loop

                                 ; now BX points to something like this
                                 ; "<n> moves..."

         mov dx,bx               ; DX = BX, the pointer to the last digit
         mov ah,9                ; select function
         int 21h                 ; print "<n> moves",0Dh,0Ah

                                 ; ret isn't used here because I don't really
                                 ; need it. The following code is harmless
                                 ; because all it only has access to the
                                 ; video memory, so I use it's ret as
                                 ; program exit. Saves one byte
DrawLED:
                                 ; draws a LED digit
                                 ; expects :
                                 ; AH - Digit
                                 ; CX - LED line size
                                 ; DL - Color

                                 ; the digit is drawn using a "turtle" :-)
                                 ; defined by the pointer DI and direction BP

         pusha                   ; save all registers

         mov dh,00000101b        ; set line size increments
         mov bp,-1               ; set BP = -1    - horizontal increment
         mov si,-320             ; set SI = -320  - vertical increment
         mov bl,ah               ; set BX --> digit, BH=0 is assumed
         mov ax,7                ; set lines counter

L6:
         xchg si,bp              ; swap between horizontal/vertical lines

         cmp al,3                ; simply swapping horizontal/vertical, and
         je L9                   ; then negating makes a square, not the
         neg bp                  ; desired pattern. So, I have to handle
L9:                              ; an exception to the rule

         mov cl,129              ; set line lenght 129 - border

         or dl,dl                ; this routine is used for drawing the
         jnz NZ                  ; border, too, so I have to keep the corners
         add di,bp               ; intact when the color isn't zero
         mov cl,6                ; line length 6 - digit

NZ:      shr dh,1                ; if the bit is set, it means that this line
         adc cl,bh               ; is with +1 longer <-- BH = 0

L7:      bt [LD+bx],ax           ; test if the line is visible
         jc L8                   ; if not, don't set pixel on the screen
         mov [es:di+6-320*16],dl ; otherwise, set the pixel with the color DL
L8:      add di,bp               ; update pointer position
         loop L7                 ; loop

         dec ax                  ; decrease AX
         jns L6                  ; if still bigger than -1, loop

         popa                    ; restore all registers

         mov ah,al               ; I do this here so that I don't have to
         lea di,[di+10]          ; use a 4 byte jump in the main loop

         ret                     ; return