;		ENTRY FOR HUGI #10 - TAQUIN puzzle
;		Akos Fekete (Chut) - HUNGARY
;		feketeakos@matavnet.hu

		.186

Taquin		Segment
		Assume	cs:Taquin,ds:Taquin
		Org	0100h

 ;------------- Initialize -------------

Start:		mov	bp,128+129*320		;
		push	bp			;
		lea	dx,FileName		;
		lea	di,Grid			;
		mov	si,di			; FIRST HOLE POSITON
GenerateGrid:	stosb				;  pole position :)
		add	ax,402Dh		;
MovingTable:	sti				;
		jnc	SkipMarker		;
		stosb				; 6D-4B-45-59-53 marker
SkipMarker:	inc	word ptr [bp+si+05h]	; 00 0D 0A 07 24 marker
		and	al,0Fh			; 04 01 0E 0B 28 marker
		loopnz	GenerateGrid		; 08 05 02 0F 2C marker
		mov	al,13h			; 0C 09 06 03 20 marker
		rep	stosb			; 13-13-13-13-13 marker
		int	10h			;

		mov	ax,3C07h		;
		pop	es			; ES=A1C0 - video segment
		mov	di,95+35*320+1-7168	;
DrawFrame:	mov	es:[di+bp],al		;
		sub	bp,321			;
		mov	es:[di+bp-128],al	;
		mov	es:[di+129*320-1],al	;
		stosb				;
		jnc	DrawFrame		; BP=FFFF - counter

		int	21h			;
		push	ax			;

 ;------------- Main Section -----------

DrawTiles:	push	si			; HOLE POSITON
		mov	di,97+(5*320)+4*32-7168	; video pointer
		lea	si,Grid			; tile datas

		cwd				; order counter
LineFeed:	add	di,32*320-4*32		;

GetTileCode:	lodsb				;
		cmp	al,30h			; markers
		ja	LineFeed		;
		je	CheckBoard		;
		cmp	al,dl			;
		adc	dx,30*256+1		;
FillTile:	mov	cl,30			; 30x30 pixels
		rep	stosb			;
		add	di,320-30		;
		dec	dh			;
		jnz	FillTile		;

		aam				;
DrawDigit:	xchg	al,ah			;
		pusha				;
		lea	bx,DigitLines		;
		xlatb				; digit descriptor
		xchg	ax,bx			;

		lea	si,SegmentDatas-2	;
NextSegment:	lodsw				; relative segment position
		jc	CheckDigit		; validity

DirectionOK:	shr	ax,1			;
		adc	cl,6			;
		push	di			;
		sub	di,ax			;
		and	al,00000010b		; direction detector bit
		DB	0D6h			;
DrawSegment:	stosb				; color 0
		jz	Horizontal		;
		add	di,319			;
Horizontal:	loop	DrawSegment		;
		pop	di			;

CheckDigit:	shl	bl,1			;
		jnz	NextSegment		;

		popa				;
		add	di,10			;
		xor	si,sp			; 2 digits
		js	DrawDigit		;

		add	di,-20-(30*320)+32	; new top-left corner
		jmp	GetTileCode		;

CheckBoard:	xchg	ax,dx			; winning filed -> AH=01
		cmp	al,10h			;
		mov	dl,low(offset WinMsg)	;
		pop	si			; HOLE POSITION
		je	Exit			;
		int	16h			; wait for key
		inc	cx			;
		pop	bx			;
		push	bx			;
		mov	ah,40h			;
		push	ax			;
		mov	dx,sp			;
		int	21h			;
		pop	ax			;

CheckKeys:	cmp	al,' '			; chars
		je	Quit			;
		sub	al,32h			;
		test	al,11111001b		;
Refresh:	jnz	DrawTiles		;

		lea	bx,MovingTable		; directions
		xlatb				;
		cbw				;
		xchg	ax,bx			;

		cmp	al,[si+bx]		;
		jbe	Invalid			; out of grid (marker)
		inc	bp			;
		xchg	ch,[si+bx]		; MOVING...
		xchg	ch,[si]			;
		add	si,bx			; NEW HOLE POSITION
Invalid:	jmp	Refresh			;

 ;------------- Print Messages ---------

WinMsg		DB	"Winning field$"	;
QuitMsg		DB	"You have quit$"	;
After		DB	" after $"		;
MovesMsg	DB	" moves",0Dh,0Ah,"$"	;

Quit:		lea	dx,QuitMsg		;
Exit:		pop	ax			;
		mov	al,03h			;
		int	10h			;
		call	PrintText		;
		mov	dl,low (offset After)	;
		int	21h			;

		std				; backward
		push	ds			;
		pop	es			;
		lea	di,MovesMsg-1		; place of the last digit
		mov	cl,10			;
Decimalize:	inc	bp			; correction
		cwd				;
		xchg	ax,bp			; 0..65535
		div	cx			;
		xchg	ax,bp			;
		xchg	ax,dx			;
		or	al,30h			;
		mov	dx,di			;
		stosb				;
		dec	bp			;
		jns	Decimalize		;

PrintText:	mov	ah,09h			;
		int	21h			;
		ret				;

 ;------------- Data Area --------------

DigitLines	DB	00000101b		; 0
		DB	10011111b		; 1
		DB	00100011b		; 2
		DB	00001011b		; 3
		DB	10011001b		; 4
		DB	01001001b		; 5
		DB	01000001b		; 6
		DB	00011101b		; 7
		DB	00000001b		; 8
		DB	00001001b		; 9

SegmentDatas	DW	2*((30*320)- 7-( 7*320))+0b ; POS. & SIZE & DIR.
		DW	2*((30*320)-13-( 8*320))+0b ; position * 2
		DW	2*((30*320)-13-(15*320))+1b ;
		DW	2*((30*320)- 7-(22*320))+0b ; 0.bit = size
		DW	2*((30*320)- 6-(15*320))+1b ;   0: 6, 1: 7 pixels
		DW	2*((30*320)- 7-(14*320))+0b ;
		DW	2*((30*320)- 6-( 8*320))+0b ;

FileName	DB	"KEYS"

Grid		DB	?

Taquin		Ends
		End	Start