;ENTRY.COM    01-28-2000    hugi compo #10 Taquin game	   redirect PRN-->KEYS!
;
;			Copyright (c) Lawrence E. Boothby, 1999
;			Contract programming - boothbyl@reed.edu
;
				.RADIX 16
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
Start:		MOV	AL,13		;AH=00 initially
		INT	10		;change mode to 320x200x256 graphics
;**************----------------*************************************************
		DB 68	;PUSHW		;1-10-2000 Ruud egroup hint ES!=A000
		DW 9F0A			;see below for why I chose this
		POP	ES		;particular value
;**************-----------------************************************************
		MOV	DI,3B7F		;9F0A:3B7F=A000:2C1F
		MOV	DX,8181
		MOV	AX,0F07		;BX=0000, CH=00 initially
		CALL	LED		;Create 82x82 frame in color 07
		;AX=0007, BX=FFFF, CX=0000, DX=8180, SI=0000, DI=3C00, BP=013F
;**************------------------------*****************************************
		XCHG	DI,AX		;AH<--3C, how handy!
		MOV	DX,OFFSET file	;CX=0000
		INT	21		;will return AX=handle=0005
		DB 0C1,4F,1Dh,08 ;ROR WORD PTR [BX+1Dh],08 redirect PRN-->KEYS
		;AX=0005, BX=FFFF, CX=0000, DX=>"keys",SI=0000, DI=0007, BP=013F
;**************------------------------*****************************************
		XOR	BP,BP		;init moves counter
		MOV	SI,3E01		;init hole offset in video memory
		DB 3Dh	;CMP AX,043C	;force CF = 1 and skips CMP AL,04 (to
		;			 make use of XOR AX,AX below)
;**************----------------------*******************************************
Continue:	CMP	AL,04
		JNB	NextKey		;less flashing if only required drawing
		MOV	DI,-2800	;assume case up or down
		JPE	WasUpDown
		MOV	DI,-0020	;change to case left or right
WasUpDown:	XCHG	CX,AX
PlusMinus:	NEG	DI
		LOOP	PlusMinus	;side benefit, it zeroes CX for below
		ADD	DI,SI		;DI<--new position
		XOR	AX,AX
		STOSB			;always safe to store a zero
		SCASB			;      CHECK FOR INVALID MOVE =
		JZ	Redraw		;<-- DON'T MOVE TILE OUTSIDE FRAME!
		XCHG	SI,DI		;update SI<--new hole position
		STD			;saves byte over SUB SI,+03
		DB 26	;ES:
		MOVSW			;swapped 1st byte of hole with tile
		CLD
		INC	BP		;increment moves counter
;**************------------------***********************************************
Redraw:		MOV	DI,0B661
		MOV	BL,0F		;start last tile
NextTile:	DB 26	;ES:		;get color
Patch1:		ADD	AL,03		;becomes MOV AL,ES:[DI]
		AND	AL,0F
		DB 60	;PUSHA
		CALL	Tile
		DB 61	;POPA
		;-------------------------
		CMP	BL,AL		;all CF=0 if valid solution
		ADC	CL,CH		;doing a solution check here,CH=00
		;-------------------------
		XCHG	DI,AX
		SUB	AL,20
		JNS	SameRow
		SUB	AX,2880
SameRow:	XCHG	DI,AX
		DEC	BL
		JNS	NextTile
		MOV	WORD PTR Patch1,058A	;MOV	AL,[DI]
		MOV	DL,LOW OFFSET msgWon
		JCXZ	Won
;**************------------------***********************************************
NextKey:	INT	16		;AH=00, wait for input
		;---------------------------
		MOV	DL,AL		;don't destroy DH=02
		MOV	AH,05		;write PRN redirected to KEYS
		INT	21		;returns AL=DL
		;---------------------------
		XOR	AH,AH		;CBW doesn't work for AL>7F
		SUB	AL,32
		ROR	AL,1
		CMP	AL,77		;= was space
		JNZ	Continue
	;	MOV	DL,LOW OFFSET msgQuit  ;(=20h already if one pad byte)
;**************-------------------------------**********************************
Won:		MOV	AL,03		;AH=00, restore text mode
		INT	10
		MOV	AH,09		;display string
		INT	21
		MOV	DL, LOW (OFFSET msgafter)
		INT	21
;-------------------------------------------------------------------------------
;1-14-2000 BEN suggested MOV DI,xxxx, DEC DI, MOV [DI],DL, MOV DX,DI. This
;allows exiting through the LED procedure saving a CALL and 2 RET's. THANKS!
;
;     The use of XCHG BP,AX to save AH=09 and making CWD safe is my own idea
;     carried over from my earlier recursive version (which used XCHG CX,AX
;     and INC CX, LOOP Digits instead of OR BP,BP)
;-------------------------------------------------------------------------------
		MOV	DI,OFFSET msgMoves
		MOV	CL,0A		;CH=00 (always), BP=number in hex
Digits:		CWD			;DX<--0000, AH=09 not destroyed
		XCHG	BP,AX		;AX<--number, save BP<--09
		DIV	CX
		XCHG	BP,AX		;BP<--number, restore AH=09
		OR	DL,30
		DEC	DI
		MOV	[DI],DL
		OR	BP,BP
		JNZ	Digits
		MOV	DX,DI
		INT	21
;**************---------------**************************************************
Tile:		MOV	DL,1E
Fill:		MOV	CL,1E
		REP	STOSB
		ADD	DI,0140-001E
		DEC	DL
		JNZ	Fill
		SUB	DI,13FA
		AAM
		PUSH	AX
		MOV	AL,AH
		CALL	OneLED		;do first digit (0 or 1)
		SCASW			;SCASW, INC DI = ADD DI,+03 = move
		INC	DI		;over for second LED digit
		POP	AX
OneLED:		MOV	BX,OFFSET TableLED
		XLAT
		DB 0D4,01 ;AAM 01	;AH<--AL<--00
		MOV	DX,0708		;BL>9E, no corner pixels
;**************-----------------************************************************
LED:		XOR	SI,SI		;if border, BL<9E, do corner pixels
		CALL	EllOne
		STD
		NEG	BP
		CALL	EllTwo
		DEC	DX		;DX<--0707 (or 8180 invisible)
		DEC	BX		;frame done, turn "off" corner pixels
		CALL	Last		;do left upper vertical segment
		CLD
EllOne:		MOV	BP,013F
EllTwo:		CALL	LineSegment	;do --> and down or <-- and up segments
LineSegment:	XCHG	SI,BP		;do -->, down, <--, or up segment
		XCHG	DL,DH
Last:		MOV	CL,DL
		DB 80,0FBh;CMP BL,9E
	;-------------------------------------------------------
	; BL controls whether rectangle will have corner pixels
	;-------------------------------------------------------
GetControl:	SAHF			;CF<--current line segment control bit
		JB	DoLineSegment
		SCASB
		DB 3C ;CMP AL,XX to skip next instruction
DoLineSegment:	STOSB
		ADD	DI,BP
		LOOP	GetControl
		SHR	AH,1
		RET
;*******************************************************************************
;		   0   1  2   3	 4  5  6  7  8	9
TableLED	DB 7E,42,6Dh,67,53,37,3F,72,7F,77
;	Warning! The low offset (BL) must be >9E for corner pixel logic
;*******************************************************************************
;	Warning! The high message offsets must all be DH=02
msgMoves	DB ' moves',0Dh,0Ah,'$'
msgafter	DB ' after $'
msgWon		DB 'Winning field$'
		NOP		;need to pad to save MOV DL,offset msgQuit
msgQuit		DB 'You have quit$'
file		DB 'keys',00
;*******************************************************************************
ONLY	ENDS
END	Start
