; Hugi competition #10
;
; Author: Istvn Marosi, Hungary
; e-mail: recosoft@mail.matav.hu
; web:	  http://www.sch.bme.hu/~marosi
;
; compiled with masm
; 327 bytes
;
	.386
	page	100,130
ASRT=0

assert	macro	expr
	local	ok
if ASRT
	cmp	expr
	je	ok
	mov	dl,'!'
	mov	ah,2
	int	21h
	int	20h
ok:
endif
endm

code	segment use16
	assume	cs:code,ds:code,ss:code
	org	100h

; regs: ax=0, bx=0, cx=ff, dx=ds=cs=es=ss>80, si=100, di=-2, bp=9xx, sp=-2

main:
; bh=0 throughout the program
; cx=0 most of the time (after cycles). ch=0 every time

	assert	<ah,0>		;
	assert	<bx,0>		; These are the values used!
	assert	<cx,0ffh>	;

; Well, al & ah could be 0ffh, if the FCB pointers in the parameter block
; of the calling int21/4B00 are NULLs !!!
;
; Anyway, I saw examples from previous Hugi compos assuming ah=0,
; so I do it so, too :)

;------
	call	drawFrame	; out: bx unchanged, cx=0
;
	mov	dx,offset keys
	mov	ah,3ch
	int	21h
	xchg	ax,bx	; bx <- handle	; less than 256! bh=0!
			; ax <- 0
;=======================
; Tile (slot) sizes
WT	equ	30
HT	equ	30
FWT	equ	WT+2	; +gap	Full Width of a Tile
FHT	equ	HT+2	; +gap

;;XF	  equ	  95	  ; frame
;;YF	  equ	  35
XF	equ	255	; frame at segment a000+paras
YF	equ	0

WF	equ	130
HF	equ	130

X0	equ	XF+2	; top left slot
Y0	equ	YF+2

; 7 Segment display sizes
WS	equ	6		; width
HST	equ	6		; height on top
HSB	equ	7		; height on bottom
; WS=HST=HSB-1

SX0	equ	6	; rel coord of seg0 (left digit)
SY0	equ	8+HST+1

SXD	equ	10	; distance between digits (width+gap)

; the segment gap is 1
SX6	equ	SX0+1		; rel coord of seg6
SY6	equ	SY0+HSB

;
; es:di points to the actual screen position throughout drawall

;------------------------
	mov	bp,offset table ; actual hole pointer
step:			; draw all
; draw slots
	cwd	; ah=0 positive --> dh=dl=0: "win" calculator

	mov	di,Y0*320+X0
	mov	si,offset table
slots:
	mov	cl,4
slot:
	lodsb		; both label value & color of actual tile
;
; check "win" condition
	inc	dx	; inc dl effectively
	cmp	al,dl	; if in good order, cy all 16 times
	adc	dh,ch	;		->  inc dh

	pusha	; bx,cx,di
	mov	ah,WT	; =HT
	call	drawSquare	; out: cx=0
	call	drawLabel	; draw the 2 digits
	popa
;
; Step to next slot on the right
;
	add	di,FWT
	loop	slot

	lodsb				; eat terminating code (-1 or 'Y')
	lea	di,[di+FHT*320-4*FWT-1] ; next line

	scasb		; es:[di]=0..15   di++
	js	short slots		; al=-1: more slots
;------------------------	drawing ready
;
; Is it done? dh=16 if done, fewer if not.
	inc	cx

	cmp	dl,dh		; dl=16: if dh=16, good!
	je	short solved	; cx=1, si=offset txSolved, ah=0

;
; next key
;...... cbw		; ah=0
	int	16h
	mov	ah,0
; Hmm. If there were no international keyboards used (and no ALT-xxx keys, too)
; producing >80h accented keys, cbw could be used saving 1 more byte.

;
; bx=handle
;
	push	ax
	mov	dx,sp
	mov	ah,40h
	int	21h	; cx=1
	pop	ax
;

	dec	si

	cmp	al,' '
	je	short finished	; cx=1, si=offset txQuit, ah=0
	sub	al,'2'
	shr	al,1
	jc	short step_
	cmp	al,3		; 0,1,2,3
	ja	short step_

;-------------------------------
; Move...
; bp=hole pointer
	add	si,ax		; original si = txQuit
moves_txQuit equ 30h	; moves - txQuit
	movsx	di,byte ptr [si+moves_txQuit]	; di=relative distance

	cmp	byte ptr [bp+di],15
	ja	short step_

; legal move!
; (ch=0)
	xchg	ch,[bp+di]		; swap tile & hole   -> new pos = 0
	xchg	ch,[bp] 		;		     -> old pos = tile
	add	bp,di	; new hole pointer			ch=0 again!

; inc MovesCounter:
	mov	si,offset txMoves
incNx:	dec	si		; ah=0
	mov	al,[si]
	inc	ax
	aaa			; 3Ah->0, ah=1
	or	al,'0'
	mov	[si],al
	sahf			; 1 -> cy
	cbw
	jc	incNx

; ah=0!
step_:	jmp	step	; redraw everything
;===============================
segs	macro	aa,bb,cc,dd,ee
	db	aa&1b,bb&1b,cc&1b,dd&1b,ee&1b	   ; bit 0 is always on
endm
;--------
;  4444 	All segments drawn from the top left corner right or down
; 2    3	Bits are true for "on" segments. Bit7..Bit1 are seg0..seg6
; 2    3
;  5555
; 0    1
; 0    1
; 0    1
;  6666
;	    seg 0123456
seg7	label	byte
;		0	1	2	3	4
	segs	1111101,0101000,1001111,0101111,0111010
;		5	6	7	8	9
	segs	0110111,1110111,0111100,1111111,0111111

Hseg7	equ	1	; offset seg7 / 256
oHseg7	equ	main	; 100h
; seg7<180h, so a sign-extended byte offset from 100h is enough

;========

stepSeg:
	dw	SY0*320+SX0 -2
	db	1*10h+HSB
	dw	WS+1 -2
	db	1*10h+HSB
	dw	-(HST+1)*320-(WS+1) -2
	db	1*10h+HST
	dw	WS+1 -2
	db	1*10h+HST
	dw	-320-WS -2
	db	WS*10h+1
	dw	(HST+1)*320 -2
	db	WS*10h+1
	dw	(HSB+1)*320 -2
	db	WS*10h+1
	dw	-SY6*320-SX6+SXD -2
; the next byte is 'mov al,3' = b0 = multiple of 16, will terminate the cycle

;=================================================================

finished:
;-------
solved:
;
; terminate
	mov	al,3		; ah=0
	int	10h	; mode 3

	call	prStr	; cx=1, si=txSolved or txQuit

	or	si,cx		; txAfter
	dec	cx	; cx=0

prStr:	lodsb
	cmp	al,0
	je	short prStr
	jl	short prEnd	; neg: End of String. ret: Terminate Program
	add	si,cx		; skip merged byte (if any)
	xchg	dx,ax	; dl<-al
	mov	ah,2
	int	21h
	jmp	short prStr

;-------------------------------
drawFrame:
; cx=00ff
; ah=0
	mov	al,13h	; ah=0!
	int	10h		; mode 13

paras	equ	690	; 690=11040/16 where 11040=35*320+95-255 where 255=cx
	push	0a000h+paras			;  Y=35   X=95 (a000 based!)
	pop	es

	mov	di,cx		; di <- 255
;.....	mov	di,YF*320+XF	; =255
	mov	ax,WF*256+7	; ah=width, al=frame color
	call	drawSquare

	mov	di,(YF+1)*320+XF+1
	mov	ax,(WF-2)*256	; middle is background color (0)
drawSquare:
; ah=width=height, al=color, di=address (ch=0)
	mov	cl,ah
drawRect:
; ah=width, cl=height, al=color, di=address (ch=0)
	push	di
drRc:
	pusha	; cx,di
	mov	cl,ah
	rep stosb
	popa
	add	di,320
	loop	drRc
	pop	di
prEnd:
	ret	; cx=0
;-----------------------------------------
drawLabel:
	aam	; ah=first, al=last digit
	push	ax
	mov	bl,ah
	call	segments	; draw one digit in BL as 7 segments
	pop	bx
segments:
	mov	si,offset stepSeg
	mov	bh,Hseg7	; bx=seg7 index
drawSeg:
	add	di,[si]
	cmpsw		; add si,2 di,2
	lodsb
	rol	byte ptr [seg7+bx-oHseg7],1	; rotates around 8 times
	jnc	drawSeg
; true bits are "on" segments (the last one is "on", too)
	db	0d4h,16 ; aam 16	ah=width  al=height
	jz	prEnd
	xchg	al,cl	;		ah=width  al=0	 cl=height
	call	drawRect
	jmp	drawSeg

;========================================
if ($-main) and 1
	db	'X' ; extra byte to make txAfter unpair -- hopefully unneeded
%out Oops... pair :(
endif
			; previous byte is also > 15
keys	db	'KEYS'  ; terminating 0 is at table     ; codes > 15
;----------------------------------------
table	db	0,13,10,7	,-1
	db	4,1,14,11	,-1
	db	8,5,2,15	,-1
	db	12,9,6,3
;				; 'Y' != -1
txQuit	db	'YWoiun nhianvge  fqiueiltd',-1,-1      ; codes > 15
		; txQuit('You have quit')+txSolved('Winning field') merged
txAfter  db	' after '
	 db	0,0,0,0,'0'
txMoves  db	' moves',0dh,0ah        ; terminated by -5 at moves
; Counts up to 99999 moves. If 9999 (or 999) were enough, 1 (or 2) zeroes
; could be removed.

;-------
;		2	4	6	8
;		down	left	right	up
moves	db	-5,	1,	-1,	5

.errnz moves_txQuit - (moves-txQuit)

code	ends
	end	main