; TAQUIN game for Hugi Size Compo #10
;Coded by Metalbrain (metalb@bart.us.es) from Spain
;Use NASM to compile
;
;Current size: 333 bytes

                org     256
                mov     di,09ce4h       ;screen segment, with xxxxx100xxxxx100
                mov     si,di
setgrid         aam     16
                stosb
                sub     ax,0c403h       ;Last step with AH=3Ch
                loop    setgrid         ;Set initial grid
                mov     dx,filename
                int     33              ;Open outfile
                push    ax              ;Handle in stack
                mov     al,13h
                int     10h             ;Screen mode 320x200x256
                push    si
                pop     es              ;Set screen segment
                mov     di,24160        ;Coords (225,35)
                mov     ah,7            ;Color
                mov     bx,3843         ;Draw segments 0 to 3, all coloured
                mov     cl,191          ;Will be transformed to 129
                call    drawsegments    ;Draw a segment

                                        ;Draw Grid
again           mov     bp,15
anotherblock    mov     ax,bp           ;Position in AX to calculate di
                mov     di,24673        ;Coords (97,37)
                aam     4
                aad     80
                shl     ax,5
                shl     ah,2
                add     di,ax           ;Now DI has the start point
                mov     al,[bp+si]      ;Get color & number
                mov     bx,30
drawblock       mov     cl,30
                rep     stosb           ;Draw a line of the block
                add     di,290          ;Beginning of next line
                dec     bx
                jnz     drawblock       ;Draw all block
                mov     bh,al           ;BH=color
                aam                     ;AH=led1, AL=led2
                mov     cl,2            ;2 LED ciphers
drawled         pusha                   ;Preserve AH, BH, DI and BP
                cbw                                           ;TABLE
tablekeys       sub     di,5104         ;Start point          ;91  EF* F0  13*
                xchg    ax,bx           ;                     ;93
                mov     bh,[bx+leddigits];Get leds to print   ;8A* BF  27* 02
                mov     bl,6            ;Led counter, from 6 to 0
                mov     cl,2            ;Will be transformed to 6 or 7
                call    drawsegments

                popa
                mov     al,ah           ;Next led
                sub     di,byte 10
                loop    drawled         ;Next cipher
                dec     bp              ;Next block
                jns     anotherblock

                cbw
                int     16h             ;Read key
                pop     bx              ;Get handle
                push    bx              ;And keep it again
                push    ax              ;Keep key pressed
                mov     dx,sp           ;Point to key pressed
                inc     cx              ;1 byte to write
                mov     ah,40h
                int     33              ;Write to KEYS file
                pop     ax
                cmp     al,20h
                mov     dx,messagelose
                jz      exitloose       ;If it's no SPACE, continue

                                        ;Key   2     4      6      8
                                        ;AL=  50    52     54     56
                sub     al,50           ;AL=   0     2      4      6 ;Thx Chut
                test    al,249          ;Test if valid (00000xx0)
toagain         jnz     again           ;Invalid key, continue
                mov     bx,tablekeys+1  ;Table for moves

                xlatb                   ;AL= EFh    13h    8Ah    27h
                and     al,0ch          ;AL= 0Ch    00h    08h    04h
                xor     al,0c0h         ;AL= CCh    C0h    C8h    C4h
                mov     [puthere+1],al  ;    dec ah inc al dec al inc ah
curpos          mov     al,0            ;Get offset
                aam     4               ;Translate offset to position
puthere         inc     ah              ;Update cursor position
                test    ax,si           ;Test if valid (-----0xx-----0xx)
                jnz     toagain         ;Invalid move, continue
                inc     word [bx+73h]
                                        ;Increase number of moves
                aad     4               ;Translate cursor position to offset
                mov     bp,ax           ;New cursor position in BP
                xchg    [bx+41h],al     ;Set new cursor position, take old
                xchg    ax,bx           ;Old cursor position in BX
                xchg    ch,[si+bp]      ;\
                xchg    [si+bx],ch      ;-Swap

                mov     bl,15           ; n = 15 ... 0
cw_loop         cmp     [bx+si],bl
                jnz     toagain         ; is grid[n] <> n ?
                dec     bx
                jnz     cw_loop
                mov     dl,messagewin-256
exitloose       pop     ax              ;Handle, not useful anymore, with AH=0
                mov     al,3
                int     10h             ;Set text mode         
                call    printmess       ;Set first part of message
                call    printmess
                push    word lastmes
nmoves          mov     ax,0
                mov     cl,10           ;Divisor value
ax2dec          push    dx
                xor     dx,dx
                div     cx              ;Next cipher in DL
                and     ax,ax           ;If result is zero
                jz      decdone         ;End it
                call    ax2dec          ;And continue with next one
decdone         xchg    ax,dx           ;Cipher in AL
                or      al,30h          ;Cipher to char
                int     29h             ;Output char
                pop     dx              ;Next cipher to print or old value
                ret

lastmes         mov     dl,messageall2-256;Final part of message
printmess       mov     ah,9
                int     33              ;Print
                                        ;Fall down to next ret
drawsegments    push    cx
                shr     bh,1
                push    bx
                salc
                and     al,ah           ;Set color in AL
                mov     dx,-320         ;Vertical
                shr     bl,1
                jnc     vert
                cwd                     ;Horizontal
                inc     dx
                rcr     bl,1            ;No carry for horizontal lines
                jnc     nonegate
vert            jp      nonegate
                neg     dx              ;down or left
nonegate        cmp     bl,cl           ;Set carry for border and leds 0 and 2
                inc     cx
                adc     cl,cl
                js      putpoint        ;No corner hole for border
                add     di,dx           ;First position for leds
putpoint        stosb
                dec     di
                add     di,dx
                loop    putpoint        ;Set segment
                pop     bx
filename        db      "KeYs",0        ;Hidden pop cx and dec bx inside
                jns     drawsegments    ;Draw all segments
                mov     dx,messageall1
                ret
messageall1     db ' after $'
messageall2     db ' moves',0dh,0ah,'$'

                ;       -0123456 (- must be 0 for dec bx to set s)
leddigits       db      00001000b       ;0      Digit
                db      00111011b       ;1       55
                db      01000001b       ;2      6  4
                db      00010001b       ;3      6  4
                db      00110010b       ;4       33
                db      00010100b       ;5      2  0
                db      00000100b       ;6      2  0
                db      00111000b       ;7      2  0
                db      00000000b       ;8       11
                db      00010000b       ;9
messagewin      db 'Winning field$'
messagelose     db 'You have quit$'
