; I'm very proud to present my first attempt to this kind of competition !
; I'm relatively new to the asm world so I thinked to do this compo even
; in 1000 bytes will be great :-)
; I'm sorry for my bad english and for some of the comments and labels who are
; still writen in french.
;
; version 1 - 542 bytes !!!
;     After three days of hard work, I finally made it. You know I learned a
;     lot of interesting stuff even if the size is... humm... big.
;
; version 2 - 461 bytes
;     I really doesn't think I could do that. You know what ? I'm happy :-)
;     Simply some basic stuff, two tables generated at run-time and an (little)
;     improved word_to_string routine.
;
; version 3 - 457 bytes
;     No more time to do a shorter & better program...
;     See you in the next compo.
;
; version 4 - 458 bytes :-(
;     One bug corrected.
;
; Xavier Nayrac
; France

.286
MAIN    SEGMENT
ASSUME  cs:main, ds:main
      
        org 100h

start:
;------------------------------------------------------------------------------

set_vga_13h:
    mov     ax, 0013h
    int     10h    

;------------------------------------------------------------------------------
; Set the grilleCoord table
;------------------------------------------------------------------------------

    mov     ax, 11937              ; Top-left corner of first square.
    mov     di, offset grilleCoord

    mov     cl, 4                  ; I assume CX = 00FFh
sgc_for_i:    
    mov     bx, 4
sgc_for_j:        
    stosw                           ; ES = DS
    add     ax, 32
    dec     bx
    jnz     short sgc_for_j
    
    add     ax, 10112
    loop    sgc_for_i

;------------------------------------------------------------------------------
; Set the grille table
;------------------------------------------------------------------------------
    mov     cl, 16                  ; CH is already zero
    mov     ax, cx
    ;mov     di, offset grille      ; DI already points to offset grille.
set_grille:    
    stosb
    and     byte ptr [di-1], 0Fh
    sub     al, 3    
    loop    set_grille
    
;------------------------------------------------------------------------------
; ES point to VRAM
;------------------------------------------------------------------------------

    push    0A000h
    pop     es

;------------------------------------------------------------------------------

create_file:
    mov     ah, 3Ch
    lea     dx, szFilename
    ;xor     cx, cx      ; CX is already set to zero
    int     21h
    ;mov     hFile, ax
    push    ax       ; Plus besoin du handle en mmoire
    
;------------------------------------------------------------------------------
; Draw the sides.
;------------------------------------------------------------------------------

    mov     al, 7        
    mov     di, 95+(35*320)                 ; Top-left corner
    mov     si, di
    mov     cx, 130                         ; 130 pixels width
sides:                    
    mov     es:[di + (164 - 35) * 320], al  ; Bottom line
    stosb                                   ; Top line
    mov     es:[si], al                     ; Left line
    mov     es:[si+129], al                 ; Right line
    add     si, 320
    loop    sides
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
; Dessiner la grille de jeu
;------------------------------------------------------------------------------

update_screen:
    mov     si, 0                           ; Pour case = 0..15
loop_dessin:
    mov     al, byte ptr [grille + si]     ; Couleur du carr et en mme temps
                                            ;   { numro  crire (leds).
    shl     si, 1                           ; SI = SI * 2 pour aligner
                                            ;   { grilleCoord sur un word.
    mov     di, word ptr [grilleCoord + si] ; Adresse VRAM du carr.
        
; Dessine un carr    
    mov     bl, 30 ; 30 lines height. BH was previously set to zero.
square_start:
    mov     cx, 30                          ; Une ligne fait 30 pixels.
    rep     stosb                           ; Dessiner !        
    add     di, 320 - 30                    ; On passe  la ligne suivante.
    dec     bx                              ; Une ligne en moins au compteur.
    jnz     short square_start              ; Si zro, le carr est fini.
    

; Dessiner les leds                           Led gauche       Led droite
    aam                                     ; AH = AL / 10     AL = AL modulo 10
    ;xor     bx, bx                         ; BX was previously set to zero.
    mov     bl, ah                          ; BX = chiffre de la led gauche
    mov     dh, byte ptr [LedDigits + bx]   ; DH = reprsentation binaire de la
                                            ;  { led gauche
    xor     bx, bx
    mov     bl, al
    mov     dl, byte ptr [LedDigits + bx]   ; DL = reprsentation binaire de la
                                            ;  { led droite   
    xor     al, al                          ; grille 0
draw_led:    
    mov     bx, 7                           ; 
loop_section:    
    mov     di, word ptr [grilleCoord + si] ; Adresse VRAM du carr.   
    shl     dh, 1                           ; lire section dans carry flag
    jnc     short next_section
   
    shl     bx, 1                           ; aligner sur un mot
    add     di, word ptr[SectionOffset + bx]
    shr     bx, 1
    test    dl, dl
    jnz     short its_first_led
    add     di, 10
its_first_led:    
    mov     cl, byte ptr[sectionSize + bx]
    cmp     bx, 4
    jle     short vline
    rep     stosb                           ; hline
    jmp     short next_section              
vline:
    mov     es:[di], al
    add     di, 320
    loop    vline
next_section:
    dec     bx
    jnz     short loop_section

    shl     dx, 8
    test    dh, dh
    jnz     short draw_led
    


    shr     si, 1                           ; Restorer SI.   
    inc     si                              ; Un carr de plus au compteur.
    cmp     si, 16                          ; Si on a dessiner 16 carrs
    jnz     short loop_dessin               ;   { c'est fini.
;------------------------------------------------------------------------------
    
;------------------------------------------------------------------------------
; Attends l'appui sur une touche
;------------------------------------------------------------------------------  
wait4key:    
    xor     ax, ax
    int     16h   

;------------------------------------------------------------------------------
; Write key to the file
;------------------------------------------------------------------------------

    pop     bx        ; file handle
    push    ax
    mov     cl, 1     ; INC CX doesn't work. Why ?
    mov     dx,sp
    ;mov     bx,hFile
    mov     ah,40h
    int     21h
    pop     ax
    push    bx       ; file handle

;------------------------------------------------------------------------------
; Look for the [QUIT] key
;------------------------------------------------------------------------------

    cmp     al, 20h
    mov     dx, offset msgEsc
    jz      short set_text_mode


;------------------------------------------------------------------------------
; Look for the [2] [8] [4] [6] key and valid move
;------------------------------------------------------------------------------
    ; *** Code from the example ***
    mov     di,  4                  ;               (+0, +1)
    mov     cl, 0100b               ; down
    cmp     al, '8'
    jz      short try_move          ; [8] ?

    neg     di                      ;               (+0, -1)
    mov     cl, 1000b               ; up
    cmp     al, '2'
    jz      short try_move          ; [2] ?

    mov     di,  1                  ;               (+1, +0)
    mov     cl, 0001b               ; right
    cmp     al, '4'
    jz      short try_move          ; [4] ?

    neg     di                      ;               (-1, +0)
    mov     cl, 0010b               ; left
    cmp     al, '6'
   
    jnz     short wait4key

  


;; Attempt Move(DI) direction(CL)  ; *** Code from the example ***
try_move:

    mov     bx, [holePos]
    test    validMoves[bx],  cl
    jz      short badMove           ; is it a bad move (ie. at border) ?

    mov     al, grille [bx+di]      ; Valeur  remplacer
    mov     grille [bx], al         ; On la met dans le trou
    mov     byte ptr grille [bx + di], 0     ; Nouveau trou
    add     [holePos],  di          ; update hole (x, y) position

    inc     [movesCounter]          ; MovesCounter + 1
badMove:

;; ZF=Check for WIN condition ; *** Code from the example ***
CheckWin:
        

        mov     bx, 15                  ; n = 15 ... 0
cw_loop:
        cmp     byte ptr grille [bx], bl
        jnz     short cw_nope           ; is grid[n] <> n ?
        dec     bx
        jns     short cw_loop
cw_nope:
        inc     bx                      ; ZF = done,    NZ = fail
    
    lea     dx,  msgWin
    jz      short set_text_mode
    jmp     update_screen
                                       


set_text_mode:
    mov     ax, 0003h
    int     10h
    
print_message:
    mov     ah, 9
    int     21h

close_file:
    mov     ah, 3Eh
    pop     bx          ; file handle
    int     21h

;------------------------------------------------------------------------------
; Make a decimal string with a word
;------------------------------------------------------------------------------

    mov     ax, [movesCounter]
    lea     bx, msgMoves - 1
    mov     si, 10
mds_repeat:
    xor     dx, dx
    div     si
    add     dl, '0'
    mov     byte ptr [bx], dl
    dec     bx
    
    test    ax, ax
    jnz     short mds_repeat
    
    inc     bx
    
;------------------------------------------------------------------------------
; Print the final part of the message.  
;------------------------------------------------------------------------------
    xchg    dx, bx
    mov     ah, 9
    int     21h 

;------------------------------------------------------------------------------
; Back to DOS
;------------------------------------------------------------------------------

    mov     ax, 4C00h
    int     21h





 

;------------------------------------------------------------------------------
; Les donnes du programme
;------------------------------------------------------------------------------






; 7x 1-bit flags for the LED char sections ;;
;
;            777777 
;           4      3    
;           4      3
;           4      3
;           4      3
;           4      3
;           4      3
;            666666
;           2      1   
;           2      1
;           2      1
;           2      1
;           2      1
;           2      1
;           2      1
;            555555

;                       7654321
LedDigits       db      10111110b       ;[0]    '0' char
                db      00001010b       ;[1]    '1' char
                db      11101100b       ;[2]    '2' char
                db      11101010b       ;[3]    '3' char
                db      01011010b       ;[4]    '4' char
                db      11110010b       ;[5]    '5' char
                db      11110110b       ;[6]    '6' char
                db      10011010b       ;[7]    '7' char
SectionOffset   db      11111110b       ;[8]    '8' char
                db      11111010b       ;[9]    '9' char
; Dplacement dans la VRAM (en octet) par rapport au top-left corner d'un carr.
; Ces offset sont pour la led de gauche. Pour la droite il faut ajouter 10.
;
;                        x    y                       
                dw      13 + 15 * 320   ; Section 1
                dw       6 + 15 * 320   ; Section 2 
                dw       13 + 8 * 320   ; Section 3
                dw        6 + 8 * 320   ; Section 4
                dw      7 +  22 * 320   ; Section 5
                dw       7 +  14 * 320   ; Section 6
                dw       7 +  7 * 320   ; Section 7



;                       UDLR
;                       ----
validMoves      db      0101b           ; [0]   - allow  DOWN or RIGHT moves
                db      0111b           ; [1]
                db      0111b           ; [2]
                db      0110b           ; [3]

                db      1101b           ; [4]
                db      1111b           ; [5]
                db      1111b           ; [6]
                db      1110b           ; [7]

                db      1101b           ; [8]
                db      1111b           ; [9]
                db      1111b           ; [10]
                db      1110b           ; [11]

                db      1001b           ; [12]
                db      1011b           ; [13]
                db      1011b           ; [14]
sectionSize     db      1010b           ; [15]
                
                db       7, 7, 6, 6, 6, 6, 6                

szFilename      db      'KEYS'; No need for a zero, the movesCounter do it well
movesCounter    dw      0
holePos         dw      0

msgWin          db 'Winning field after $'
msgEsc          db 'You have quit after $'
msgMoves        db ' moves',0dh,0ah,'$'



grilleCoord     dw    16 dup (?)
            ;dw      11937, 11969, 12001, 12033  ; -----> + 32
            ;dw      22177, 22209, 22241, 22273  ; |
            ;dw      32417, 32449, 32481, 32513  ; |
            ;dw      42657, 42689, 42721, 42753  ;\/ + 10240

grille          db    16 dup (?)
            ;db       0, 13, 10, 07
            ;db      04, 01, 14, 11
            ;db      08, 05, 02, 15
            ;db      12, 09, 06, 03


MAIN  ENDS
      END start
