;Hugi Size Coding Competition #10 entry (Taquin Puzzle)
;Ray M. Ransom
;Big Bear City, California, USA
;ray@micosyen.com
;http://www.micosyen.com

	.MODEL	TINY			;12/22/99
	.386
	.CODE
	ORG	100H

VARBLE	STRUC
	DB	00,13,10,07		;PUZZLE STATE
	DB	04,01,14,11		;0 = HOLE
	DB	08,05,02,15		;INDEX = Y*4+X
	DB	12,09,06,03
MOVIDX	DB	-4			;2 (DOWN) MOVE TILE INDEX ADDENDS
	DB	1			;4 (LEFT)
	DB	-1			;6 (RIGHT)
	DB	4			;8 (UP)
SEGTBL	DW	15*320-13		;e  SEGMENT SUBRAHENDS
	DW	15*320-6		;a
	DW	22*320-13		;d
	DW	22*320-6		;b
	DW	8*320-7			;f
	DW	16*320-7		;g
	DW	23*320-7		;c
SEGDAT	DB	01111101B		;0
	DB	01010000B		;1
	DB	00110111B		;2
	DB	01010111B		;3
	DB	01011010B		;4
	DB	01001111B		;5
	DB	01101111B		;6
	DB	01011001B		;7
	DB	01111111B		;8
	DB	01011111B		;9
VARBLE	ENDS

START:	POP	CX			;CLEAR CX
	CALL	START1

STKFRM:	DW	0A000H			;SCREEN SEGMENT
	DW	130*256+7
;		 |      |______________  PIXEL COLOR
;		 |_____________________  BOX SIDE LENGTH
	DW	320*35+95		;POINT TO 95,35
	DW	FLBOX2			;DUMMY RETURN ADDRESS AFTER 1st FILBOX
	DW	128*256+0
;		 |      |______________  PIXEL COLOR
;		 |_____________________  BOX SIDE LENGTH
	DW	320*36+96		;POINT TO 96,36
	DW	UPDSCR			;DUMMY RETURN ADDRESS AFTER 2nd FILBOX
ENDSPT:	DW	QUTSTR			;QUIT STRING POINTER
	DW	PRTSTR			;DUMMY RETURN ADDRESS AFTER 1st PRTSTR
	DW	AFTSTR			;' after ' STRING POINTER
	DW	PRDEC			;DUMMY RETURN ADDRESS AFTER 2nd PRTSTR
MOVCNT:	DW	0			;MOVE COUNT
	DW	PRTSTR			;DUMMY RETURN ADDRESS AFTER PRDEC
	DW	MOVSTR			;' moves' STRING POINTER
	DW	0			;EXIT VECTOR

KASCIZ:	DB	'KEYS'			;OUTPUT FILE ASCIIZ
VARBAS:	VARBLE	<>			;VARIABLE SPACE
ENDSOF	EQU	VARBAS-ENDSPT		;BP OFFSET TO ACCESS END STRING POINTER
MVCTOF	EQU	VARBAS-MOVCNT		;BP OFFSET TO ACCESS MOVE COUNT

START1:	POP	SP			;RESTORE PREDEFINED STACK FRAME POINTER
	MOV	BP,OFFSET VARBAS	;POINT TO VARIABLE SPACE
	MOV	AH,3CH
	MOV	FS,CX			;INITIALIZE HOLE INDEX
	MOV	DX,OFFSET KASCIZ	;POINT TO OUTPUT FILE ASCIIZ
	INT	21H			;CREATE FILE
	MOV	GS,AX			;FILE HANDLE TO GS
	MOV	AL,13H
	INT	10H			;SET VIDEO MODE 13H
	POP	ES			;RESTORE SCREEN SEGMENT
FLBOX2:	POP	AX			;RESTORE PIXEL COLOR & BOX SIDE LENGTH
	POP	DI			;RESTORE SCREEN POINTER
FILBOX:	MOV	DH,AH			;ROW COUNT
FLBOXZ:	MOV	CL,AH			;PIXELS PER ROW COUNT
	PUSH	DI			;SAVE ROW START POINTER
	REP	STOSB			;DRAW ROW
	POP	DI			;RESTORE ROW START POINTER
	ADD	DI,320			;ADJUST DOWN ONE ROW
	DEC	DH			;MORE ROWS?
	JNZ	SHORT FLBOXZ		;YES
PRBCD:	AAM				;TILE INDEX TO UNPACKED BCD
	PUSH	AX			;SAVE LO DIGIT
	MOV	AL,AH			;HI DIGIT TO AL
	CALL	PRTDIG			;PRINT HI DIGIT
	POP	AX			;RESTORE LO DIGIT
PRTDIG:	CBW				;UNSIGNED EXTEND DIGIT
	XCHG	AX,SI			;DIGIT TO SI
	MOV	AH,[BP+SI+SEGDAT]	;GET 7-SEGMENT BIT MASK
	XOR	AL,AL			;DIGIT PIXEL COLOR
	MOV	SI,12			;SEGMENT SUBTRAHEND TABLE INDEX
DRWSEG:	SHR	AH,1			;SEGMENT?
	JNC	SHORT NXTSEG		;NO
	PUSH	DI			;SAVE TILE POINTER
	MOV	CL,6			;DEFAULT SEGMENT PIXEL COUNT
	CWD				;DEFAULT SCREEN ADDEND TO DX
	SUB	DI,[BP+SI+SEGTBL]	;ADJUST SCREEN POINTER TO SEGMENT
	CMP	SI,CX			;HORIZONTAL SEGMENT?
	JA	SHORT SEGLIN		;YES
	MOV	DX,319			;SCREEN ADDEND FOR VERTICAL LINE
	CMP	SI,2			;6-PIXEL SEGMENT?
	JA	SHORT SEGLIN		;YES
	INC	CX			;ADJUST PIXEL COUNT
SEGLIN:	STOSB				;STORE A PIXEL
	ADD	DI,DX			;ADJUST TO NEXT PIXEL
	LOOP	SEGLIN
	POP	DI			;RESTORE TILE POINTER
NXTSEG:	DEC	SI
	DEC	SI			;ADJUST TO NEXT SUBTRAHEND
	JNS	SHORT DRWSEG		;MORE SEGMENTS
	ADD	DI,10			;ADJUST TO NEXT DIGIT
	RET

UPDSCR:	MOV	BL,15			;TILE INDEX/COUNT
	MOV	DI,320*133+193		;LOWER RIGHT TILE SCREEN OFFSET
DRWTIL:	MOV	AL,[BX+OFFSET VARBAS]	;GET TILE NUMBER/COLOR
	MOV	AH,30			;TILE BOX SIDE LENGTH
	CALL	FILBOX			;DRAW TILE & WRITE DIGITS
	SUB	DI,320*30+52		;ADJUST TO NEXT LOWER TILE IN ROW
	TEST	BL,00000011B		;NEW ROW?
	JNZ	SHORT NXTILE		;NO
	SUB	DI,320*31+192		;ADJUST TO NEXT LOWER ROW LAST TILE
NXTILE:	DEC	BX			;MORE TILES?
	JNS	SHORT DRWTIL		;YES
	CBW				;CLEAR AH
	INT	16H			;GET A KEY
	PUSH	AX			;SAVE KEY
	MOV	AH,40H
	MOV	BX,GS			;FILE HANDLE TO BX
	MOV	CL,1			;OUTPUT CHARACTER COUNT
	MOV	DX,SP			;KEY CODE POINTER TO DX
	INT	21H			;WRITE KEY TO DISK
	POP	AX			;RESTORE KEY
	XOR	AL,'0'			;CONVERT BECIMAL KEY TO BINARY
	CMP	AL,10H			;SPACE?
	JZ	SHORT DONE		;YES
	SHR	AL,1			;ODD KEY?
	JC	SHORT UPDSCR		;YES
	DEC	AX			;CONVERT TO BASE 0
	CMP	AL,3			;LEGAL KEY?
	JA	SHORT UPDSCR		;NO
	CBW				;CLEAR AH
	XCHG	AX,DI			;KEY CODE TO DI
	MOV	SI,FS			;HOLE POSITION INDEX TO SI
	MOVSX	AX,[BP+DI+MOVIDX]	;GET MOVE TILE INDEX ADDEND
	ADD	AX,SI			;CALCULATE MOVE TILE INDEX
	MOV	DI,AX			;MOVE TILE INDEX TO DI
	XOR	AX,SI			;SET MOVE INDEX DIFFERING BITS
	CMP	AL,7			;ILLEGAL MOVE?
	JZ	SHORT UPDSCR		;YES
	CMP	AL,0CH			;ILLEGAL MOVE?
	JA	SHORT UPDSCR		;YES
	CBW				;CLEAR AH
	XCHG	AH,[BP+DI]		;GET MOVING TILE INDEX, STORE HOLE
	MOV	[BP+SI],AH		;STORE MOVING TILE INDEX IN HOLE
	MOV	FS,DI			;UPDATE HOLE POSITION INDEX
	INC	WORD PTR[BP-MVCTOF]	;COUNT MOVE
	MOV	BL,15			;TILE INDEX/COUNT
TSOLVE:	CMP	[BX+OFFSET VARBAS],BL	;CORRECT VALUE?
	JNZ	SHORT UPDSCR		;NO
	DEC	BX			;MORE TILES?
	JNZ	SHORT TSOLVE		;YES
	ADD	BYTE PTR[BP-ENDSOF],14	;ADJUST END STRING PTR TO WIN STRING
DONE:	MOV	AX,3
	INT	10H			;SET VIDEO MODE 3
PRTSTR:	POP	DX			;RESTORE STRING POINTER
	MOV	AH,9
DOSINT:	INT	21H			;PRINT STRING
	RET

PRDEC:	POP	AX			;RESTORE MOVE COUNT
	MOV	BL,10			;RADIX (DIVISOR)
PRDECZ:	XOR	DX,DX			;UNSIGNED EXTEND DIVIDEND TO 32 BITS
	DIV	BX			;CALCULATE DIGIT
	OR	AX,AX			;QUOTIENT = 0?
	JZ	SHORT PDDONE		;YES
	PUSH	DX			;SAVE DIGIT
	CALL	PRDECZ			;RECURSIVELY CALCULATE NEXT DIGIT
	POP	DX			;RESTORE DIGIT
PDDONE:	XOR	DL,'0'			;CONVERT DIGIT TO ASCII
	MOV	AH,2
	JMP	SHORT DOSINT		;WRITE CHARACTER TO SCREEN

QUTSTR:	DB	'You have quit$'
WINSTR:	DB	'Winning field$'
AFTSTR:	DB	' after $'
MOVSTR:	DB	' moves',0DH,0AH,'$'
	END	START
