; Assembled using NASM (Netwide Assembler) v0.94
;
; COMMAND LINE:  nasm entry.asm -o entry.com
;

ORG 0x100
BITS 16

        pop     ax              ; generate the game grid
        mov     di,gamegrid
generategrid_loop:
        stosb
        sub     al,3
        and     al,0x0F
        jnz     generategrid_loop

        mov     al,0x13         ; set display to mode 13h
        int     0x10            ; (320x200x256color std vga mode)

        xor     bp,bp           ; clear BP for the move counter

        push    word 0xA000     ; setup ES for screen writes
        pop     es

        mov     ax,0x3C07       ; draw the border
        mov     di,(35*320)+95  ; (also setup AH for open file)
        mov     si,di
        mov     cl,130
border_loop:
        mov     [es:si],al
        mov     [es:si+129],al
        mov     [es:di+(129*320)],al
        stosb
        add     si,320
        loop    border_loop

        mov     dx,keysfilename ; open the 'KEYS' file
        int     0x21
        push    ax              ; push the file handle for the exit

game_loop:

        mov     si,gamegrid                     ; loops to draw the 4x4
        mov     di,(37*320)+97-((32*320)-(4*32)); tiles and check if the
        xor     dx,dx                           ; puzzle has been solved

drawtiles_loop:
        test    dl,3
        jnz     drawtiles_notnewrow
        add     di,(32*320)-(4*32)
drawtiles_notnewrow:

        lodsb                   ; get the number in the tile

        cmp     al,dl           ; check if the number is in
        adc     dh,bh           ; the correct position

        mov     bl,30           ; draw the background of
drawtiles_background_loop:      ; the current tile
        mov     cx,30
        rep     stosb
        add     di,290
        dec     bx
        jnz     drawtiles_background_loop

        mov     bl,10           ; draw the digits in
        div     bl              ; the current tile
        call    drawdigit
        add     di,bx
        shr     ax,8
        call    drawdigit

        sub     di,(30*320)-22  ; bottom of loops which
        inc     dx              ; draws and checks the tile
        test    dl,16
        jz      drawtiles_loop

        or      dh,dh           ; check if the puzzle
        mov     dx,winmsg       ; has been solved
        jz      exit

        int     0x16            ; read a key

        pop     bx              ; PUSHed at start
        push    bx              ; keep on stack for exit
        push    ax              ; write it to the 'KEYS' file
        mov     ah,0x40
        inc     cx  
        mov     dx,sp
        int     0x21
        pop     ax

        cmp     al,' '          ; check if it was the
        jne     respondtokey    ; quit key (SPACE)
        mov     dx,quitmsg

exit:
        mov     ax,3            ; set display to 80x25 color text mode
        int     0x10

        push    dx              ; prepare the move count string
        mov     si,movecountstr+5
        mov     bl,10
        xchg    ax,bp
prep_movecountstr_loop:
        xor     dx,dx
        div     bx
        dec     si
        add     [si],dl
        or      ax,ax
        jnz     prep_movecountstr_loop
        pop     dx

        mov     ah,9            ; print the exit message at DX
        int     0x21
        mov     dx,sharedexitmsg
        int     0x21
        mov     dx,si
        int     0x21

        mov     ah,0x3E         ; close the 'KEYS' file
        pop     bx              ; PUSHed at the start
        int     0x21

        int     0x20            ; exit

respondtokey:
        sub     al,50           ; check that the move associated
        test    al,11111001b    ; with the pressed key is valid
        xchg    ax,cx
        jnz     respondedtokey
        shr     cl,1
        mov     bl,cl
        movsx   si,byte [bx+moveinstr]
        shl     al,cl
        mov     bl,[blankpos]
        and     al,[bx+validmoves]
        jnz     respondedtokey

        xchg    al,[bx+si+gamegrid]     ; do the move
        mov     [bx+gamegrid],al
        add     [blankpos],si

        inc     bp              ; increment the move counter
respondedtokey:
        jmp     game_loop


;;  drawdigit: draws a single game tile
;;             call with: AL = digit to draw
;;                        DI = offset of bottom of tile
drawdigit:
        pusha
        mov     bx,digits
        xlatb
        xchg    cx,ax
        mov     si,segments
        mov     bx,0x6C0C
drawdigit_loop:
        push    di
        lodsw
        add     di,ax
        mov     ax,0x0600
        xor     dx,dx
        shl     bh,1
        jnc     drawsegment
        shr     bl,1
        adc     ah,dh
        mov     dx,319
drawsegment:
        shl     cl,1
        jnc     drawsegment_notlit
drawsegment_loop:
        stosb
        add     di,dx
        dec     ah
        jnz     drawsegment_loop
drawsegment_notlit:
        pop     di
        or      cl,cl
        jnz     drawdigit_loop
        popa
        ret


quitmsg         db      'You have quit$'
winmsg          db      'Winning field$'
sharedexitmsg   db      ' after $'
movecountstr    db      '00000 moves',0Dh,0Ah,'$'
digits          db      0xEE,0x24,0xBA,0xB6,0x74,0xD6,0xDE,0xE4,0xFE,0xF6
moveinstr       db      -4,+1,-1,+4
keysfilename    db      'KEYS'
blankpos        db      0

;                       URLD    0=valid, 1=not valid
validmoves      db      0101b
                db      0001b
                db      0001b
                db      0011b
                db      0100b
                db      0000b
                db      0000b
                db      0010b
                db      0100b
                db      0000b
                db      0000b
                db      0010b
                db      1100b
                db      1000b
                db      1000b
                db      1010b

segments:
segment7        dw      (7*320)+7-(30*320)
segment6        dw      (8*320)+6-(30*320)
segment5        dw      (8*320)+13-(30*320)
segment4        dw      (14*320)+7-(30*320)
segment3        dw      (15*320)+6-(30*320)
segment2        dw      (15*320)+13-(30*320)
segment1        dw      (22*320)+7-(30*320)



SECTION .bss

gamegrid        resb    16
