; Hugi Size Coding Competition #10
; Compiled with NASM
; 17/12/99 : 470 bytes * Ca marche *
; 18/12/99 : 455 bytes      -15
; 19/12/99 : 432 bytes      -23
; 21/12/99 : 410 bytes      -22
; 04/01/00 : 385 bytes      -25
; 22/01/00 : 368 bytes      -17
; 31/01/00 : 365 bytes      -3
; ================================================================

        org 100h
	section .text

                                        ;         AX=0000 BX=0000 CX=00FF DX=????
        ; --- init puzzle
        xor             bp,bp
        mov             cl,16           ;2
        mov             di,grid         ;3
initpuzzle:
        stosb                           ;1
        add             al,13           ;2
        and             al,0fh          ;2
        loop            initpuzzle      ;2
                                        ;         AX=0000         CX=0000         DI=grid 

	; (1)  - switch to VGA mode 13 hex

        mov             al,13h          ;2        AX=0013
	int		10h		;2

        les             di,[bx]         ;2 --- 2                                  ES=A000 DI=20CD

        ; --- Open  'keys' file ---
        mov             ah,3Ch          ;2 --- 10 AX=3C13
        mov             dx,filename     ;3                                DX=filename
        int             21h             ;2        AX=00?? (file handle < 256)

progmainloop:

        ; (2)  - draw the puzzle

        call            draw_everything ;3 --- 3

	;      - read the keyboard using AH=00 INT 16 hex
        cbw
        int             16h

	;	 - write the key char to "KEYS" file
        mov             bl,5
        inc             cx
        push            ax
        mov             dx,sp
        mov             ah,40h
        int             21h
        pop             ax              ; key in al

        ;        - if key in [2,4,6 or 8]  AND move is valid then
        ;              --> (key-2 < 7) & (test(key,1)==0)
	;			... update puzzle
	;			... update MovesCounter

                                ; al = 0011xxx0     (xxx = 001, 010, 011, 100)
        dec     cx               ; cx = 0
        mov     bl,2
        sub     al,50           ; al = 00000xx0     (xx = 00, 01, 10, 11)
        jnp     skipclmask
        mov     cl,2
skipclmask:                     ; cl =  2  0  0  2
        test    al,11111001b
        jnz     invalidkey
        and     bl,al           ; bl =  0  2  0  2
        jp      skipdlmask
        mov     dl,3            
skipdlmask:                     ; dl =  0  3  0  3
        dec     bx              ; bl = -1 +1 -1 +1
        shl     bx,cl           ; bl = -4  1 -1  4

        mov     ax,[hole]       ; tst: (00)00, 00(11), 00(00), (11)00
        mov     di,grid   
        add     di,ax

        shr     al,cl           ; tst: 000000xx (00, 11, 00, 11)
        xor     al,dl           ; tst: 000000(00)
        test    al,3
        jz      invalidmove

        ;       Mvt valide

        inc             bp               
        mov             al,[bx+di]
        mov             [di],al
        xor             byte [di+bx],al 
        add             [hole],bx        

invalidmove:
invalidkey:

        mov             dx,bye_msg      ;3 !!

        ;        - if [QUIT] key then goto (3)
        cmp             al,20h-50       ;2
        je              verifend        ;2

        ;----------------------------------------------------
	;	 - if the puzzle is not solved, then goto (2)
        mov             bx,15           ;3 !!  !!!!!!
verifloop:
       
        cmp             bl,byte[grid+bx];4 !!!!
        jne             progmainloop    ;2
        dec             bx              ;1
        jnz             verifloop       ;2
        mov             dl,win_msg      ;2 
verifend:

        ;-------------- progend
	; (3)  - switch back to text-mode 3
        mov             ax,03h          ;3 !!
        int             10h             ;2

	; (4)  - print either the win-message OR the quit-message
        mov             ah,09h          ;2
        int             21h             ;2
        mov             dl,aft_msg      ;2
        int             21h             ;2

        xchg            ax,bp           ;1
        xor             cx,cx           ;2
displayax:
        inc             cx              ;1
        xor             dx,dx           ;2
        mov             bl,10           ;2       
        div             bx              ;2
        push            dx              ;1
        or              ax,ax           ;2
        jnz             displayax       ;2
displayaxdigit:
        pop             ax              ;1
        add             ax,0930h        ;3
        int             29h             ;2
        loop            displayaxdigit  ;2

        mov             dx,moves_msg    ;3
        int             21h             ;2

	; (5)  - exit cleanly to DOS

        ret                             ;1

;=============================================

        ; Draws the board
        ;=====================================
draw_everything:                        ;         AX=00?? BX=0000 CX=0000 DX=???? 

        push            bp
        ;--- Draws the border (color 7) ---
        mov             di,2C1Fh
        mov             bl,130
        mov             al,7
        call            drawsquare
        mov             di,2C1Fh+321
        dec             bx
        dec             bx
        xchg            ax,cx
        call            drawsquare

        ;--- Draws the tiles ---
        mov             di,0A701h
        mov             bp,15
tileloop:
        mov             al,byte [bp+grid]

        ;--- the tile itself ---

        mov             bl,30
        call            drawsquare

        ;--- the led digits ---
        cbw
;        xor             ah,ah
        aaa

        add             di,33-8*320
        mov             bl,al
        call            draw_digit
        mov             bl,ah
        call            draw_digit

        sub             di,22*320+45
        test            bp,3
        jnz             tileskip
        sub             di,32*320-128
tileskip:
        dec             bp
        jns             tileloop

        pop             bp

        ret

;================================================
        ; di = pos      16 bytes
        ; al = color
        ; bx = size
drawsquare:
        mov     dx,bx
dsloop:
        mov     cx,bx
        rep     stosb
        add     di,320
        sub     di,bx
        dec     dx
        jnz     dsloop
        ret

;================================================
        ;========================================
        ; draws a digit : di = position+1
        ;                 bx = digit to draw
draw_digit:
        push            ax
        mov             al,[led_digits+bx]
        mov             si,led_steps
        mov             bl,1
        mov             cl,8
ledmainloop:
        mov             dl,6
        add             di,[si]
        inc             si
        inc             si
        cmp             cl,3
        ja              ledskip
        inc             dx
ledskip:
        cbw
        rol             al,1
ledlight:
ledsecloop:
        and             [es:di],ah
        add             di,bx
        dec             dx
        jnz             ledsecloop

        neg             bx
        add             bx,321
        loop            ledmainloop

        pop             ax
        ret
                  

;=============================================================================
;=============================================================================

        section .data align=1

win_msg:        db 'Winning field$'     ;14           
bye_msg:        db 'You have quit$'     ;14
aft_msg:        db ' after $'           ;8
moves_msg:      db ' moves',0dh,0ah,'$' ;9

filename:       db      'keys'  ; Need a zero at the end (next byte)

hole:   dw      0000h

led_digits:     db      00100010b       ; 0
                db      11101110b       ; 1
                db      01000011b       ; 2
                db      01000110b       ; 3
                db      10001110b       ; 4
                db      00010110b       ; 5
                db      00010010b       ; 6
                db      00101110b       ; 7
                db      00000010b       ; 8
                db      00000110b       ; 9

                ; Deplacement pour arriver a l'endroit du debut de la led
led_steps:      dw      -15*320-16      ; led 7   -15*320-16
                dw      320-7           ; led 6
                dw      1               ; led 5
                dw      -6*320          ; led 4
                dw      8*320-6         ; led 3
                dw      -7-7*320        ; led 2
                dw      2*320-319       ; led 1 (fake led)
                dw      -8*320-1        ; led 0

        section .bss
grid:           resb    16


;                    _y_           _y_          _y_          _y_
;  xxxxxx          _z_           _z_          _z_          _z_
; x  a   x   a = 1 0 1 1   b = 1 0 0 0  c = 1 1 1 1  d = 0 0 1 1
; x      x     x|0 1 1 1     x|1 1 0 1    x|1 0 1 0    x|1 1 0 1 
; x      x    w||x x x x    w||x x x x   w||x x x x   w||x x x x
; xb    cx     | 1 1 x x     | 1 1 x x    | 1 1 x x    | 1 1 x x
; x      x       
; x      x       
;  xxxxxx            _y_           _y_          _y_          _y_
; x  d   x         _z_           _z_          _z_          _z_     
; x      x   e = 1 0 0 1   f = 1 1 1 0  g = 1 0 1 1  h = ? ? ? ?
; x      x     x|0 0 0 1     x|1 1 1 1    x|0 1 0 1    x|? ? ? ?
; xe    fx    w||x x x x    w||x x x x   w||x x x x   w||x x x x
; x      x     | 1 0 x x     | 1 1 x x    | 1 1 x x    | ? ? x x
; x      x
; x  g   x
;  xxxxxx
;     h
;  ???????
;
;                   ___
;  a = w + y + xz + wxz
;           _    _   __
;  b = w + xy + xz + yz
;      _   __
;  c = x + yz + yz
;           _
;  d = w + xy +
;
