; ====================================================== ;
; maze solver written for hugi's size-coding competition ;
; ====================================================== ;
;             author: Cig82 (eCig@gmx.net)               ;
;          written in NASM (Netwide Assembler)           ;
; ====================================================== ;

[BITS 16]
[ORG 100h]

; ==================--- read in the maze (16 bytes)

 mov   ah, 3dh                ; read command                       ; 2 bytes
 mov   dx, mino               ; filename mino                      ; 3 bytes
 int   21h                    ; execute                            ; 2 bytes
 xchg  ax, bx                 ; move handle to bx                  ; 1 byte
 not   cx                     ; higher size than maze to cx :-)    ; 2 bytes
 push  dx                     ; save filename position, we don't   ; 1 byte
                              ; need it anymore (now memory :-))   ;
 mov   ah, 3fh                ; read command                       ; 2 bytes
 int   21h                    ; execute                            ; 2 bytes
 push  ax                     ; save the maze size                 ; 1 byte
                              ; correct size determined by DOS :-)

; ==================--- initialize tables (7 bytes)

 mov   di, 20000              ; set position to our tables...          ; 3 bytes
 mov   cx, di                 ; both tables to clear (same value :-)   ; 2 bytes
                              ; init value = maze size, there are      ;
                              ; still enough moves left                ;
 rep   stosw                  ; start flooding                         ; 2 bytes

; ==================--- get start point (8 bytes)

 xchg  ax, cx                 ; put maze size to cx                    ; 1 byte
 mov   di, dx                 ; put memory position to dx              ; 2 bytes
 mov   al, 2                  ; set start value                        ; 2 bytes
 repne scasb                  ; search                                 ; 2 bytes
 dec   di                     ; dec to get the right position          ; 1 byte

; ==================--- solve the maze (41 bytes)

 sub   di, dx                 ; dx was still mem position              ; 2 bytes
 mov   si, di                 ; copy the mem position to si            ; 2 bytes
again:                                                                 ;
 lea   bp, [si-100]                                                    ; 3 bytes
 call  addnode                ; go up                                  ; 3 bytes
 lea   bp, [si-1]                                                      ; 3 bytes
 call  addnode                ; go left                                ; 3 bytes
 lea   bp, [si+1]                                                      ; 3 bytes
 call  addnode                ; go right                               ; 3 bytes
 lea   bp, [si+100]                                                    ; 3 bytes
 call  addnode                ; go down                                ; 3 bytes
 add   si, si                 ; align to word                          ; 2 bytes
 mov   si, word [20000+si]    ; get queued value                       ; 4 bytes
 cmp   byte [mem+si], 3       ; is it the end?                         ; 5 bytes
 jne   again                  ; if not... try again                    ; 2 bytes

; ==================--- backtrack the shortest path (20 bytes)

find:
 add   si, si                 ; align to word                          ; 2 bytes
 mov   si, [40000+si]         ; get value from travelling table        ; 4 bytes
 cmp   byte [mem+si], 1       ; is it a path                           ; 5 bytes
 jne   done                   ; if not, the beginning was found :-)    ; 2 bytes
 mov   byte [mem+si], 90h     ; mark the path                          ; 5 bytes
 jmp   short find             ; next field                             ; 2 bytes
done:

; ==================--- write the solution (17 bytes)

 mov   ah, 3ch                ; file creation command                  ; 2 bytes
 xor   cx, cx                 ; let's clear the file attributes        ; 2 bytes
 mov   dx, tour               ; set file name                          ; 3 bytes
 int   21h                    ; execute                                ; 2 bytes
 xchg  ax, bx                 ; move file handle to bx                 ; 1 byte
 mov   ah, 40h                ; write command                          ; 2 bytes
 pop   cx                     ; load maze size                         ; 1 byte
 pop   dx                     ; load mem position                      ; 1 byte
 int   21h                    ; execute                                ; 2 bytes
 ret                          ; we've finished our job                 ; 1 byte

; ==================--- add node procedure (32 bytes)

addnode:
 test  byte [mem+bp], 1       ; is it a piece of path?                 ; 5 bytes
 jz    fin                    ; no? then exit!                         ; 2 bytes
 add   bp, bp                 ; align to word                          ; 2 bytes
 cmp   word [20000+bp], 10000 ; already queued?                        ; 6 bytes
 jne   fin                    ; yes then jump to fin                   ; 2 bytes
 mov   word [40000+bp], si    ; add position to the end of queue       ; 4 bytes
 shr   bp, 1                  ; align to byte                          ; 2 bytes
 add   di, di                 ; align to word                          ; 2 bytes
 mov   word [20000+di], bp    ; update travelling table                ; 4 bytes
 mov   di, bp                 ; set value of the current step          ; 2 bytes
fin:                                                                   ;
 ret                          ; return to real code                    ; 1 byte

; ==================--- necessary variables (9 bytes)

 tour  db "TOUR"              ; the solution file name                 ; 4 bytes
                              ; no 0 cause included in maze files!     ;
mem:                          ; here our maze does start               ;
 mino  db "MINO",0            ; the maze file                          ; 5 bytes
