; Maze pathfinder for Hugi Compo #11
; by Fred, frederic_perriot@hotmail.com
; should assemble to 88 bytes with nasm

; Thanks to Fabled, Ruud and TAD for the test suite and cool bug prog
; Greetings to the fellows of 524 W 123st Street, NY ;)

; Memory layout:
; 100h          -  100h+88       : program body
; 100h+83       -  100h+83+10000 : the maze
; 100h+83+10000 -  100h+83+20000 : the 'previous' array
; stack space                    : the queue of locations for bf search

; Assumptions at program start
; ax = 0
; bx = 0
; cx = 00FFh
; di = sp = 0FFFEh
; bp = 09xxh

org 100h
start:
        ; Start by zapping a big memory area from 09xxh-2 to 8000h-2
        ; this includes the 'previous' array

        mov     [bp+di], al             ; the +di is just to avoid bp alone
        inc     bp
        jns     start                   ; stop when bp = 8000h

        ; open and read the MINO file

        mov     dx, inputfile
        call    file_io
        pop     si                      ; si = sp = 0

        ; from the current exploration point, pointed to by di
        ; explore in all four directions
        ; offsets are successively 0FFFFh, 1, 0FF9Ch and 64h
        ;                              -1, 1,   -100 and 100
        ; In the 'previous' array, it is not the absolute previous location
        ; that is stored but (-) the offset to it. Offsets are stored on 1
        ; byte. That is, offsets are 0FFh, 1, 9Ch and 64h.
        ; All unexplored locations, as well as the begin location, have an
        ; offset of 0 stored in the 'previous' array

main_loop:
        db      0D6h                    ; salc, al = 0FFh because CY is set
direction_loop:
        add     di, ax                  ; move left/right/up/down
        test    [di], dh                ; test [di], 1
                                        ; i.e. is it wall or begin
        jz      skip_location           ; if yes skip this location
        cmp     [di+bp], dh             ; is there a previous location
        jae     skip_location           ; yes -> skip
        mov     [di+bp], al             ; no -> save offset
        push    di                      ; enqueue in stack
skip_location:
        sub     di, ax                  ; undo move
        neg     ax                      ; change to opposite direction
        jns     direction_loop
        dec     si                      ; si is decremented by 2 during
                                        ; each main_loop iteration
                                        ; it walks the stack following sp
        sub     al, 99                  ; al : 0FFh -> 9Ch -> 39h
        js      direction_loop

        ; At this point, all 4 directions were explored
        ; dequeue the next location and check if it's the end location
        ; since al = 39h and [di] can be either 1 or 3, the cmp sets CY
        ; and gives 1-39h = C8h parity odd  if [di] = 1 (maze corridor)
        ;           3-39h = CAh parity even if [di] = 3 (end location)

        mov     di, [si]
        cmp     [di], al
        jpo     main_loop               ; continue until the end location

        ; Now we have di pointing to the end location
        ; and btw ah = 0FFh, good :)
        ; We rewind the path by reading the offests from the 'previous' array
        ; We xor the corridors (1) to shortest path (90h) on our way
        ; When the begin location is reached, the offset is 0 so the
        ; xor is performed twice on this location and the sign bit is reset

        ; create and write the TOUR file

rewind:
        movsx   cx, [di+bp]             ; sign-extend the byte-wide offset
        sub     di, cx                  ; move to previous location
        xor     byte [di], 91h          ; make it shortest path
        js      rewind

        push    cx                      ; for the final ret to CD20
file_io:
        add     ah, 3Dh                 ; on 1st pass ah = 0
                                        ; result: ah = 3Dh and no CY
                                        ; on 2nd pass ah = 0FFh
                                        ; result: ah = 3Ch and CY
        adc     bh, 3Fh                 ; bh becomes 3Fh on 1st pass
                                        ;            40h on 2nd pass
        int     21h
        xchg    bx, ax                  ; put handle in bx
                                        ; and read/write function in ax
        xchg    cx, bp                  ; result of 1st pass:
                                        ; cx = 8000h >= 10000
                                        ; bp = 0FFh
                                        ; result of 2nd pass:
                                        ; cx = 10000
                                        ; bp = 0
        mov     dl, maze-100h           ; on 1st pass the MINO file is
                                        ; read over the 'MINO', 0 text
                                        ; this puts the 0 after 'TOUR'
        int     21h

        ; The following part only matters for 1st pass

        xchg    bp, ax                  ; bp = 10000, the # of bytes read
                                        ; from MINO, keep it preciously
        ;xchg    si, ax                 ; This is necessary if the byte at
                                        ; 0FFh can be 2, which I think it
                                        ; can't (waiting for the public
                                        ; judgement...)
                                        ; This would make ax = 100h
        xchg    di, ax                  ; Now di = 0FFh and ax = 0FFFEh
        add     al, 4                   ; al = 2, without a mov al, 2
                                        ; because I will scan for 2 through
                                        ; the program code
        repnz   scasb                   ; scan for 2
                                        ; cx = 8000h is big enough
        dec     di                      ; adjust
        add     dx, sp                  ; dx = dx - 4, this sets the CY

        ret                             ; either back up there
                                        ; or out in the void...

outputfile      db 'TOUR'
maze:
inputfile       db 'MINO', 0

