;-------------------------;
;                         ;
; Entry for Hugi compo 11 ;
;                         ;
;         By Klorf        ;
;                         ;
;-------------------------;

MAZE    EQU     10000
LAST    EQU     20000

        SECTION .text
        BITS    16
        ORG     0x0100

        ; clear LAST (assuming AL=0)
        MOV     DI,LAST
        MOV     CX,DI
        REP     STOSB

        ; read MINO
        MOV     AH,0x3D
        MOV     DX,mino
        MOV     BH,0x3F
        CALL    filestuff

        ; scan through all non-zero blocks in LAST and set
        ; reachable surrounding blocks' last-value to current block's
        ; address
        new_round:
        MOV     BP,MAZE
        MOV     CX,BP
        s1:
          MOV     DI,BP
          CMP     BYTE [DI],2
          JE      SHORT flow
          CMP     WORD [BP+DI],BYTE 0
          JE      SHORT s1_end
            flow:
            MOV     SI,next
            PUSH    CX
            MOV     CX,4
            s1s1:
              LODSB
              CBW
              MOV     BX,BP
              ADD     BX,AX
              MOV     DI,BX
              CMP     WORD [BX+DI],BYTE 0
              JNE     SHORT .end
                MOV     AL,[BX]
                SHR     AL,1          ; only paths and exit are operated
                JNC     SHORT .end
                  MOV     [BX+DI],BP
                  JNZ     SHORT s2
              .end:
            LOOP    s1s1
            POP     CX
          s1_end:
          INC     BP
        LOOP    s1
        JMP     SHORT new_round

        ; mark the shortest path
        ; BX points now to exit
        s2:
          ADD     BX,BX
          MOV     BX,[BX]
          ADD     BYTE [BX],0x8F
        JP      SHORT s2
        SUB     BYTE [BX],0x8F
        POP     BX              ; ADD SP,2

        ; write TOUR and exit
        ; (files are left open...)
        MOV     DX,tour
        MOV     AH,0x3C
        MOV     BH,0x40

        ;-------
        ; DX = filename
        ; BH = 0x3F for read, 0x40 for write
        ; AH = 0x3D for open, 0x3C for create
        filestuff:        
        ; open file
        XOR     CX,CX
        INT     0x21
        ; read/write maze
        XCHG    AX,BX
        MOV     DX,MAZE
        MOV     CX,DX
        INT     0x21
        RETN


next    DB      -1, 1, -100, 100
mino    DB      "MINO", 0
tour    DB      "TOUR", 0
