; written by leg-0

        .model tiny
        .code
        org 100h

start:

;------------------------------------------------------------------------------
; open output file
;------------------------------------------------------------------------------
        mov     ah, 03Ch		;				2
        xor     cx, cx			;				2
        mov     dx, offset outputfile	;				3
        int     21h			;				2
	push	ax			; save filehandle		1

	mov	cx, 10000		;				3
	push	cx			; save 10k values for future	1
	push	cx			; use				1
;------------------------------------------------------------------------------
; Initialize tables
;------------------------------------------------------------------------------
	mov     di, offset queue 	;				3
	add	cx, cx			;				2
	xchg	ax, bx			; ax == 0			1
	dec	ax			; ax == FFFF			1
	rep     stosw			;				2
;------------------------------------------------------------------------------
; Read in the maze
;------------------------------------------------------------------------------
	mov     ax, 03d00h		; 3D - open file 00 - reading	3
	mov     dx, offset inputfile	;				3
	int     21h			; ax == filehandle		2
					;
	xchg	ax, bx			; bx == filehandle		1
	mov     ah, 03fh		; readfile			2
	pop	cx			;				1
        mov     dx, offset maze		; address			3
        int     21h			;				2
	push	dx			;				1
;------------------------------------------------------------------------------
; Find the BEGIN location from the maze
;------------------------------------------------------------------------------
	pop	di			;				1
        mov     al, 2			;				2
        repne   scasb			;				2
        dec     di			;				1

        sub     di, dx	;offset maze	; get offset from maze		3
        mov     si, di			;				2
	mov	bx, dx			;				2
;------------------------------------------------------------------------------
; Do breadth first search
;------------------------------------------------------------------------------
@searching:
	lea     bp, [si-100]		; bp = si - 100			3
	call    _next			; go up				3

	lea     bp, [si-1]		; bp = si - 1			3
	call    _next			; go left			3

	lea     bp, [si+1]		; bp = si + 1			3
	call    _next			; go right			3

	lea     bp, [si+100]		; bp = si + 100			3
	call    _next			; go down			3

	add     si, si                  ; 				2
	mov     si, queue[si]           ; next position			4

        cmp     si, -1                  ; no solution?			4
        je      short @exit		;				2
        cmp     byte ptr [bx][si], 3	; exit location?		4
        jne     short @searching	; search until exit is found	2

; if execution gets here,  the shortest path has been found

;------------------------------------------------------------------------------
; Reconstruct the solution
;------------------------------------------------------------------------------
@find:
        add     si, si			;				2
        mov     si, previous[si]        ; get previous cell		4
        cmp     byte ptr [bx][si], 1	; beginpoint?			4
        jne     short @done		; if yes then the q is marked	2
        mov     byte ptr [bx][si], 90h	; otherwise mark queue		4
        jmp     short @find		; and advance			2
@done:
;------------------------------------------------------------------------------
; Write out the solution
;------------------------------------------------------------------------------
; write to file
        mov     ah, 040h		; write function		2
	pop	cx			; 10k				1
	pop	bx			; handle			1
        int     21h			;				2

@exit:
	ret				;				1
;------------------------------------------------------------------------------

_next proc NEAR
; BP is within the maze?
        cmp     bp, 10000		;				4
        jae     short @ret		;				2

	mov	cl, maze[bp]
; WALL?
	or	cl, cl
;        cmp     maze[bp], 0		;				4
        je      short @ret		;				2

; BEGIN?
	cmp	cl, 2
;        cmp     maze[bp], 2		;				4
        je      @ret			;				2

; queued?
	shl	bp, 1			;				2
        cmp     queue[bp], -1		;				4
        jne     short @ret		;				2

; add position BP to end of queue
; and update travelling table 
        mov     previous[bp], si	;				2
        shr     bp, 1			;				2
        add     di, di			;				2
        mov     queue[di], bp		;				4
        mov     di, bp			;				2

@ret:   ret
_next endp




;------------------------------------------------------------------------------
inputfile       db "MINO", 0
outputfile      db "TOUR", 0

; The maze

maze            db 10000 dup (?)

; Queue for processing each position

queue           dw 10000 dup (?)

; Travelling information
; This contains the position where we came from
; for each position in the maze

previous        dw 10000 dup (?)



END start
