.model tiny
.586

;[this will freeze/corrupt if there's no exit, or it can't be reached]
;[but it's allowed to do that]
;[it will probably also do that if mino doesn't exist or can't be opened]

;I got the idea when I saw "breadth-first"; I just guessed at what it meant
;though. later I looked at the c program and saw I guessed right...
;I think this is done differently though.

;how it works
;1. open and read mino file
;2. find the start location
;3. initialize the table to contain the start location
;4. read an entry from the table
;5. for each open path adjacent to the entry
;    add it's location to the table
;    change [location] to -offset+5 (offset=location-current_location)
;6. if the exit is found, go to 9
;7. remove the entries that have already been processed
;8. go to 4
;9. if the current location is the start location, go to 14
;10.retrieve [current location] to bx
;11.store 90h to [current location]
;12.add bx to current location
;13.go to 9
;14.for each location
;    if it's an undefined tour-file value, store a 1 (path)
;15.create and write tour file
;16.exit

code segment use16
    assume cs:code, ds:code, es:code, ss: code

org 100h

start:

;======read files=====
    mov ax,3d00h        ;open, read only, compatibility mode (sharing)
    mov dx,offset iname ;"mino",0
    int 21h             ;open file (errors not checked)
    mov bx,ax           ;file handle (dos closes it)
    mov ah,3fh          ;read
    mov cx,10000        ;length of maze
    mov dx,offset maze  ;destination address
    push dx             ;save maze for later
    push cx             ;save length for later (shorter than reloading)
    int 21h             ;read file


;======find begin=====
find_begin:         ;find the start location
    mov di,dx       ;offset maze (where to look)
    mov al,2        ;2=start location
    repnz scasb     ;search
    dec di          ;point at it instead of past it

    mov bp,offset step+2    ;first free spot in table
    mov [bp-2],di           ;store start point in first spot of table
;======solve==========
solve_begin:
    mov dx,bp               ;save first free spot
    mov si,offset step      ;first spot in table
    push si                 ;save for later
solve_loop1:
    lodsw                   ;read table entry
    mov di,ax               ;move to index register
    mov bx,1                ;check right
    call check
    neg bx                  ;check left (-1)
    call check
    mov bl,-100             ;check up [bh is already 0ffh]
    call check
    neg bx                  ;check down (+100)
    call check
    cmp si,dx               ;have we finished the first round yet?
    jne solve_loop1         ;no

    mov cx,bp               ;cx=bp-si (length of new entries)
    sub cx,si
    pop di                  ;offset step (restored)
    rep movsb               ;copy new entries to beginning of table
    mov bp,di               ;first free entry
    jmp solve_begin         ;continue

check:
    cmp byte ptr [bx+di],1  ;path?
    jb return               ;no, wall
    ja check2               ;no, begin/end/already done
    mov cl,5                ;cl=-bl+5   [+5 so it's above 3]
    sub cl,bl
    mov byte ptr [bx+di],cl ;replace path with it
    lea cx,[bx+di]          ;where it was stored
    mov [bp],cx             ;add new entry to table
    add bp,2                ;point to first free entry
return:
    ret

check2:
    cmp byte ptr [bx+di],3  ;is it the exit?
    jne return              ;no
found:
found_loop:
    cmp byte ptr [di],2     ;yes; are we on the entrance?
    je found_label          ;yes
    movsx bx,byte ptr [di]  ;no; get the offset to the previous position
    mov byte ptr [di],90h   ;mark our path
    lea di,[bx+di-5]        ;previous position (-5 to correct for above)
    jmp found_loop          ;repeat it
found_label:
    pop cx          ;call           ;we were in a call at the time
    pop cx          ;offset step    ;and this was pushed
    pop cx          ;10000          ;we want these
    pop si          ;offset maze
    push cx                         ;save them again
    push si
    mov di,si                       ;we're storing to the same place
found_loop2:
    lodsb           ;0-3, 4, 6, 105, 90h, -95   ;load value
    test al,6ch     ;ignore 0-3, 90h            ;is it a "defined" value?
    jz found_label2                             ;yes; store as-is
    mov al,1        ;change it back to a path   ;no, make it a path
found_label2:
    stosb           ;and store it               ;put back
    loop found_loop2                            ;repeat

    mov ah,3ch          ;create function
;    xor cx,cx          ;no flags (loop cleared it)
    mov dx,offset oname ;"tour",0
    int 21h             ;create file

    mov bx,ax           ;file handle
    mov ah,40h          ;write function
    pop dx              ;offset maze
    pop cx              ;10000
    int 21h             ;write file

    mov ah,4ch          ;quit function (don't care about exit code)
    int 21h             ;quit
    

oname db "tour",0   ;output file name
iname db "mino",0   ;input file name

maze db 10000 dup(?)    ;maze read from mino. gets modified & stored in tour.
step dw 10000 dup(?)    ;stores which locations to check (current & next).
                        ;10000 words probably not needed, but...why not?

code ends

end start
