;Hugi Size Coding Competition #11 entry (Maze Solver)
;Ray M. Ransom
;Big Bear City, California, USA
;ray@micosyen.com
;http://www.micosyen.com

	.MODEL	TINY			;04/15/00
	.386
	.CODE
	ORG	100H

START:	MOV	AX,3D82H		;"OPEN"
	MOV	BH,3FH			;"READ"
	MOV	DX,OFFSET INPNAM	;POINT TO INPUT FILE ASCIIZ
	MOV	BP,DX			;POINT TO MAZE BUFFER BASE
	CALL	RDWRT			;OPEN & READ FILE
	XCHG	AX,SI			;CLEAR AL
	MOV	DI,9002H-10000		;POINT TO PREVIOUS CELL TABLE-10000
	REP	STOSB			;CLEAR CELL MARKED TABLE
	XCHG	BX,DI			;PRV CELL TBL PTR TO BX, HANDLE TO DI
FNSTRT:	INC	DI			;ADJUST SEARCH INDEX
	CMP	[BP+DI],BL		;CELL TYPE IS "START"?
	JNZ	SHORT FNSTRT		;NO
CRUISE:	MOV	AL,DH			;INITIAL TEST DISPLACEMENT TO AL (1)
TSTDIR:	CBW				;SIGNED EXTEND TEST DISPLACEMENT
	MOV	SI,AX			;TEST POSITION DISPLACEMENT TO SI
	ADD	SI,DI			;ADJUST TO TEST CELL
	TEST	[BP+SI],DH		;Z IF CELL TYPE IS "WALL" OR "START"?
	BTS	DS:[8B20H],SI		;C IF CELL ALEADY MARKED
	JBE	SHORT NXTDIR		;CELL IS WALL, START OR ALREADY MARKED
	PUSH	SI			;SAVE NEXT EMPTY CELL INDEX
	MOV	[BX+SI],AL		;STORE DISPLACEMENT IN PREV TABLE
NXTDIR:	NEG	AL			;NEGATE TEST POSITION DISPLACEMENT
	JS	SHORT TSTDIR		;-1 OR -100
	ADD	AL,99			;ADJUST 1 TO 100 (OR 100 TO 199)
	JNS	SHORT TSTDIR		;100
	POP	DI			;RESTORE NEXT EMPTY CELL INDEX
	TEST	[BP+DI],BL		;CELL TYPE IS "END"?
	JZ	SHORT CRUISE		;NO
	DB	0A9H			;"TEST AX,ii" OPCODE (SKIP NXT 2 BYTES)
MRKPTH:	MOV	[BP+DI],BH		;MARK CELL AS PATH
	MOV	AL,[BX+DI]		;GET PREVIOUS CELL REVERSE DISPLACEMENT
	CBW				;SIGNED EXTEND REVERSE DISPLACEMENT
	SUB	DI,AX			;CALCULATE PREVIOUS CELL INDEX
	CMP	[BP+DI],DH		;AT START?
	JZ	SHORT MRKPTH		;NO
	MOV	AH,3CH			;"CREATE"
	MOV	BH,40H			;"WRITE"
	MOV	DL,LOW OFFSET OUTNAM	;POINT TO OUTPUT FILE ASCIIZ
RDWRT:	INT	21H			;OPEN OR CREATE FILE
	XCHG	AX,BX			;HANDLE TO BX, R/W FUNCTION TO AH
	MOV	CX,10000		;R/W BYTE COUNT
	MOV	DX,BP			;MAZE BUFFER BASE POINTER TO DX
	INT	21H			;READ OR WRITE FILE
	RET

OUTNAM:	DB	'TOUR'			;OUTPUT FILE ASCIIZ
INPNAM:	DB	'MINO',0		;INPUT FILE ASCIIZ
	END	START
