;
; Show TOUR file on screen (based on TAD's MazeGen TM)
;

; key: WALL          is grey
;      PATH          is blue
;      SHORTEST PATH is green
;      BEGIN         is cyan
;      END           is red

MAZE_WIDTH      equ     100             ; = 5 ... 318 (try 5,5 for ASCII chars)
MAZE_HEIGHT     equ     100             ; = 5 ... 198

        .model tiny                     ; yep, it's a .COM program

        .data?
tour            db      MAZE_WIDTH * MAZE_HEIGHT dup (?)


        .code
        org 256
go:
        ;; switch to mode 00013 hex (320 x 200 x 256 colors) ;;

        mov     al, 0013h
        int     10h

        ; open file
        mov     ax, 3d00h
        mov     dx, offset fname
        int     21h
        xchg    ax, bx

        ; read from file
        mov     ah, 3fh
        mov     cx, (MAZE_HEIGHT * MAZE_WIDTH)
        mov     dx, offset tour
        int     21h

        ; close file
        mov     ah, 3eh
        int     21h

        ; move data into mino buffer
        mov     ax, 0a000h
        mov     es, ax

        mov     si, offset tour
        xor     di, di

        mov     bx, MAZE_HEIGHT
loop_m:
        mov     cx, MAZE_WIDTH
inner_loop:
        lodsb
        cmp     al, 1
        jb      blank
        je      col_ok
        inc     ax
        jmp     col_ok
blank:

        mov     al, 7

col_ok:
        stosb
        loop    inner_loop

        add     di, (320 - MAZE_WIDTH)

        dec     bx
        jnz     loop_m

done:
        mov     ah, 0
        int     16h

quit:
        mov     ax, 0003h
        int     10h
        ret

fname:  db 'TOUR',0

        end     go
