;
;
;		boring MINO-TOUR display proggy by TAD
;
; 
;
; compile:
; 	TASM /m9 bug
;	TLINK /t bug
;
; usage:
;	BUG
;
; 
; Keys:
;      	[Cursor]		- move cursor
;	[SHIFT + Cursor]	- quick move
;	[HOME]			- goto BEGIN cell
;	[END]			- goto EXIT cell
;	[ESC]			- the best function... #;o)
;	[RETURN] [F2]		- toggle MINO/route
;	[TAB] [F3]		- toggle route color-cycling
;	[F1]			- display help
;
; Mouse:
;	[left button]		- goto BEGIN cell
;	[right button]		- goto EXIT cell
;
;

MAZE_WIDTH	equ	100
MAZE_HEIGHT	equ	100
MAZE_SIZE	equ	10000

WALL_C		equ	00h
PATH_C		equ	01h
BEGIN_C		equ	02h
EXIT_C		equ	03h
ROUTE_C		equ	90h

;* Display *
SCREEN_WIDTH	equ	320
SCREEN_HEIGHT	equ	200
SCREEN_LINE	equ	320
SCREEN_SIZE	equ	64000

CALCXY		MACRO	xp, yp
		mov	di, (yp)*SCREEN_LINE + (xp)
		ENDM

ZOOM_WIDTH	equ	39
ZOOM_HEIGHT	equ	23

;; My control-codes ;;
XTAB		equ	1
YTAB		equ	2
LOCATE		equ	3
CARRET		equ	4
PEN		equ	5

BLACK		equ	0
BLUE		equ	1
RED		equ	4
LGREY		equ	7
GREY		equ	8
PINK		equ	12
YELLOW		equ	14
WHITE		equ	15

;* OS macros *
INT_VIDEO	equ	<int 10h>
INT_KEYB	equ	<int 16h>
INT_DOS		equ	<int 21h>
INT_MOUSE	equ	<int 33h>

	.model tiny

	.data?
zap_top		equ	$

scrSEG		dw	?
scrOFF		dw	?

txtX		dw	?
txtY		dw	?
txtPEN		dw	?

zoomX		dw	?
zoomY		dw	?

minoPOS		dw	?
tourPOS		dw	?

cycleFLAG	db	?
cyclePOS	db	?

diffFLAG	db	?

ratFLAG		db	?		; NZ = INT 33h mouse installed

ratBUT		db	?
		LEFTBUT		equ	00000001b
		RIGHTBUT	equ	00000010b
		BOTHBUT		equ	00000011b

ratXREL		dw	?
ratYREL		dw	?

keySHIFT	db	?
		RSHIFT		equ	00000001b
		LSHIFT		equ	00000010b
		CTRL		equ	00000100b
		ALT		equ	00001000b

		SHIFT		equ	00000011b

keyCODE		dw	?

routeSTEPS	dw	?

mino_counts	dw	?		; WALL count
		dw	?		; PATH
		dw	?		; BEGIN
		dw	?		; EXIT
		dw	?		; ROUTE
		dw	?		; invalid

tour_counts	dw	?		; WALL count
		dw	?		; PATH
		dw	?		; BEGIN
		dw	?		; EXIT
		dw	?		; ROUTE
		dw	?		; invalid


mino_buffer	db	MAZE_SIZE dup (?)
tour_buffer	db	MAZE_SIZE dup (?)
cycle_buffer	db	MAZE_SIZE dup (?)
diff_buffer	db	MAZE_SIZE dup (?)
theseus_buffer	db	MAZE_SIZE dup (?)

zap_end		equ	$

	.data
mino_filename	db	'MINO',0
tour_filename	db	'TOUR',0
theseus_filename	db	'THESEUS',0

back_txt   	db	LOCATE,17,0,PEN,14,"MINO", PEN,LGREY,"-F2"
		db	LOCATE,29,0,PEN,LGREY,"F3-",PEN,15,"TOUR",0

minomap_txt	db	LOCATE,17,1,PEN,YELLOW,"input  ",0
minopath_txt	db	LOCATE,17,1,PEN,YELLOW,"path   ",0
minothes_txt	db	LOCATE,17,1,PEN,YELLOW,"Theseus",0

tourmap_txt	db	LOCATE,29,1,PEN,WHITE,"  ENTRY",0
tourcycle_txt	db	LOCATE,29,1,PEN,WHITE,"  cycle",0
tourthes_txt	db	LOCATE,29,1,PEN,WHITE,"Theseus",0

show_txt	db	LOCATE,17,14,PEN,LGREY,"XY"
		db	'(', PEN,WHITE
show_inf	db	'000,'
show_inf2	db	'000',PEN,LGREY,') [',PEN,WHITE
show_inf3	db	'0000h',PEN,LGREY,']',0

minocell_txt	db	LOCATE, 17,12,0
tourcell_txt	db	LOCATE,	27,12,0

counts_txt	db	LOCATE,18,3,PEN,8
counts_inf	db	'00000 Walls  00000', LOCATE,18,4, PEN,1
counts_inf2	db	'00000 Paths  00000', LOCATE,18,5, PEN,2
counts_inf3	db	'00000 Begins 00000', LOCATE,18,6, PEN,3
counts_inf4	db	'00000 Exits  00000', LOCATE,18,7, PEN,YELLOW
counts_inf5	db	'----- Routes 00000', LOCATE,18,9, PEN,RED
counts_inf6	db	'00000 errors 00000'
		db	0


cells_txt	db	PEN, 8,'00h= WALL',0
		db	PEN, 1,'01h= PATH',0
		db	PEN, 2,'02h=BEGIN',0
		db	PEN, 3,'03h= EXIT',0
		db	PEN, YELLOW,'90h=ROUTE',0
duff_txt	db	PEN, PINK,'??h=ERROR',0


help_txt    	db	LOCATE,20,0,PEN,WHITE,'Keys'
		db	PEN, LGREY
		db	LOCATE,2,2,'[cursor]',XTAB,20,'move zoom window'
		db	LOCATE,2,4,'[SHIFT+cursor]', XTAB,20,'fast move'
		db	LOCATE,2,6,'[HOME]', XTAB,20,'Go to BEGIN cell'
		db	LOCATE,2,8,'[END]', XTAB,20,'Go to EXIT cell'
		db	LOCATE,2,12,'[ENTER] [F2]', XTAB,20,'Cycle MINO maps'
		db	LOCATE,2,10,'[TAB] [F3]', XTAB,20,'Cycle ROUTE maps'
		db	LOCATE,20,16,PEN,WHITE,'Mouse'
		db	PEN, LGREY
		db	LOCATE,2,18,'[RIGHT-BUTTON]', XTAB,20,'Go to EXIT cell'
		db	LOCATE,2,20,'[LEFT-BUTTON]', XTAB,20,'Go to EXIT cell'
		db	0

mino_table	dw	mino_buffer, minomap_txt
		dw	diff_buffer, minopath_txt
		dw	theseus_buffer, minothes_txt

tour_table	dw	tour_buffer, tourmap_txt
		dw	cycle_buffer, tourcycle_txt
		dw	theseus_buffer, tourthes_txt




ESC_K		equ	01h
UP_K		equ	48h
DOWN_K		equ	50h
LEFT_K		equ	4Bh
RIGHT_K		equ	4Dh
HOME_K		equ	47h
END_K		equ	4Fh
TAB_K		equ	0Fh
RETURN_K	equ	1Ch
F1_K		equ	3Bh
F2_K		equ	3Ch
F3_K		equ	3Dh

	.code
	.286
	org	256
go:
	lea	di, zap_top
	mov	al, 0
	mov	cx, (zap_end-zap_top)
	rep	stosb

	;; load the "MINO" and "TOUR" mazes ;;

	lea	dx, mino_filename
	lea	di, mino_buffer
	call	LoadMaze

	lea	dx, tour_filename
	lea	di, tour_buffer
	call	LoadMaze

	;; load the "THESEUS" file ;;

	lea	dx, theseus_filename
	lea	di, theseus_buffer
	call	LoadMaze

	;; extract "TOUR" path/route ;;

	call	MakeDiff

	;; lame rat check ;;

	push	ES
	mov	ax, 3533h
	INT_DOS
	mov	ax, ES
	or	ax, bx
	or	al, ah
	mov	ratFLAG, al

	;; set mickey-2-pixel ratio ;;

	mov	cx, 16
	mov	dx, 16
	mov	ax, 000Fh
	call	MouseInt

	;; set mouse pos ;;

	mov	cx, (SCREEN_WIDTH/2)
	mov	dx, (SCREEN_HEIGHT/2)
	mov	ax, 0004h
	call	MouseInt
	pop	ES

	;; read & ignore 1st mouse movement ;;

	call	GetInputs

	;; init screen ;;

	mov	ax, 0013h
	INT_VIDEO
	sub	ax, ax
	mov	scrSEG, 0A000h
	mov	scrOFF, ax

	;; find BEGIN location ;;

	lea	di, mino_buffer
	mov	al, BEGIN_C
	call	FindCell

	;; check TOUR maze ;;
	call	CheckTour

	call	DrawBackground

	;; main loop ;;
mainloop:
	call	Vsync
	call	CycleColors
	call	Refresh
	call	ShowInfo
	call	GetInputs
	cmp	ah, ESC_K
	jz	quit
	call	CheckKeys
	jmp	mainloop
quit:
	mov	ax, 0003h
	INT_VIDEO
	ret

;
;
MouseInt:
	cmp	ratFLAG, 1
	jc	short mi_FAIL
	INT_MOUSE
	clc
mi_FAIL:
	ret

;
; Wait for vsync
;
Vsync:
	pusha
	mov	dx, 3DAh
vs_HI:
	in	al, dx
	test	al, 8
	jz	short vs_HI
vs_LO:
	in	al, dx
	test	al, 8
	jnz	short vs_LO
	popa
	ret

;
; Cycle colors
;
CycleColors:
	mov	bl, cyclePOS
cc:
	mov	dx, 3C8h
	mov	al, 0C0h
	out	dx, al
	inc	dx
	mov	al, bl
	mov	cx, 64
cc_RGB:
	and	al, 3Fh
	out	dx, al
	out	dx, al
	out	dx, al
	inc	ax
	loop	cc_RGB
	dec	bx
	mov	cyclePOS, bl
	ret

;

;
ClrScr:
	pusha
	push	ES
	mov	ES, scrSEG
	mov	di, scrOFF
	mov	cx, (SCREEN_SIZE/2)
	sub	ax, ax
	rep	stosw
	pop	ES
	popa
	ret

;
;
WaitKey:
	mov	ah, 00h
	INT_KEYB
	ret

;
; Get inputs
;
GetInputs:
	sub	ax, ax
	mov	ratBUT, al
	mov	ratXREL, ax
	mov	ratYREL, ax

	;; Get mouse inputs (if any)

	cmp	al, ratFLAG
	jz	short gi_NORAT

	mov	ax, 0003h
	INT_MOUSE
	mov	ratBUT, bl

	mov	ax, 000Bh
	INT_MOUSE
	mov	ratXREL, cx
	mov	ratYREL, dx
gi_NORAT:

	;; Get keyboard ;;

	mov	ah, 02h
	INT_KEYB
	mov	keySHIFT, al
	mov	ah, 01h
	INT_KEYB
	mov	ax, 0
	jz	short gi_NOKEY
	INT_KEYB
gi_NOKEY:
	mov	keyCODE, ax
	ret

FindBegin:
	mov	al, BEGIN_C
	lea	di, mino_buffer
	jmp	FindCell

FindExit:
	mov	al, EXIT_C
	lea	di, mino_buffer
	jmp	FindCell

ShowHelp:
	call	ClrScr
	lea	si, help_txt
	call	PrintMessage
	call	Waitkey
	call	ClrScr
	jmp	DrawBackground

;
; Do main 
;
CheckKeys:
	mov	cx, 1
	sub	dx, dx
	cmp	ah, RIGHT_K
	jz	short MoveKey
	neg	cx
	cmp	ah, LEFT_K
	jz	short MoveKey
	xchg	cx, dx
	cmp	ah, UP_K
	jz	short MoveKey
	neg	dx
	cmp	ah, DOWN_K
	jz	short MoveKey

	cmp	ah, HOME_K
	jz	short FindBegin
	cmp	ah, END_K
	jz	short FindExit

	cmp	ah, F2_K
	jz	short CycleMino
	cmp	ah, TAB_K
	jz	short CycleMino

	cmp	ah, F3_K
	jz	short CycleTour
	cmp	ah, RETURN_K
	jz	short CycleTour


	cmp	ah, F1_K
	jz	short ShowHelp

	;; deal with mouse inputs ;;

	mov	al, ratBUT
	test	al, LEFTBUT
	jnz	short FindBegin
	test	al, RIGHTBUT
	jnz	short FindExit

	mov	cx, ratXREL
	mov	dx, ratYREL
	mov	ax, cx
	or	ax, dx
	jnz	MoveZoom
	ret

CycleTour:
	lea	bx, tourPOS
	call	ToggleMap
	jmp	DrawBackground

CycleMino:
	lea	bx, minoPOS
	call	ToggleMap
	jmp	DrawBackground


;
; Move zoom by dX(cx) dY(dx) - depending on [SHIFT] state
;
MoveKey:
	xchg	ax, cx
	mov	cl, 0
	test	keySHIFT, SHIFT
	jz	short mk_SHIFT
	mov	cl, 3
mk_SHIFT:
	shl	ax, cl
	shl	dx, cl
	xchg	ax, cx

;
; Move zoom by dX(cx) dY(dx)
;
MoveZoom:
	add	cx, zoomX
	jns	short mz_LEFT
	sub	cx, cx
mz_LEFT:
	cmp	cx, MAZE_WIDTH
	jl	short mz_RIGHT
	mov	cx, (MAZE_WIDTH-1)
mz_RIGHT:
	add	dx, zoomY
	jns	short mz_TOP
	sub	dx, dx
mz_TOP:
	cmp	dx, MAZE_HEIGHT
	jl	short mz_BOT
	mov	dx, (MAZE_HEIGHT-1)
mz_BOT:
	mov	zoomX, cx
	mov	zoomY, dx
	ret

;
; CF=Load Maze[DS:DX] into[DS:DI]
;
LoadMaze:
	mov	ax, 3D00h
	INT_DOS
	jc	short LoadError
	xchg	ax, bx
	mov	dx, di
	mov	cx, (MAZE_SIZE+1)
	mov	ah, 3Fh
	INT_DOS
	jc	short LoadError
	cmp	ax, MAZE_SIZE
	stc
	jnz	short LoadError
	mov	ah, 3Eh
	INT_DOS
LoadError:
	ret

;
; Show info
;
ShowInfo:
	lea	di, show_inf
	mov	ax, zoomX
	call	OutDec3
	lea	di, show_inf2
	mov	ax, zoomY
	call	OutDec3
	lea	di, show_inf3
	mov	ax, MAZE_WIDTH
	mul	zoomY
	add	ax, zoomX
	call	OutHex4
	lea	si, show_txt
	call	PrintMessage

	lea	si, minocell_txt
	call	PrintMessage
	lea	si, mino_buffer
	call	CellInfo

	lea	si, tourcell_txt
	call	PrintMessage
	lea	si, tour_buffer
	call	CellInfo

	mov	si, minoPOS
	mov	si, mino_table+2[si]
	call	PrintMessage

	mov	si, tourPOS
	mov	si, tour_table+2[si]
	call	PrintMessage
	ret


CellInfo:
	mov	ax, MAZE_WIDTH
	mul	zoomY
	add	ax, zoomX
	add	si, ax
	lodsb
	cmp	al, ROUTE_C
	jb	short ci_OK
	mov	al, 4
	jz	short ci_OK
	dec	si
	lodsb
	lea	di, duff_txt+2
	call	OutHex2	
	mov	al, 5
ci_OK:
	mov	ah, 0
	imul	ax, 12
	add	ax, offset cells_txt
	xchg	ax, si
	call	PrintMessage
	ret


;
; Draw Background screen
;
DrawBackground:
	push	ES
	mov	ES, scrSEG

	CALCXY	0,0
	mov	si, minoPOS
	mov	si, mino_table[si]
	call	BlapMaze

	CALCXY	(SCREEN_WIDTH-MAZE_WIDTH),0
	mov	si, tourPOS
	mov	si, tour_table[si]
	call	BlapMaze

	CALCXY	0,100
	mov	al, YELLOW
	call	DrawBorder

	CALCXY	160,100
	mov	al, WHITE
	call	DrawBorder

	lea	si, back_txt
	call	PrintMessage

	lea	si, counts_txt
	call	PrintMessage

	pop	ES
	ret

;
;
Refresh:
	push	ES
	mov	ES, scrSEG

	mov	si, minoPOS
	mov	si, mino_table[si]
	CALCXY	2,102
	mov	bx, zoomX
	mov	bp, zoomY
	call	DrawZoom

	mov	si, tourPOS
	mov	si, tour_table[si]
	CALCXY	162,102
	mov	bx, zoomX
	mov	bp, zoomY
	call	DrawZoom

	pop	ES
	ret


;
; Output(AX) as 3-digit decimal[DS:DI]
;
OutDec3:
	aam	100
	add	ah,'0'
	mov	[di], ah
	inc	di
	aam	10
	add	ax,'00'
	mov	[di],ah
	inc	di
	mov	[di], al
	inc	di
	ret

;
; Output(AX) as 4-digit hex[DS:DI]
;
OutHex4:
	push	ax
	mov	al, ah
	call	OutHex2
	pop	ax
OutHex2:
	aam	16
	call	OutHex1
OutHex1:
	xchg	ah, al
	cmp	al, 0Ah
	sbb	al, 69h
	das
	mov	[di], al
	inc	di
	ret

;
; Output(AX) into[DS:DI] as 5-digit decimal
;
OutDec5:
	pusha
	mov	cl, 0
	mov	bx, 6
od_DIGIT:
	sub	dx, dx
	div	cs:decimals[bx]
	or	cl, al
	jnz	short od_NZ
	mov	al, 20h-'0'
od_NZ:
	add	al, '0'
	mov	[di], al
	inc	di
	xchg	ax, dx
	dec	bx
	dec	bx
	jns	short od_DIGIT
	add	al, '0'
	mov	[di], al
	popa
	add	di,5
	ret

decimals	dw	10
		dw	100
		dw	1000
		dw	10000


;
;
BlapMaze:
	mov	dx, MAZE_HEIGHT
bm_YLOOP:
	mov	cx, MAZE_WIDTH
	rep	movsb
	add	di, SCREEN_LINE-MAZE_WIDTH
	dec	dx
	jnz	short bm_YLOOP
	ret


DrawBorder:
	mov	cx, 3+(4*ZOOM_WIDTH)
	mov	dx, 3+(4*ZOOM_HEIGHT)
	call	DrawFrame
	add	di, (ZOOM_WIDTH*4/2)-1+((ZOOM_HEIGHT*4/2)-1)*SCREEN_LINE
	mov	cx, 5
	mov	dx, 5
	call	DrawFrame
	ret

DrawFrame:
	pusha
	mov	bx, cx
	pusha
	rep	stosb
	popa
	add	di, SCREEN_LINE
	sub	dx, 2
df_SIDES:
	mov	ES:[di], al
	mov	ES:[di+bx-1], al
	add	di, SCREEN_LINE
	dec	dx
	jnz	short df_SIDES
	rep	stosb
	popa
	ret

;
; Draw maze[DS:SI] at(BX,BP) 6x6 Zoom scr[ES:DI]
;
DrawZoom:
	sub	bx, (ZOOM_WIDTH/2)
	sub	bp, (ZOOM_HEIGHT/2)
	imul	ax, bp, MAZE_WIDTH
	add	si, ax
	add	si, bx

	mov	dh, ZOOM_HEIGHT
dz_YLOOP:
	pusha
	mov	dl, ZOOM_WIDTH
dz_XLOOP:
	mov	al, LGREY
	cmp	bx, MAZE_WIDTH
	jae	short dz_CLIP
	cmp	bp, MAZE_HEIGHT
	jae	short dz_CLIP
	mov	al, [si]
dz_CLIP:
	mov	ah, al
	mov	ES:[di], ax
	mov	ES:[di+2], al
	mov	ES:[di+SCREEN_LINE], ax
	mov	ES:[di+SCREEN_LINE+2], al
	mov	ES:[di+(2*SCREEN_LINE)], ax
	mov	ES:[di+(2*SCREEN_LINE)+2], al

	add	di, 4

	inc	bx
	inc	si
	dec	dl
	jnz	short dz_XLOOP

	popa
	add	di, (4*SCREEN_LINE)
	add	si, MAZE_WIDTH
	inc	bp
	dec	dh
	jnz	short dz_YLOOP
	ret

;
; ZF=Find(AL) in maze[ES:DI]
;
FindCell:
	pusha
	push	cx
	push	di
	mov	cx, MAZE_SIZE
	repnz	scasb
	pop	dx
	pop	cx
	jnz	short fc_FAIL
	dec	di

	xchg	ax, di
	sub	ax, dx
	sub	dx, dx
	mov	bx, MAZE_WIDTH
	div	bx
	mov	zoomX, dx
	mov	zoomY, ax
fc_FAIL:
	popa
	ret

;
; Check the "TOUR" maze array
;
CheckTour:
	;; gather maze cell freqs ;;

	lea	si, mino_buffer
	lea	di, mino_counts
	call	CountCells

	lea	si, tour_buffer
	lea	di, tour_counts
	call	CountCells

	;; now check route path ;;

	lea	si, tour_buffer
	lea	di, cycle_buffer
	mov	cx, MAZE_SIZE
	rep	movsb

	lea	di, cycle_buffer
	mov	cx, MAZE_SIZE
	mov	al, BEGIN_C
	repnz	scasb
	jnz	short ct_FAIL
	dec	di

	sub	dx, dx
	mov	ah, ROUTE_C
ct_FOLLOW:
	inc	dx
	mov	[di], al
	inc	al
	or	al, 0C0h
	inc	di
	cmp	ah, [di]
	jz	short ct_FOLLOW
	dec	di
	dec	di
	cmp	ah, [di]
	jz	short ct_FOLLOW
	sub	di, (MAZE_WIDTH-1)
	cmp	ah, [di]
	jz	short ct_FOLLOW
	add	di, (2*MAZE_WIDTH)
	cmp	ah, [di]
	jz	short ct_FOLLOW

	mov	routeSTEPS, dx
ct_FAIL:

	;; display the counts ;;

	sub	bx, bx
	lea	di, counts_inf
	call	OutCount2
	lea	di, counts_inf2
	call	OutCount2
	lea	di, counts_inf3
	call	OutCount2
	lea	di, counts_inf4
	call	OutCount2
	lea	di, counts_inf5
	call	OutCount2
	lea	di, counts_inf6
	call	OutCount2

	lea	si, counts_txt
	call	PrintMessage
	ret

CountCells:
	push	di
	sub	ax, ax
	mov	cx, 6
	rep	stosw
	pop	di

	mov	cx, MAZE_SIZE
cc_COUNT:
	lodsb
	cmp	al, EXIT_C
	jbe	short cc_OKAY
	cmp	al, ROUTE_C
	mov	al, 4
	jz	short cc_OKAY
	inc	ax
cc_OKAY:
	mov	bx, ax
	add	bx, bx
	inc	word ptr [bx+di]
	loop	cc_COUNT
	ret

;
;
OutCount2:
	mov	ax, mino_counts[bx]
	call	OutDec5
	add	di, 8
	mov	ax, tour_counts[bx]
	call	OutDec5
	inc	bx
	inc	bx
	ret

;
;
MakeDiff:
	mov	bx, (MAZE_SIZE-1)
md_DIFF:
	mov	al, tour_buffer[bx]
	cmp	al, BEGIN_C
	jz	short md_KEEP
	cmp	al, EXIT_C
	jz	short md_KEEP
	cmp	al, ROUTE_C
	mov	al, PATH_C
	jz	short md_KEEP
	mov	al, 0
md_KEEP:
	mov	diff_buffer[bx], al
	dec	bx
	jns	short md_DIFF
	ret

;
;
ToggleMap:
	mov	ax, [bx]
	add	ax, (2+2)
	cmp	ax, (3*4)
	sbb	dx, dx
	and	ax, dx
	mov	[bx], ax
	ret


;
; Print message[DS:SI]
;
PrintMessage:
	pusha
	push	ES
	mov	ES, scrSEG
	mov	bp, txtPEN
	jmp	pm_CALC

	;; decode & print 6x6 pixel char(AX) ;;
pm_PRINT:
	shl	bx, 3

	mov	ah,6
pm_CHRY:
	mov	al, dbugfont[bx]
	inc	bx

	add	al, al
	sbb	cl, cl
	add	al, al
	sbb	ch, ch
	add	al, al
	sbb	dl, dl
	add	al, al
	sbb	dh, dh
	and	cx, bp
	and	dx, bp
	mov	ES:[di], cx
	mov	ES:[di+2], dx		; decode bits 7..4

	add	al, al
	sbb	cl, cl
	add	al, al
	sbb	ch, ch
	and	cx, bp
	mov	ES:[di+4], cx		; decode bits 3..2

	add	di, SCREEN_LINE
	dec	ah
	jnz	short pm_CHRY
	add	di, 6-(6*SCREEN_LINE)
	inc	byte ptr txtX
pm_NEXT:
	mov	bl, [si]
	inc	si
	and	bx, 00FFh
	cmp	bl, PEN
	ja	short pm_PRINT		; not a control-code ?
	add	bx, bx
	jmp	cs:pm_JUMPS[bx]

pm_JUMPS	dw	pm_QUIT
		dw	pm_XTAB
		dw	pm_YTAB
		dw	pm_LOCATE
		dw	pm_CARRET
		dw	pm_PEN


pm_CARRET:
	mov	byte ptr txtX, 0
	inc	byte ptr txtY
	jmp	SHORT pm_CALC

pm_XTAB:
	lodsb
	mov	byte ptr txtX, al
	jmp	short pm_CALC

pm_LOCATE:
	lodsb
	mov	byte ptr txtX, al
pm_YTAB:
	lodsb
	mov	byte ptr txtY, al

	;; calc pixel addr from text (x*6,y*6) ;;
pm_CALC:
	mov	di, txtY
	mov	ax, txtX
	imul	di, di, (6*SCREEN_LINE)
	imul	ax, ax, 6
	add	ax, scrOFF
	add	di, ax			; [ES:DI] --> scr pixel
	jmp	short pm_NEXT

pm_PEN:
	lodsb
	mov	ah,al
	xchg	ax, bp
	jmp	short pm_NEXT

pm_QUIT:
	mov	txtPEN, bp
	pop	ES
	popa
	ret

	.data
	include	bug6x6.dw

	end	go

