; 96 bytes long
; prime numbers finder
; for hugi-compo#12
; by shr of Molecoola
; 28. 09. 2000.
; compile with nasm

model tiny                                      ; NEW
codeseg                                         ; NEW
p486                                            ; NEW

org 100h

start:
;get N
    cwde        ;->eax=0
    xor ecx,ecx
    mov si,5Ch
nextdigit:
    lodsb

    ;imul ecx,byte 10                           ; OLD
    imul ecx,10                                 ; NEW

    add ecx,eax

    ;sub byte [si],'0'                          ; OLD
    sub byte ptr [si],'0'                       ; NEW

    jnc nextdigit

;with parameter '0' or without parameter -> eax=ecx=0
    jecxz wreaxdec

    mov di,bp ;->di=09xxh
    mov al,2  ;->eax=2

;search for Nth prime
prime:
;sqrt(1millionth_prime_number) < 547th_prime_number, so we need store only
;the first 546 prime numbers
    cmp di,9ffh+546*4
    jae goon
    stosd
goon:

    ;loop search,ecx                            ; OLD
    loopd search                                ; NEW

;eax contains the appropriate number (prime or 0). ecx=0
;print eax (10 digits) + 0dh + 0ah
wreaxdec:
    mov cl,10      ;->ecx=10
    mov ebx,ecx    ;->ebx=10
    push cx

    ;push word 000Dh                            ; OLD
    db 68h,0dh,00h                              ; NEW

makestr:
    cdq            ;->edx=0
    idiv ebx
    add dl,'0'
    push dx
    loop makestr

    mov cl,12
putstr:
    pop dx
    mov ah,2
    int 21h
    loop putstr

    ret

search:
    inc eax      ;we check both even and odd numbers (from 3)
    mov si,bp    ;si points to prime numbers stored
base:
    push eax
    cdq          ;->edx=0 (eax < 16,000,000)

    ;div dword [si]                             ; OLD
    div dword ptr [si]                          ; NEW

    cmp eax,[si]
    lodsd        ;si points to next prime number
    pop eax
    jb prime     ;divider > sqrt(number) -> number is prime
    or edx,edx
    jnz base
notprime:
    jmp short search

end start                                       ; NEW
