model   tiny                                    ; NEW
codeseg                                         ; NEW
p486                                            ; NEW

;[section .text]                                ; OLD
;[bits 16]                                      ; OLD
;[org 100h]                                     ; OLD
org     100h                                    ; NEW


start:
        db      0ddh,0dah
        push    si

        mov     si, 81h
        xor     ecx, ecx
        cwde

;@@parse:imul    ecx, byte 10                   ; OLD
@@parse:imul    ecx,10                          ; NEW
        add     ecx, eax
        lodsb
        inc     bx
        aaa
        jnc     @@parse                 ; 0Ah terminates
       
        xor     ax, ax
        jecxz   @@showPrime

        mov     di, bp                  ; firstPrimes @ 09xxh
        inc     ax

@@next: mov     si, bp                  ; First divider in table
        inc     eax                     ; Next number to test

@@test: cmp     si, di                  ; Still a valid divider?
        jae     @@prime                 ; Jump if all dividers tested.

        push    eax
        cdq
                                        ; Is this candidate divisable?
        ;idiv    dword [si]                     ; OLD
        idiv    dword ptr [si]                  ; NEW
        lodsd
        pop     eax

        dec     dx
        jns     @@test                  ; No? Check next divider.
        js      @@next                  ; Yes. Not a prime.

@@prime:
        cmp     bh, 3
        jge     @@loop
        stosd
        inc     bx
@@loop:
        ;loop    @@next, ecx                    ; OLD
        loopd   @@next                          ; NEW


        ; THE prime found

@@showPrime:
        mov     cl, 0ah         ; CX=10 (length of output)
        mov     edi, ecx        ;  
        pop     si
@@show: cdq
        div     edi
        dec     si
        mov     [si], dl
        loop    @@show

        db      0bfh            ; mov di, imm16 to skip first int
@@wr:   int     29h
        lodsb
        add     al, '0'
        jns     @@wr

        retn
end     start
