	page	240, 132
;ENTRY.ASM	28-SEP-00
; by Boreal (who went nuts trying to shrink this)
;Display the Nth prime number.
; N is entered on the command line and is in the range 0..1000000.
;
;Assemble with:
; tasm /m entry
; tlink /t entry

	.486
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg
;also assume ax=0, cx=00FFh, [0000]=20CDh, df=0

	org	100h
start:
st10:	push	ax			;zero all the (extended) registers
	loop	st10			; especially eax, ecx, edx & ebp
	popad

;Read number (N) from command line and convert it to binary in ecx
	mov	si, 81h			;point to first char on command line
gn10:	imul	ecx, 10			; (leading space chars aren't a problem)
	add	ecx, eax
	or	di, [bx]		;clear af (*) and set fill pointer to
					; beginning of table of primes (20CDh)
	lodsb				;get character; al:= ds:[si++]
	aaa				;al:= al&0Fh; if al>9 then cf:=1
	jnc	gn10			;loop until carriage return

;Register usage:
; eax = number to test for primeness
;  bx = 0 = pointer to address (20CDh) of table of primes used for divisors
; ecx = count down of primes found so far
; edx = remainder, high word always = 0
;  si = table empty pointer
;  di = table fill pointer
; ebp = divisor, high word always = 0

	mov	[di], ax		;store anything >= 2 <= 7FFFh into table
	pop	ax			;eax:= 0
	jecxz	dn00			;if ecx = 0 then go display eax = 0
	inc	ax			;eax:= 1

;dx=0 initially
pr10:	dec	dx			;rem < divisor < sqrt(16M) = 4000 < 2^15
	jns	pr30			;jump if rem was not 0 (possible prime)
pr20:	 inc	eax			;get next number to test for primeness
	 mov	si, [bx]		;set empty pointer to beginning of table
pr30:	xchg	bp, ax			;get divisor from table; bp:= ds:[si++]
	lodsw
	cwd				;edx:= 0 (high word is always clear)
	xchg	bp, ax

	push	eax			;number / divisor
	div	ebp
	cmp	eax, ebp
	pop	eax
	jae	pr10			;if quotient < divisor then have prime
					; else loop
	test	di, di			;limit table size -- only 550 entries
	js	pr40			; are needed
	 stosw				;store prime into table;  es:[di++]:= ax
pr40:	loopd	pr20			;loop until desired prime is found

;Display decimal number in eax with leading zeros followed by CR, LF
dn00:	mov	cl, 10			;display 10 digits
	mov	bp, cx			;divisor = 10
	push	bp			;LF = 10 too
	push	0Dh			;CR

dn10:	cdq
	div	ebp			;divide by 10
	or	dl, 30h			;convert to ASCII (flags = 06h)
	push	dx			;save on stack
	loop	dn10

	lahf				;ah:= 6 = direct console I/O function
dn20:	pop	dx			;get character
	int	21h			;output it
	dec	dx			;loop until 0
	jns	dn20

	ret				;return to location 0 (= int 20h)


;(*) Although Intel does not document this, it has been determined by exhaustive
; testing that the or instruction clears the af flag.  The following test code
; verified this a 486, 3 different Pentiums (including a P3) and an AMD K6.
;
;start:	xor	di, di
;af05:	xor	si, si
;af10:	mov	ax, 0fh			;set af
;	add	ax, 1
;	mov	loc, di
;	or	loc, si			;clear af
;	aaa
;af20:	jc	af20			;lock up if not cleared
;	dec	si			;loop for all combinations of 16 bits
;	jne	af10
;	mov	al, '.'			;show that it's running
;	int	29h
;	dec	di			;loop for all combinations of 16 bits
;	jne	af05
;	ret
;
;loc	dw	0


cseg	ends
	end	start
