; *** Hugi-compo #12 (The Prime Number Finder Compo) ***
; Name:         Guillermo Sais (MemoMan)
; Country:      Mexico
; E-mail:       gsais@iname.com

Ideal
p486
p487

DEBUG           = 0                             ; don't assume anything

; the following conditionals are (supposedly) valid:
; NOTE: each one represents -1 byte
CHEAP_CRLF      = 0                             ; outputs newline as 10,13
CHEAP_NULL      = 0                             ; outputs a NUL after newline

; the following conditionals are all invalid (they're here just for fun)
; NOTE: each one represents -1 byte
DIRTY_INIT      = 0                             ; assumes 32 bits values
DIRTY_PARSE     = 0                             ; mistakes some inputs
DIRTY_TEST      = 0                             ; mistakes some inputs as 0
DIRTY_OUTPUT    = 0                             ; uses INT 29H for output

; maximum table length, higher values are ok (but slower)
MAX_TABLE       = 547                           ; sqrt(prime(1M))<prime(547)

segment         CodeSegment use16
assume          cs:CodeSegment,ds:CodeSegment,ss:CodeSegment
org             100h
Start:
; init
if              not(DEBUG eq 0)
xor             bx,bx
mov             cx,0ffh
endif
_init_loop:
push            bx
loop            _init_loop
if              DIRTY_INIT eq 0
popad
else
popa
endif

;parse
inc             bp
_parse_loop:
imul            ecx,10
if              DIRTY_PARSE eq 0
add             ecx,eax
else
add             cx,ax
endif
inc             si
mov             al,[bp+si+7fh]
aaa
jnc             _parse_loop

; find
TABLE_OFS       = ((8000h-(MAX_TABLE shl 1))and 0ff00h)
xchg            ax,bx
if              CHEAP_CRLF eq 0
mov             di,TABLE_OFS or 10
else
mov             di,TABLE_OFS or 13
endif
push            di
if              DIRTY_TEST eq 0
jecxz           _tostr
else
jcxz            _tostr
endif
_find_test_remainder:
idiv            ebx
dec             dx
jns             _find_inc_divisor
_find_loop:
inc             ebp
pop             si
push            si
_find_inc_divisor:
lodsw
cwd
xchg            ax,bx
mov             eax,ebp
cmp             si,di
jbe             _find_test_remainder
jl              _find_continue
stosw
_find_continue:
loopd           _find_loop

; tostr
_tostr:
mov             cl,10
mov             bx,cx
if              CHEAP_CRLF eq 0
push            13
else
push            cx
endif
_tostr_loop:
cdq
idiv            ebx
add             dl,'0'
push            dx
loop            _tostr_loop

; print
if              DIRTY_OUTPUT eq 0
lahf
_print_loop:
pop             dx
int             21h
if              CHEAP_NULL eq 0
dec             dh
js              _print_loop
else
dec             dx
jns             _print_loop
endif
else
_print_loop:
pop             ax
int             29h
dec             ax
jns             _print_loop
endif

; exit
ret

ends            CodeSegment
end             Start
