;-----------------------------------------------------------------------
; Entry: A program to print out the nth prime, 1<=n<=1000000
;
; To compile with MASM (6.00+): ml entry.asm
;
; Author: Jeff (latndude@erols.com)
;-----------------------------------------------------------------------

		title	entry
		.model 	tiny

		.code
		.386

		.startup

; AX = 0 (no invalid drives in FCBs)
; SI = 100h
; BP = 09xxh
; 

		xor	ebx, ebx	; Initialize EBX to hold n
		shr	si, 1		; SI points to cmd line
		lodsb			; AX = length of cmd line
		xchg	cx, ax		; CX = length of cmd line
next_num:
		lodsb			; Get digit or space
		and	eax, 0fh	; Space maps to 0
		imul	ebx, 10
		add	ebx, eax
		loop	next_num

		mov	al, 2		; Test first prime separately, EAX < 10
		dec	ebx
		jz	print_prime
		dec	ax		; Set EAX = 1
next_prime:
		inc	eax
		inc	ax		; EAX is even, so inc EAX is same as inc AX


;----------------------------------------------------------
; Loop through the primes
;
; Note: Since EAX is at most 2^32, then the square root
;       of EAX is at most 2^16, which can be contained
;       in a 16-bit register (CX)
;----------------------------------------------------------

		xor	ecx, ecx	; ECX is the test register
		inc	cx		; Set ECX to 1

try_again:
		inc	cx
		inc	cx		; Add 2 to ECX
		mov	edi, ecx
		imul	edi, edi	; EDI = ECX * ECX
		cmp	edi, eax	; Test numbers up to SQRT(EAX)
		ja	prime
		cdq
		push	eax		; Save EAX
		div	ecx		; Test for divisibility
		pop	eax		; Restore EAX
		test	dx, dx		; DX = 0 if not prime
		jnz	try_again
		jmp	next_prime
prime:
		dec	ebx
		jnz	next_prime

;----------------------------------------------------
; Print the number
;----------------------------------------------------

print_prime:
		mov	word ptr [si+1], 240ah	; SI points to 0Dh in cmd line
		mov	bl, 10			; EBX = 0 after above loop
		mov	cx, bx			; CX = BX = 10
next_digit:
		dec	si
		cdq
		div	ebx			; Divide by 10
		add	dl, '0'
		mov	[si], dl		; Store the digit
		loop	next_digit

		mov	dx, si
		xchg	bp, ax			; BP = 09xx
		int	21h			; Print string
		ret				; Jmp to CS:0000 (int 20h)

		END