;ENTRY.COM	09-29-2000	Program to display nth prime
;				using simplistic algorithm
;
;	WARNING! using undocumented behavior of CPUID instruction
;	and without testing whether CPU supports CPUID. Works for the
;	INTEL 486DX2-50 and PENTIUM-S that I tried, but not on Adok's
;	CPU I regret.
;
;	1,000,000th prime is 15,485,863 = 00EC:4BA7
;
;	Don't need to save prime factors beyond 3931 = 0F5Bh (the
;	truncated square root of max prime to find).
;
;		Copyright (c) Lawrence E. Boothby, 1999
;
				.RADIX 16
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
Parse:			STD	;to access prime factors table on stack
			XCHG	AX,DI		;DI<--0000, AX,FFFE
			DB 0F,0A2		;CPUID with EAX=????FFFE
			;because unsupported function in EAX, INTEL returns
			;EAX,EBX,ECX, and EDX<--00000000, which is useful
NextChr:		DB 66,6Bh,0C9,0A	;IMUL ECX,ECX,0A
			ADD	CL,AL		;can't overflow after IMUL
			OR	AX,240A		;=DB 0Dh,0A,'$'
			MOV	AL,[BX+SI-7F]
			;can't start at +82 because would miss 0Dh of nul line
			;will treat 20h as leading '0' (won't handle HTAB)
			;initial BX=0000,SI=0100 giving an initial [0081]
			INC	BX		;also clears AF for AAA
			AAA			;(AND AL,0F) and 0Dh sets CF
			JNB	NextChr
		;	DB 66
			POP	AX		;SP<--0000 for faster access to
			DB 66			;all those dword [DI]'s
			JCXZ	Output
			INC	AX
			DB 00	;skip next instruction doing ADD [BX-0004],BH
				;DI=0000, DWORD [DI]=????:20CDh, consequently
				;first prime candidate of 00000002 will be
				;immediately accepted and pushed on stack
;**********************------------------***************************************
NextTry:		MOV	DI,0FFFC	;search prime factors on stack
			DB 66
			INC	AX
NextCheck:		DB 66
			CWD			;clear	EDX
			DB 66
			PUSH	AX		;save candidate prime
			DB 66
			DIV	WORD PTR [DI]
			;only need to check for prime factors up to square
			DB 66			;root of candidate prime
			SCASW
	     ;		DB 66			;max EDX=00000F5A
			DEC	DX		;doesn't change CF!
			DB 66
			POP	AX		;get back candidate
			JS	NextTry		;not prime if has divisor
			JNB	NextCheck	;if more prime divisors
	     ;		CMP	SP,0F778	;actual required
			OR	SP,SP		;saves 2 bytes, wastes time
			JG	Skip		;to limit stack growth
			DB 66
			PUSH	AX		;add prime to table on stack
Skip:			DB 67			;LOOP (ECX)
			LOOP	NextTry		;counting down to nth prime
;**********************-----------------****************************************
Output:			MOV	CL,0A		;ECX<--0000000A
			MOV	BX,CX
			;SI=0100 still
NextDigit:		DB 66
			CWD			;must clear last remainder
			DB 66
			DIV	CX		;remainder -->DL
			ADD	DL,30
			DEC	BX		;see my HC10 for credits
			MOV	[BX+SI],DL
			JNZ	NextDigit
			MOV	DX,SI
			XCHG	AX,BP		;AX<--09XX<--BP
			INT	21
Exit:			INT	20
;*******************************************************************************
ONLY	ENDS
END	Parse
