;------------------------------------------------------------------------------
; entry.asm version 1.6
; Copyright (C) 2000 by Guido Hahn, email(ghahn@compuserve.com, 
;                                         mephware@web.de)
;
; This file was written for the Hugi Size Coding Competition #12: 
; find the n-th prime number
; on http://www.hugi.de/compo/
;
; ALIAS:    meph
; Country:  Germany
; Date:     08-27-2000               
; Compiler: ml (MASM) 6.14.8444		          
; Linker:   TLINK	7.1.30.1        
;                               
; Compile:  ml /c  entry.asm
; Link:     TLINK  /t entry
;
; Size: 86 Bytes
; 
; THIS SOFTWARE IS PROVIDED BY GUIDO HAHN ``AS IS AND WITHOUT
; ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
; IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
; SUCH DAMAGE.
;
;------------------------------------------------------------------------------

;<snip>
;You may assume that
;  ... the registers have these values (all in hex):
;      (xx - means an unknown value which MUST NOT be assumed)
;
;          EAX = xxxx****
;                AL = 00 if first FCB has valid drive letter,  FF if not
;                AH = 00 if second FCB has valid drive letter, FF if not
;          EBX = xxxx0000
;          ECX = xxxx00FF
;          EDX = xxxxxxxx
;  DX  = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.
;          ESI = xxxx0100
;          EDI = xxxxFFFE
;          EBP = xxxx09xx
;          ESP = xxxxFFFE
;          EIP = xxxx0100
;
;  EFLAGS (binary) = xxxxxxxx xxxxxxxx xxxx0x1x xx0x0x1x
;      i.e.
;          DF = 0
;          IF = 1
;          other flags = x
;
;          WORD [FFFE] = 0000
;          Layout of PSP: see [Memory Layout]
;<snip>

.586

deb_startup macro     ;;initialize register values				
      xor ax, ax
      xor bx, bx	
      mov cx, 0ffh
      mov dx, cs
      mov es, dx
      mov si, 100h
      mov di, 0fffeh
      mov sp, di
      mov bp, 0912h
      cld
endm

AdrPref macro x
      db 67h
      x
endm

OpPref macro x
      db 66h
      x
endm

_cseg segment para public 'code' use16
assume cs:_cseg, ds:_cseg, es:_cseg, ss:_cseg
_cseg ends

_cseg segment
org 100h										
start:	              

print:                                  ;the end of the output buffer
    db 13, 10, '$'                      ;cr lf + end of string (or ax, 240ah)     
          
ifdef DEBUG
    deb_startup
endif          
 
    mov bl, 5dh
    xchg bx, si                         ;si -> command line, bx = 0100h       
                                        ;Note: now reading from fcbs, because of the
                                        ;problems with entries without commandline,
                                        ;they had problems with garbage that was left
                                        ;from previous calls.                        
    xor ecx, ecx                        ;ecx = 0
    xor eax, eax                        ;eax = 0
get_cmd:
    imul ecx, 10                             
    add ecx, eax  
    lodsb                               ;get next digit
    sub al, '0'                         ;convert ascii to hex
    jns get_cmd
    

    pop ax                              ;eax = 0, sp = 0    
    jecxz done
            
    inc ax                              ;eax = 1
fp2:   
    inc eax                             ;increase to next test value                                                                                                                                   
    mov di, 28                          ;point di to the begin of the prime
                                        ;buffer, to a place, which is != 0,
                                        ;!=1 and !=2 (Job File Table)
fp3:
    push eax
    cdq                                 ;eax < 80000000h -> edx = 0
    div dword ptr[di]                   ;check if it is divideable
        
    sub di, 32
    pop eax
    test dx, dx                         ;             "
    jz fp2
                                   
    cmp di, sp                          ;that slows things down, but
    jns fp3                             ;saves some bytes  
fp0:  
    jg short fp1                        ;we need only to store 546 primes,
                                        ;I store some primes more but not too
                                        ;much, so that we don't run out of time!!!

    pushad                              ;store some primes, 
                                        ;Note: eax = primes, 
                                        ;      sp-=32 to limitate the number of
                                        ;      primes stored.
fp1:
    AdrPref <loop fp2>                  ;use ecx as counter

done:
    mov cl, 10
hex2ascii:        
    cdq 
    div ecx
    add dl, '0'
    dec bx
    mov byte ptr[bx], dl                ;store digit in buffer                                        
    mov dl, low(offset print-10)        ;point dx to output buffer  
    cmp bx, dx                
    jnz hex2ascii
                                                 
    xchg ax, bp                         ;mov ah, 09h
    int 21h                             ;print prime
                               
    int 20h                             ;return to dos
    
   
_cseg ends

end start