;Prime number finder for Hugi Size Compo #12
;
; by Metalbrain (metalb@aluesi.us.es)
;
;Compile with NASM: nasm ENTRY.NAS -o ENTRY.COM
;
;Slow version - Doesn't fit the 90 seconds rule

                org     256

stackzeros      push    bx              ;Fill stack with zeros
                loop    stackzeros
                popad                   ;Clear regs
                mov     si,81h          ;At command line...
get_next        imul    ecx,byte 0Ah    ;multiply previous value by 10
                add     ecx,eax         ;add current byte
                lodsb                   ;get byte from ds:si
                sahf                    ;clear AF
                aaa                     ;ascii->byte, space is harmless
                jnc     get_next        ;if above 9 (enter=13), end parsing
                inc     dx              ;First time: 0, don't increase number
nofound         dec     dx              ;Remainder is zero?
                                        ;(First time DX is zero, so it passes)
                jns     iloop           ;No: continue testing number
oloop           mov     si,1            ;Starting divisor -2
                inc     edi
                cmp     di,3            ;2 -> 3 exception
                jz      iloop
                inc     di              ;Increase number to test
iloop           lodsw                   ;Increase divisor
                mov     eax,edi
                xor     dx,dx           ;Clear DX
                div     esi             ;Perform division
                cmp     eax,esi
                jnc     nofound         ;If quotient < divisor, found a prime
                dec     ecx             ;Prime number, continue till we find
                jns     oloop           ; the Nth
                xchg    eax,edi         ;Get number in eax
                mov     bl,10           ;Divisor
                mov     cx,bx           ;10 digits to be printed too
                push    byte -38        ;0ah-48
                push    byte -35        ;0dh-48
digit           xor     dx,dx           ;Clear DX
                div     ebx             ;Divide by 10
                push    dx              ;Store digit
                loop    digit
                mov     cl,12           ;10 digits+CR+LF
print           pop     dx              ;take digit
                add     dl,48           ;convert
                mov     ah,2
                int     33              ;print
                loop    print
                ret                     ;Exit
