;-----------------------------------------------------------------------
; Hugi Compo 12
; Eduardo de la Pena - edelapena@arnet.com.ar
;-----------------------------------------------------------------------


;-----------------------------------------------------------------------

b	equ byte ptr
w	equ word ptr
d	equ dword ptr

.MODEL TINY
.CODE
.386
		ORG 100h
;---------------------------------------
start:		db 0Dh,0Ah,'$'          ; execute OR AX,240Ah

clean:		push bx 		; CX = 00FFh , BX = 0000
		loop clean		; push zeros into stack
		popad			; clean all 32 bit registers

		mov si,5Dh		; read command line via FCB1
Next:		imul ecx,10		; must be <= 8 digits
		add ecx,eax
		lodsb
		sub al,'0'              ; the string terminate with spaces
		jnc Next
;---------------------------------------
		mov bp,sp
		jecxz Int2Asc
		inc di
		inc di			; EDI = 2
		jmp short InitLoop

NextDivisor:	dec dx
		jns NotPrime

NextNumber:	inc edi
		mov si,bp		; SI = primes table init + 4

NotPrime:	sub si,4
		mov eax,edi
		cdq
		div d [si]
		cmp eax,[si]
		jae NextDivisor
		or  sp,sp		; Build a table with primes
		jns NoPush		; until SP < 8000h
InitLoop:	push edi		; it's too large, but save
					; program bytes
NoPush: 	loopd NextNumber
;---------------------------------------
Int2Asc:	leave

		mov cl,10		; CX = 10
		mov si,cx		; SI = 10
		mov bh,1

		xchg eax,edi
NextDig:	pop dx			; DX = 0
		div esi 		; EDX = 0000 00xx after division
		or dl,'0'
		dec bx
		mov [bx],dl
		loop NextDig

		mov dx,bx
		mov ah,9
		int 21h
;---------------------------------------
		ret			; [SP] = 0
;---------------------------------------

end	  start

