;*** Entry for HC #12, Prime number finder
;    by Ruud v Gessel

; Method: Trial and error, simply divide every value by all
;         preceding primes (upto the sqrt of the value, or 
;         value/n<n ) and call it a prime if it can't be
;         divided by any. Now if the prime is small enough,
;         add it to the divider table.

by  EQU <BYTE PTR>
wo  EQU <WORD PTR>
dwo EQU <DWORD PTR>
off EQU <OFFSET DS:>

;Note 1 : if an interrupt occurs after popping si and before
;         dividing by [di], the flag will be stored on 0fe1eh
;         this is not a problem since flags is always greater
;         than 2.

                    .MODEL    TINY
                    .586
                    LOCALS

SALC                MACRO
                    db        0d6h
                    ENDM

                    .CODE
                    ORG       100h

Start:              push      bx                  ;push 0
                    loop      Start               ;push 0ffh words
                    popad                         ;All extended regs 00000000h
                                                  ;sp=0fe20h, [sp=0]
                    push      5dh                 ;Need [0fe1e]>2 See note 1
                    pop       si                  ;First FCB padded with ' '
@@0:                imul      ecx,ebx             ;10 ECX
                    add       ecx,eax             ;10 ECX+EAX
                    lodsb
                    sub       al,'0'              ;Decimal (first '0')
                    mov       bl,10               ;
                    jnc       @@0                 ;>> More decimals
                    std
                    jecxz     @@EndPgm            ;>> ZERO

@@Txt:              inc       bp                  ;First prime = 2

                    db        0dh,0ah,'$'  ; or ax,240ah

@@NextPrime:        mov       di,0fe1eh           ;Start of table
                    inc       ebp                 ;Next value to test
@@DivNext:          mov       eax,ebp             ;Needed in edx:eax
                    div       dwo [di]            ;Divide --> Test for prime
                    dec       dx                  ;Sqrt(max)<8000h!!
                    cdq                           ;Keep edx = 0
                    js        @@NextPrime         ;>> Surely no prime
                    scasd                         ;Above sqrt ebp?
                    jnc       @@DivNext           ;>> Nope need to test more
                    or        sp,sp
                    jns       @@8                 ;>> Table has enough primes
                    push      bp                  ;Store prime in table
                    push      dx                  ;Allows ret to end proggy
@@8:                loopd     @@NextPrime         ;Have a prime, count down

@@EndPgm:           mov       cl,9
                    mov       di,off @@Txt
                    xchg      ebp,eax

@@x:                div       ebx
                    xchg      ax,dx
                    or        al,30h
                    stosb
                    SALC
                    xchg      ax,dx
                    loop      @@x
                    mov       dx,di
                    mov       ah,9
                    int       21h
                    ret

                    END       Start
