			;NASM-IDE ASM Assistant Assembler Project File
[BITS 16]		;Set code generation to 16 bit mode
[ORG 0x0100]		;Set code start address to 0100h


[SEGMENT .text]		;Main code segment


			xor ebx, ebx                  ;ebx = 0
			xor edi, edi                  ;edi = 0
					
			
			mov si, 0x80
                        mov cl, byte [si]             ;cx = commandline length
                        jcxz TOASCII                  ;cx == 0 -> Ausgabe
                        dec cl
                        lodsb
                        lodsb

			
READCLINE:              xor eax, eax
			lodsb                         ;eax = commandline chars
                        xor al, 0x30                  ;to bcd

                        push cx
                        dec cx
                        jcxz @@cxzero
@@mulloop:		imul eax, byte 10             ;eax *= 10^(cx-1)
                        loop @@mulloop
			
@@cxzero:               pop cx
                        add ebx, eax                  ;ebx += eax
                        loop READCLINE
                        jz TOASCII                    ;nPrime == 0 -> TOASCII

                        inc di                        ;edi = 0

			                              ;nPrimes = ebx
                                                      ;Prime = edi
NEXTPRIME:              xor ecx, ecx
                        inc edi
                        inc cx                        ;Divisor = ecx
@@nextdiv:              mov eax, edi                  ;eax = prime
                        inc cx
                        cdq                           ;edx = 0
                        div ecx                       ;prime/divisor
                        cmp eax, ecx
                        jb @@prime                    ;result < divior -> Prime
                        test dx, dx                   ;dx == 0 ?
                        jnz @@nextdiv
                        jmp NEXTPRIME

@@prime:                dec ebx                       ;nPrime--
                        jnz NEXTPRIME



TOASCII:	        mov  eax, edi                 ;eax = Prime
                        mov  bl, 10                   ;ebx = 10
                        mov  cx, bx                   ;cx = 10
                        push ebx                      ;newline
                        push word 13

@@divloop:		cdq                           ;edx = 0
			div ebx                       ;prime/10
			xor dl, 0x30
			push dx                       ;push rest
			loop @@divloop

                        mov ah, 2
                        mov cl, 12                    ;cx = 12

@@onscreen: 		pop dx
			int 0x21
			loop @@onscreen

                        ret

[SEGMENT .data]		;Initialised data segment

[SEGMENT .bss]		;Uninitialised data segment
