;;
;;  Stefan's Entry to Hugi Size Coding Competition #12 -- Prime Numbers
;;
;;  Fourth take. 92 bytes. Should conform to latest rules (test suite 6).
;;
;;  Assumptions:
;;  + ax = 0, cx = 00FFh (>27 should suffice)
;;  + cld
;;  + 386 or higher
;;  + CP/M-86 or better ;-)
;;
;;  Assemble with TASM (tasm /m, tlink /t). Takes ~180 sec for prime
;;  #1000000 on a vanilla 200 MHz Pentium. This makes, according to
;;  Adam Ries, 60 sec on 600 MHz.
;;
;;  Did you know that DOSEMU boots 10 times faster after a `rsh localhost'?
;;
;;  Have fun,
;;    Stefan  <Streu@gmx.de>
;;

		MODEL	TINY
		CODESEG
		JUMPS
		P386
		ORG	100h

TABLESIZE = 550				; # of primes saved in lookup table
					; (550th prime) ^ 2 > (1000000th prime)
					; (550th prime) < 2^15
xloop	MACRO target
		db	67h             ;; or does anyone know how to make
		loop	target		;; tasm generate a loop with ecx?
	ENDM

Start:
	;=== Parse Command Line ===
PushLoop:	push	ax		; on proper invokation, ax = 0
		loop	PushLoop
		popad			; all registers zero

		mov	si, 5Dh		; 1st FCB; DOS was so kind to remove
					; leading whitespace
CmdLoop:	imul	ecx, 10		; ecx = # of prime wanted
		add	ecx, eax
		lodsb
		sub	al, '0'
		jnb	CmdLoop

	;=== Set up registers ===
		mov	di, [di]	; di = 20CDh = offset Buffer
		pop	ax		; eax = 0
		jecxz	Found		; zeroth prime = 0

		inc	bx		; ebx = 1 = first prime minus 1

	;=== Main Loop ===
NextPrime:	inc	ebx
		mov	si, offset Buffer
TestNext:	cmp	si, di		; all stored denominators tested?
		jnb	StorePrime
		lodsw
		cwd			; edx = 0 (ax < 15 bit)
		xchg	bp, ax		; ebp = denominator
		mov	eax, ebx	; ebx = prime candidate
		div	ebp
		dec	dx		; remainder always < 15 bit (positive)
		js	NextPrime	; remainder was 0 -> not a prime
		jmp	TestNext

OutputBuffer:	db	13, 10, 36	; from here backwards 10 bytes will
					; be overwritten

	; here:	ebx = prime number to store in table
StorePrime:	mov	eax, ebx
		cmp	di, offset Buffer[2*TABLESIZE]
		jae	SkipStore	; only save TABLESIZE primes
		stosw			; (more is not needed)
SkipStore:	xloop	NextPrime

	; Found our number (eax) - output it
Found:		mov	cl, 10	        ; cx = digit counter (ecx was zero)
		mov	bp, cx		; ebp = base

		mov	di, offset OutputBuffer
OutLoop:	pop	dx		; edx = 0
		div	ebp
		add	dl, '0'
		dec	di
		mov	[di], dl
		mov	dx, di
		loop	OutLoop
		mov	cl, 9		; Hehe... Nix int 21h.
		jmp	DOS

		ORG	20CDh

Buffer:		dw	TABLESIZE dup (?) ; prime numbers

		ORG 5
DOS:	

		END	Start

;; Local Variables:
;; mode: asm
;; End:
