	page	240, 132
;CLOCK.ASM	26-SEP-00
;Analog Clock
; by Lenny Boreal
;
;Assemble with:
; tasm /m entry
; tlink /t entry
;
;This program was originally designed by TAD and Ruud for use in the Hugi
; Size Coding Compo #12. It was abandoned because the rules became too
; complex. This version has the luxury of ignoring the rules, and thus is
; somewhat modified from the original.
;
;The technique of bit-plane animation is used. The four bit planes of mode
; 6Ah (800x600 x 16 colors) are divided into two pairs. While the code is
; writing to one pair, the other is displayed. When the code is finished
; writing, the pairs are flipped, and the newly written image is displayed.
; This eliminates flicker, which is typically caused by displaying images
; while they are being erased. The cost of this technique is that only four
; colors can be displayed instead of the normal 16.
;
;Unfortunately IBM designed an excessively complex display card, then
; compounded their error with very poor documentation. To completely
; understand why this program manipulates the VGA registers the way it does
; requires a whole book. "The Programmer's Guide to the EGA and VGA Cards"
; by Richard Ferraro will do the job, although I can't really recommend it.
; Loren Blaney has distilled a vast amount of information into two
; drawings, although you'll probably need the book to understand them.
;
;You can reach me c/o Loren Blaney at: loren_blaney@idcomm.com
;
;The 4 Colors:   Plane: 3210		;each bit is written to a separate plane
Black		equ	0000b		;actual color is determined by palette
Brown		equ	0101b		; registers (see Palette)
Red		equ	1010b		;each pair of planes gets the same color
White		equ	1111b

	.486
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg
;also assume ax=0, bx=0, di=FFFEh, df=1
	org	100h

start:	fninit				;initialize math coprocessor
	mov	al, 6Ah			;set video mode 6Ah (800x600x16) (ah=0)
	int	10h

	mov	ax, 1002h		;set palette registers and border color
	mov	dx, offset Palette
	int	10h

	push	0A000h			;point es to video memory
	pop	es

;Draw clock face, which is built from filled circles
	inc	di			;write to all 4 bit planes; di:= FFFFh
	call	SetOutput		;(alters ax, dx, di)
	mov	si, offset FaceTbl
face10:	lodsw				;get color and radius; ax:= ds:[si++]
	mov	bl, ah			;radius; (bh=0)
	call	CCircle			;cx=400, dx=300
	cmp	ah, FaceEnd
	jne	face10

;Draw dial marks
	mov	si, 3600-60		;bearing = 59-second mark (10ths of deg)
	mov	ah, 5			;tick counter
dial10:	mov	al, 0*16+Black		;1 pixel thick
	mov	cx, 6			;length
	mov	bp, 148			;distance to start point
	dec	ah
	jne	dial20

	mov	ax, 0500h + 1*16+Black	;reset tick counter; 3 pixels thick
	mov	cl, 24			;longer line
	mov	bp, 140
dial20:
	call	DrawRLine		;cx:=-1, dx:=si
	sub	si, 60			;next bearing
	jge	dial10

;Draw Roman numerals
	mov	bl, 12			;for bx:= 12 downto 1... (bh=0)
Rom10:	imul	dx, bx, 300		;base angle:= numeral * 30 degrees
					; (angles are in tenths of degrees)
	mov	al, [bx+CenAdj-1]	;adjust base angle to center numeral
	cbw				;ah:= 0
	sub	dx, ax

	mov	al, [bx+Nums-1]		;get digit: I, V, or X
Rom40:	push	ax			;(ah=0)
	and	al, 11000000b		;bits * 10 bytes/entry
	shr	al, 6
	imul	si, ax, 10		;set pointer to pen-stroke data (ah=0)
	add	si, offset DatX-10	;si:= DatX-10 + (al&C0h)>>6*10

;Draw a Digit (I, V, or X)
Rom50:	lodsb				;bp:= distance to start pt; al:= [si++]
	xchg	bp, ax			;(ah=0)

	lodsb				;di:= bearing to start pt; al:= [si++]
	cbw
	add	ax, dx			;add base angle
	xchg	di, ax			;temporarily save it in di

	push	dx			;save base angle
	lodsb				;dx:= line angle; al:= ds:[si++]
	mov	ah, 10			;ax:= al * 10 (so a byte is sufficient)
	mul	ah
	add	dx, ax

	lodsb				;cx:= length; al:= ds:[si++]
	cbw				;(ah=0 for top of loop too)
	mov	cx, ax

	lodsb				;get thickness & color; al:= ds:[si++]

	push	si
	mov	si, di			;get bearing to start point
	call	DrawLine		;cx=-1
	pop	si			;restore pointer to pen-stroke data
	pop	dx			;restore base angle

	cmp	[si-4], bh		;loop for 2 or 3 entries per digit
	jl	Rom50			; (bh=0)


	pop	ax
	add	dx, 30			;move to next digit
	shl	al, 1			;shift 2 bits to get next digit
	jnc	Rom59			;if digit # I then add 30 more (3 deg)
	js	Rom60			; (I = 11b)
Rom59:	add	dx, 30
Rom60:	shl	al, 1			;remainder of 2-bit shift
	jne	Rom40			;loop until no more digits for numeral

	dec	bx			;loop for next numeral
	jne	Rom10
;(bx=0)
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	mov	di, 0003h		;initialize bit-plane mask
	push	di			;save 0003h
MainLoop:
	call	SetOutput		;flip displayed/written bit planes in di
					; (ax, dx, di are altered)
;Erase hands
	mov	bl, 130			;radius (bh=0)
	mov	ax, 2C00h + White	;get time function + white
	call	CCircle			;cx=400, dx=300
	int	21h			;ch=hours, cl=minutes, dh=seconds, dl=hu

;Push bearing (in tenths of degrees) of second hand
	mov	al, dh			;push dh*60
	mov	bl, 60
	imul	bl
	push	ax

;Push bearing (in tenths of degrees) of minute hand
	mov	al, cl			;ax:= cl*60 + dh
	imul	bl
	add	al, dh
	adc	ah, bh			;(bh=0)
	push	ax

;Calculate bearing (in tenths of degrees) of hour hand
	mov	bl, 12			;si:= ch*300 + ax/12; (bh=0)
	cwd
	div	bx			;ax:= quotient
	shr	cx, 6			;cl < 64 minutes thus its 2 high bits =0
	imul	si, cx, 75		;75 takes one less byte than 300
	add	si, ax

;Draw hour hand (si=bearing)
	mov	al, 3*16+Black		;width of hour hand = 7 pixels; (bh=0)
	mov	cl, 96			;length; (ch=0)
	mov	bp, -16			;start
	call	DrawRLine		;cx:=-1, dx:=si
;	mov	bl, 12			;draw decorative ring; (bx=12)
	inc	cx			;cx:= 0
	mov	bp, 30
	call	ECircle			;cx:=endX, dx:=endY
	mov	al, White
	mov	bl, 6			;(bh=0)
	call	Circle

;Draw minute hand
	mov	al, 1*16+Black		;width of minute hand = 3 pixels; (bh=0)
	mov	cx, 156			;length
	pop	si			;bearing
	mov	bp, -32			;start
	call	DrawRLine		;cx:=-1, dx:=si
	mov	bl, 8			;radius; (bh=0)
	call	CCircle			;cx=400, dx=300

;Draw second hand
	mov	al, 0*16+Red		;width of second hand = 1 pixel; (bh=0)
	mov	cx, 160			;length
	pop	si			;bearing
;	mov	bp, -32			;start; (bp=-32)
	call	DrawRLine		;cx:=-1, dx:=si
	mov	bl, 6			;radius; (bh=0)
	call	CCircle			;cx=400, dx=300

	mov	ah, 01h			;loop until keystroke
	int	16h
	je	MainLoop

	pop	ax			;restore text mode; ax:= 0003h
	int	10h
	ret				;return to DOS

;-------------------------------------------------------------------------------
;Draw a radial line, a line that radiates from the center of the screen
; Outputs:
;  cx:= -1
;  dx:= si
;
DrawRLine:		
	mov	dx, si			;line bearing = start point bearing
					;fall into DrawLine...
;-------------------------------------------------------------------------------
;Draw a line segment
; Inputs:
;  al = color & thickness (0 = 1 pixel, 10h = 3 pixels, 20h = 5 pixels, etc.)
;  cx = length (pixels)
;  dx = angle (bearing -- clockwise from straight up -- tenths of degrees)
;  si = angle (bearing) of vector to starting point of line (tenths of degrees)
;  bp = distance from center of screen to starting point of line segment
; Outputs:
;  cx = -1
;
DrawLine:		
dl10:	pusha				;save ax, bx, cx, dx
	aam	16			;unpack color and thickness
	mov	bl, ah			;bl:= thickness
	call	ECircle			;cx:=endX, dx:=endY
	popa				;restore ax, bx, cx, dx

	dec	cx
	jge	dl10
	ret

;-------------------------------------------------------------------------------
;Draw a circle centered at 400,300
; Inputs:
;  al = color
;  bx = radius (pixels)
; Outputs: cx=400, dx=300
;
CCircle:
	xor	cx, cx
	xor	dx, dx
	jmp	ecir90

;-------------------------------------------------------------------------------
;Get coordinates of end of line segment and draw a circle there
; Inputs:
;  al = color
;  bx = radius (pixels)
;  cx = length of line segment (<=255)
;  dx = angle (bearing) of line segment
;  si = angle (bearing) of vector to starting point of line segment
;  bp = distance from center of screen to starting point of line segment
; Outputs X,Y coordinates of end of line segment:
;  cx = Xend = 400 +  bp*sin(si) + cx*sin(dx)
;  dx = Yend = 300 - [bp*cos(si) + cx*cos(dx)]
;
;                      + X,Y
;	|     |      /
;	|     |    / cx
;	|     |dx/   <- line segment
;	|     |/
;	|    /
;	|   / bp
;	|si/
;	| /
;	|/
;     --+--------------
;	|
;
ECircle:
;	inc	dx			;avoid rounding errors with sin(30), etc
;	inc	si

	pusha				;save registers and set up stack frame
	mov	si, sp			;(ds=ss)
	mov	cl, 2			;(ch=0)
ecir10:	fldpi
	fidiv	w1800			;pi/1800
	lodsw				;adj pointer
	fimul	word ptr [si]		;*si (2nd pass: *dx)
	fsincos				;st(1)=sin; st(0)=cos
	lodsw				;adj pointer
	fimul	word ptr [si]		;*bp (2nd pass: *cx)
	fxch	st(1)
	fimul	word ptr [si]		;*bp (2nd pass: *cx)
	lodsw				;adj pointer
	lodsw				;adj pointer
	loop	ecir10

	faddp	st(2)			;bp*sin(si) + cx*sin(dx) 
	faddp	st(2)			;bp*cos(si) + cx*cos(dx)
	fistp	word ptr [si+12-16]	;cx:= X (relative to center of screen)
	fistp	word ptr [si+10-16]	;dx:= Y
	popa				;restore registers (except cx & dx)

	neg	dx
ecir90:	add	cx, 400			;add Xcenter
	add	dx, 300			;Ycenter - Y
					;fall into Circle...
;-------------------------------------------------------------------------------
;Draw a circle
; Inputs:
;  al = color
;  bx = radius (pixels)
;  cx = X coordinate of center (pixels)
;  dx = Y coordinate of center (pixels)
;
;Register usage:
; al = color
; bx = decision variable, initially = radius
; cx = X coordinate of center
; dx = Y coordinate of center
; si = X coordinate relative to center
; di = Y coordinate relative to center
;
Circle:
	pusha
	xor	si, si			;X coordinate relative to center
	mov	di, bx			;Y coordinate relative to center

cir10:	sub	bx, di
	sub	bx, di
	jge	cir30

cir20:	inc	si
	add	bx, si
	add	bx, si
	jl	cir20


cir30:	pusha				;save cx, dx, si
	sub	cx, si			;left end of line
	shl	si, 1			;double length

cir40:	pusha				;save cx, dx, si, di
	sub	dx, di			;top line, then bottom line

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Draw a horizontal line
; Inputs:
;  al = color
;  si = length in pixels -1
;  cx = X coordinate (of left end of line)
;  dx = Y coordinate

	imul	di, dx, 100		;calc byte address = Y*100 + X/8
dhl10:	pusha				;save al, cx
	mov	bp, cx			;calc bit position within byte
	and	cl, 07h
	shr	bp, 3			;div X by 8 to get byte position
	add	di, bp

	xchg	bx, ax			;bl:= color
	mov	ax, 8008h		;ah = MSB; al = Bit Mask register
	shr	ah, cl			;shift 80h into bit position
	mov	dx, 3CEh		;Bit Mask register:= ah
	out	dx, ax
	xchg	bl, es:[di]		;read to latch other bits, write new bit
	popa				; at masked location (write mode 2)

	inc	cx			;move one pixel to the right
	dec	si			;loop for "length" many pixels
	jns	dhl10

	popa				;restore cx, dx, si, di
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	neg	di			;loop for bottom line
	js	cir40

	popa				;restore cx, dx, si


	dec	di			;move up to next horizontal line
	jge	cir10			;(draw center line too)

	popa				;restore bx, si, di
	ret

;-------------------------------------------------------------------------------
;Set VGA registers to allow writing to one pair of bit planes while displaying
; the other pair.
; Inputs: di = mask to enable writing
; Outputs: di = low byte complemented
;          ax, dx are destroyed
;
SetOutput:
	xchg	ax, di			;get mask
	mov	dx, 3C4h		;Sequencer Map Mask register:= al
	mov	ah, al			;3C4(2):= al
	mov	al, 2			;this enables the bit planes for writing
	out	dx, ax

;Color Plane Enable register:= ~ah; 3C0(12):= ~ah
;This enables the bit planes for display
;To write to this register we must deal with yet another unfortunate IBM
; design feature.
	mov	dl, 0DAh		;clear address flip-flop
;	cli				;beware of interrupts in Windows, etc.
	in	al, dx

	mov	dl, 0C0h		;select Color Plane Enable register
	mov	al, 32h			;12h + Palette Address Source (PAS) bit
	out	dx, al

	mov	al, ah			;write complemented mask to Color Plane
	xor	al, 0Fh			; Enable register
	out	dx, al
;	sti

	xchg	di, ax			;save complemented mask

	mov	dl, 0CEh		;Mode register:= 2
	mov	ax, 0205h		;3CE(5):= 2
	out	dx, ax			;write mode 2
	ret

;-------------------------------------------------------------------------------
;The palette registers (which determine the colors) are the same for the two
; pairs of bit planes. The other values (xxxxx) aren't used and don't matter.
					;pair:  2  1
Palette	db	0			;black 00 00
	db	14h			;brown 00 01
	db	4			;red   00 10
	db	3fh			;white 00 11

	db	14h			;brown 01 00
	db	0			;xxxxx 01 01
	db	0			;xxxxx 01 10
	db	0			;xxxxx 01 11

	db	4			;red   10 00
	db	0			;xxxxx 10 01
;	db	0			;xxxxx 10 10
;	db	0			;xxxxx 10 11

w1800	dw	1800			;180 degrees = 1800 tenths of degrees

	db	3fh			;white 11 00
	db	0			;xxxxx 11 01
;	db	0			;xxxxx 11 10
;	db	0			;xxxxx 11 11

;	db	0			;black border

;Color and radius of concentric circles making up clock face
FaceTbl	db	Brown, 242
	db	Black, 230		;(Black=0=border)
	db	White, 225
	db	Black, 156
FaceEnd	equ	154
	db	White, FaceEnd

;Roman numerals (2 bits per digit: I=11b, V=10b, X=01b)
Nums	db	11000000b		;I
	db	11110000b		;II
	db	11111100b		;III
	db	11111111b		;IIII
	db	10000000b		;V
	db	10110000b		;VI
	db	10111100b		;VII
	db	10111111b		;VIII
	db	11010000b		;IX
	db	01000000b		;X
	db	01110000b		;XI
	db	01111100b		;XII

;Angles (in tenth's of degrees) to back off (ccw) in order to center numeral
CenAdj	db	0			;I
	db	15			;II
	db	30			;III
	db	45			;IIII
	db	15			;V
	db	30			;VI
	db	45			;VII
	db	60			;VIII
	db	25			;IX
	db	10			;X
	db	20			;XI
	db	50			;XII

;Line segments for numerals (Distance, Bearing, Angle, Length, Thickness/Color)
DatX	db	214			;X
	db	-12
	db	155
	db	42
	db	1*16+Black

	db	214
	db	36			;terminator >= 0
	db	205
	db	42
	db	0*16+Black

DatV	db	214			;V
	db	-12
	db	168
	db	40
	db	1*16+Black

	db	214
	db	36			;terminator >= 0
	db	193
	db	40
	db	0*16+Black

DatI	db	214+1			;I
	db	-18
	db	90
	db	12
	db	0*16+Black

	db	174+1
	db	-18
	db	90
	db	10
	db	0*16+Black

	db	214
	db	0			;terminator >=0
	db	180
	db	38
	db	1*16+Black

cseg	ends
	end	start
