/******************************************************************************
* testit v06 - test-suite for hc12 - find n-th prime number
*              on http://www.hugi.de/compo
*
* Copyright (C) 2000 by Guido Hahn(meph), ghahn@compuserve.com, mephware@web.de 
* 
* Compiler: cl v12.00.8168
* Linker:   link v6.00.8447
*
* changes from v05 to v06
*          -Fixed the Bug, which caused values of 0(zero) to fail. That Bug
*           was introduced in v04?
* changes from v04 to v05:
*          -the batch file, which is created on the fly changed from:
*           entry.com %1 >values to entry.com %1>values
*
* changes from v03 to v04:
*          -The candidate is now called through a batch file, which is created
*           on the fly, to simulate a real console (Dos-Box).
*           Note: the workaround, I described in the mailing list, is not longer
*                 necessary, DON'T USE THAT WORKAROUND WITH THIS VERSION!!!
*          -added a switch -r to force random value order, that was proposed
*           by Aphex
*          -the entries are now forced to redirect their output to a file,
*           I validate the output by examining the contents of this file.
*           Thanx to Ruud, who suggested this procedure
*          -added a sub-switch -ve to force an empty commandline, this switch
*           is equivalent to -v with values > 1000000
*          -the random value generator now creates values, which simulate
*           an empty commandline (s.a.)
*          -changed the procedure to measure time-outs, an extra Thread was
*           not longer necessary due to changes from v02 to v03
*
* changes from v02 to v03:
*          -The bug, which caused the test-suite to verify the clients result 
*           against an incorrect value, when the cursor was not in the last row, 
*           is now fixed.
*          -The test-suite honners now the 90 seconds time-limit, which is 
*           defined in the final rules, for each individual test run. You may 
*           still override this value with the switch /t<time>.
*
* changes from v01 to v02: 
*          -search for lookup-table (primes) in current directory
*          -create lookup-table if not present       
*          -added a switch (-i<lookup_table_file>) -> include lookuptable
*          -implemented an error count
*          -main returns now nerror as ExitCode
*          -added switch -q -> testit output goes to log.txt
*          -corrected some errors, which I thought were allready corrected,
*           must have switched the source files (I hope I did not miss any 
*           errors)
*
*******************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

const unsigned g_cmax_sieve = 15485863 + 1;
const unsigned max_nprime = 1000000;

#define SAVE_FREE(x){ if(x) {free(x), x=NULL;} }
#define CLOSEHANDLE(x) { if(x) {CloseHandle(x), x=NULL;} }
#define MAX_TIMES 10


unsigned  g_nTimes = 5;
unsigned  g_TimeOut = 90000;
unsigned* g_pValue = NULL;
unsigned  g_ValueCount = 0;
unsigned  g_pPrimes[MAX_TIMES]; // = NULL;
int       g_bQuiet = FALSE;
int       g_bRandOrder = FALSE;
FILE*     g_flog=NULL;         

char      g_szFile[256] = "entry.com";
char      g_szTable[256] = "primes";
char      g_szBatch[] = "_hc12tst.bat";
char      g_szTest[] = "values";

void usage()
{
  fprintf(stdout, "testit: [options] \n"
         "        -f<filename>  override default file to test, default=entry.com\n"         
         "        -h, -?        show this screen\n"
         "        -i<filename>  Optional path and filename for the lookuptable,\n"
         "                      if file is not found a new one will be created.\n"
         "                      default = primes\n"
         "        -n<num_runs>  create n test runs, n = [1,%d], default = 5\n\n"                  
         "        -q            use quiet mode, all output goes to log.txt\n"         
         "        -r            use random order of test values\n"
         "        -t<timeout>   allowed time in ms, default=90000\n"
         "        -v<testvalue> jam in a test value, default=5 random test values\n"
         "        -ve           force an empty commandline value\n\n"
         "example: testit -t6000 -fmyprog.com -v0 -v1 -v1000000 -n4 -i..\\other\\primes\n\n"
         "         Run myprog.com 4 times with the values: 0, 1, 1000000 and one \n"
         "         random value. Load lookup table  ..\\other\\primes .\n"
         "         Terminate test after 6000 ms (if it is still running).\n\n\n", MAX_TIMES
         );
}

BOOL ParseCmd(int argc, char* argv[])
{
  for(int i=1; i<argc; i++)
  {
    char* dum = argv[i];
    dum++;
    switch(*(dum))
    {
      case '?':
      case 'h': return false;
      case 'n': g_nTimes = atol(++dum);
                if(!g_nTimes)
                  return false;
                g_nTimes = (g_nTimes > MAX_TIMES) ? MAX_TIMES : g_nTimes;
                break;
      case 'i': strcpy(g_szTable, ++dum);
                break;
      case 'f': strcpy(g_szFile, ++dum);
                break;
      case 'q': g_bQuiet = true; break;
      case 'r': g_bRandOrder = true; break;
      case 't': g_TimeOut = atol(++dum);
                if(!g_TimeOut)
                  return false;
                break;
      case 'v': g_pValue = (unsigned*) realloc(g_pValue, ++g_ValueCount*sizeof(unsigned));
                dum++;
                g_pValue[g_ValueCount-1] = (*dum == 'e' ? 0xffffffff : atol(dum));               
                break;
                
      default: return false;
    }
  }
  return true;
}

int __cdecl qcompare(const void *elem1, const void *elem2 ) 
{
  return *((int*)elem1) - *((int*)elem2);
}

void GenRandValues(int randcount)
{
  if(randcount>0)
  {
    //initialize seed
    srand(GetTickCount());

    for(int i=0; i<randcount; i++)
    {
      //r = [0, max_nprime] or emty commandline if r > max_nprime

      unsigned r = (unsigned) (  (float)rand()/(float)RAND_MAX * (float)(max_nprime + max_nprime/20) );

      g_pValue = (unsigned*) realloc(g_pValue, ++g_ValueCount*sizeof(unsigned));
      g_pValue[g_ValueCount-1] = r;
    }
  }
  //sort values in increasing order, so that we can search the
  //nth-primes in one run
  qsort(g_pValue, g_ValueCount, sizeof(unsigned*), qcompare);
}

int CalcPrimes()
{
  unsigned c, i, j;
/*
  g_pPrimes = (unsigned*) malloc(g_nTimes);
  if(!g_pPrimes)
    return false;
*/
  //allocate in ram or in the swap file
  char* prime_array = (char*) VirtualAlloc(NULL, g_cmax_sieve, MEM_COMMIT, PAGE_READWRITE);
  if(!prime_array)
  {
    fprintf(g_flog, "Sorry, not enough memory, close some other progams\nor reserve a larger swap file!\n");
    return false;
  }
 
  //assume all numbers are primes
  memset(prime_array, 1, g_cmax_sieve);

  prime_array[0] = 0;
  prime_array[1] = 0;

  c = 1;
 
  while(c*c < g_cmax_sieve)
  {
    do
    {
      c++;
    }while(!prime_array[c]);

  
    i = c + c;
    while(i < g_cmax_sieve)
    {
      prime_array[i] = 0;
      i += c;
    }
  }
  
  for(j=0; j<g_nTimes; j++)
  {
    if(!g_pValue[j])
    {
      g_pPrimes[j] = 0;
      continue;
    }
    for(c=0, i=0; i != g_pValue[j]; c++)
    {
      if(prime_array[c])     
        i++;
    }
    g_pPrimes[j] = --c;
  }

  //create lookup table
  FILE* lookup = fopen(g_szTable, "wb");
  if(!lookup)
  {
    fprintf(g_flog, "warning: could not create lookup table, disk full?\n");
  }
  else
  {    
    for(c=0; c < g_cmax_sieve; c++)
    {
        if(prime_array[c])   
        {
          fwrite(&c, sizeof(unsigned), 1, lookup);
        }
    }
    fclose(lookup);
  }


  //don't need it any more
  VirtualFree(prime_array, 0, MEM_RELEASE);

  

  return true;
}

void CleanUp()
{
  SAVE_FREE(g_pValue)
  //SAVE_FREE(g_pPrimes); //changed to static
}


int main(int argc, char* argv[])
{
  const int buf_size = 256;
  unsigned starttick, endtick, tmptick;  
  FILE* lookup=NULL, *ftmp=NULL;
  int randcount;
  int nerror = 0;
  
  char buf[buf_size];


  if(!ParseCmd(argc, argv))
  {
    usage();
    return 0;
  }

  if(g_bQuiet)
  {
    g_flog = fopen("log.txt", "wt");
  }
  else
  {
    g_flog = stdout;
  }

  ftmp = fopen(g_szFile, "r");
  if(!ftmp)
  {
    usage();
    fprintf(g_flog, "can't find %s\n", g_szFile);    
    return 0;
  }
  fclose(ftmp);

  ftmp = fopen(g_szBatch, "wt");
  if(!ftmp)
  {
    fprintf(g_flog, "can't create batch file, disk full?\n");
    return 0;
  }

  fprintf(ftmp, "@echo off\n%s %%1>%s\n", g_szFile, g_szTest);
  fclose(ftmp);


  if(g_ValueCount >= g_nTimes)
  {
    g_nTimes = g_ValueCount;
    randcount = 0;
  }
  else
  {
    randcount = g_nTimes - g_ValueCount;
  }

  
  GenRandValues(randcount);

  fprintf(g_flog, "initialize my check values, that may take a moment...\n");
  lookup = fopen(g_szTable, "rb");
  if(!lookup)
  {
    fprintf(g_flog, "no lookuptable found, create a new one\n");
    if(!CalcPrimes())
    {
      fprintf(g_flog, "allocation error\n");
      return 0;
    }
  }
  else
  {
    for(unsigned i=0; i<g_nTimes; i++)
    {
      if((g_pValue[i] <= max_nprime) && (g_pValue[i] > 0))
      {
        fseek(lookup, sizeof(unsigned)*(g_pValue[i]-1), SEEK_SET);
        fread(&g_pPrimes[i], sizeof(unsigned), 1, lookup);
      }
      else
      {
        g_pPrimes[i] = 0;
      }
    }
  }

  if(lookup)
    fclose(lookup);

  if(g_bRandOrder)
  {
    //initialize seed
    srand(GetTickCount());
    //create a random order
    for(unsigned i=0; i<g_nTimes-1; i++)
    {      
      unsigned r =   rand()%(g_nTimes-1-i); 
      unsigned j = g_pValue[r];
      g_pValue[r] = g_pValue[g_nTimes-1-i];
      g_pValue[g_nTimes-1-i] = j;

      j = g_pPrimes[r];
      g_pPrimes[r] = g_pPrimes[g_nTimes-1-i];
      g_pPrimes[g_nTimes-1-i] = j;
    }    
  }
  
  starttick = GetTickCount();
  for(unsigned i=0; i<g_nTimes; i++)
  {
    PROCESS_INFORMATION PInfo;
    STARTUPINFO si;
    memset(&si, 0, sizeof(si));
    si.cb = sizeof(si);
    si.dwFlags = STARTF_USESHOWWINDOW | STARTF_FORCEONFEEDBACK;
    si.wShowWindow = SW_SHOWNORMAL;
    
    
    //create commandline for child process
    if(g_pValue[i] > max_nprime)
    {
      //create an empty commandline
      sprintf(buf, "%s", g_szBatch);
    }
    else
    {
      sprintf(buf, "%s %u", g_szBatch, g_pValue[i]);
    }

        
    tmptick = GetTickCount();
    //create child process
    BOOL ret = CreateProcess(
    						  NULL,   // pointer to name of executable module
                          // Note: don't use that here because the name of the executeable module 
                          //       is given with the commandline, this is necessary in order to 
                          //       create 16 - Bit child processes on Windows NT.
    						  buf,    // pointer to command line string
    						  NULL,	  // pointer to process security attributes
    						  NULL,	  // pointer to thread security attributes
    						  FALSE,	// handle inheritance flag 
    						  CREATE_NEW_PROCESS_GROUP,	    // creation flags, need that to fire a CTRL-C
    						  NULL,	  // pointer to new environment block 
    						  NULL,	  // pointer to current directory name
    						  &si,	  // pointer to STARTUPINFO
    						  &PInfo 	// pointer to PROCESS_INFORMATION
                  );


    if(!ret)
    {
      usage();
      fprintf(g_flog, "can't create process: %s", buf);
      return ret;
    }
    

    //wait until child process terminates or timeout is signaled
    DWORD ev = WaitForSingleObject(PInfo.hProcess, g_TimeOut);
    endtick = GetTickCount();
    if(ev == WAIT_TIMEOUT)
    {
      //We receaved a timeout, try to kill client process;
      //unfortunately that seems only to work with 32 bit
      //clients.
      fprintf(g_flog, "\ntimeout :-(((\t%s %u"
                      "\nwaiting for client...\n", g_szFile, g_pValue[i]);  
      fflush(g_flog);
      nerror++;

      //following code works only if a control  handler is installed,
      //allthough 16 bit code runs in an virtual console no default
      //handler seems to be installed. :-(((
      GenerateConsoleCtrlEvent(CTRL_C_EVENT, PInfo.dwProcessId);

/*    
      //This code seems not to work either, any help is appreciated.
      HANDLE hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, PInfo.dwProcessId);
      if(hProcess)
      {
        TerminateProcess(hProcess, 0);
        CloseHandle(hProcess);
      }
*/
      CloseHandle(PInfo.hProcess);
      break;
    }
    else if(ev != WAIT_OBJECT_0)
    {
      fprintf(g_flog, "\nunrecognized error\n");
      CloseHandle(PInfo.hProcess);
      break;
    }    

    CloseHandle(PInfo.hProcess);
    
    ftmp = fopen(g_szTest, "rb");
    
    if(!ftmp)
    {
      fprintf(g_flog, "\ncan't open test file\n");
      break;
    }
    else
    {
      char tbuf[32];
      char* pbuf = buf;
      int count = 0;

      while(fread(pbuf, sizeof(char), 1, ftmp))
      {
        pbuf++;
        //avoid buffer overflow
        if(++count > 254)
          break;
      }
      *pbuf = 0;
      fclose(ftmp);

      sprintf(tbuf, "%010u\r\n", g_pPrimes[i]);

      

      if(!strcmp(buf, tbuf))
      {
        if(g_pValue[i] > max_nprime)
        {
          fprintf(g_flog, "%s : solved after %u ms\n", g_szFile, endtick - tmptick);
        }
        else
        {
          fprintf(g_flog, "%s %u: solved after %u ms\n", g_szFile, g_pValue[i], endtick - tmptick);
        }
      }
      else
      {
        nerror++;
        if(g_pValue[i] > max_nprime)
        {
          fprintf(g_flog, "\n%s : error!!!\n"
                 "your output ->%s\n"
                 "should be   ->%s\n", g_szFile, buf, tbuf);
        }
        else
        {
          fprintf(g_flog, "\n%s %u: error!!!\n"
                 "your output ->%s\n"
                 "should be   ->%s\n", g_szFile, g_pValue[i], buf, tbuf);
        }
      }
    }
  }
  
  endtick = GetTickCount();

  fprintf(g_flog, "\nelapsed time %d ms, detected %d errors\n", endtick - starttick, nerror);
  if(g_flog != stdout)
    fclose(g_flog);
  
  CleanUp();
	return nerror;
}
