; Mode 13h Sokoban -- example program for compo #13, then voted out...
; I optimized this to be less than 300 bytes.  Probably you can make
; it in 256 bytes (I did save forty bytes in my textmode entry during
; the compo) but it's hard to find the time to optimize one program
; (my entry), imagine two...
;
; -----------------------------------------------------------------------
; written by Bonz
; -----------------------------------------------------------------------

%undef NOVIDEO
%undef DONT_ASSUME_DAC_ZERO

		org 100h
		mov al,[bx+5dh]		; load command line
		cmp al,20h
		jnz gameloop
		mov al,41h

gameloop:
		push ax			; push the file name
		mov dx, tiles		; load the tiles (SOKO)
		call read
	
%ifndef NOVIDEO
		mov ax,13h		; enter 320x200x256 mode
		int 10h
%ifdef DONT_ASSUME_DAC_ZERO
		mov al,0
		mov dx,3c8h		; output it to DAC address register
		out dx,al
		inc dx
%else
		mov dx,3c9h
%endif
		mov ch,3		; output 768 colors to DAC data reg
		rep outsb
		xchg bx,ax
%else
		xor bx,bx		; column in BX
%endif		

		pop ax			; get back the file name
		push ax
		xchg ax,dx		; character in DX
		mov al,0f9h		; color (light red) in AL
		call show

		mov dx,sp		; read the file at 1d00h
		call read

		mov di,si		; convert input file: remove CR/LFs and
xlatloop:				; map ASCII to the tiles' high bytes
		lodsb
		cmp al,20h		; remove CR/LFs
		jb backtoloop
		cmp al,26h		; is it the player?
		jnz store
		push di			; yes, save player position
		mov al,20h		; and turn it to a space
store:
		stosb
backtoloop:
		loop xlatloop
		
		xor bp,bp		; zero move counter
		pop si			; and get player position back

; when we get here from above we have
;      CX = 0      (from the translating loop)
;      DX = 1d00h  (from the call to `read')
;
; instead, when we get here "from below" CX is < 240 (from the REPNE SCASB)
; and DX has not been touched.  So the invariants in the main loop are
;      CH = 0
;      DX = 1d00h  (from the call to `read', below)
;

mainloop:
		mov ax, 21h		; Zero out AH, set AL as needed later
		mov bx, dx		; start of the game table
		xor di, di

		push word [si]		; save where the player is
		pusha			; and all the registers
		mov byte [si], 26h	; put the correct sprite there

		push word (0a000h + 20 * 8)	; set up ES:DI
		pop es
row:
		mov dx,20		; Draw 20 tiles per row
tile:
		mov si,[bx]		; Get a tile
		shl si,8		; Put the ASCII code in the high byte
		inc bx			; Update pointer
		mov al,16		; Draw 16 lines
line:
		mov cl,16		; each of 16 pixels
		rep movsb
		add di,304		; If we get past the end of the segment
		jc tiles_drawn		; we're done
		dec ax			; else draw next line
		jnz line

		sub di,320*16-16	; draw the next tile on the same row
		dec dx			; of course if this was not the last
		jnz tile
		add di,320*15		; Draw next row
		jmp short row

end:
		mov sp, 0fffch		;clear undo stack

		mov ax, 7		;finished, beep speaker
		int 29h
		int 16h			;admire your work (ah = 0)
		pop ax			;get filename back
		inc ax			;form next file name for next level
		jmp short gameloop	;loop for all levels

undo:		cbw			;ax = 8
		add ax, sp		;carry if sp > 0fff8h
		jc  nomove		;first undo sets it to fff0h
		dec bp			;uncount move
		pop bx			;restore state for previous move
		pop di
		pop si
		pop word [bx+di]	;restore sprites before previous
		pop word [di]		;move
		pop word [si]
nomove:
		jmp short mainloop

tiles_drawn:
		call move_ctr		; draw move counter

		popa			;restore the registers
		pop word [si]		;restore the sprite under the player

; When we get here we have
;    DI = 0
;    AH = 0    
;    BX = 1d00h
;    AL = 21h
; which were set before the PUSHA; in addition
;    CH = 0
;    DX = 1d00h
; which are invariants across the main loop.
; The XCHG is here to zero out BH.

		xchg di, bx		;get back starting address
		mov cl, 240		;Game table's size
		repne scasb		;AL already set above
		jcxz end		;if not found, the level ends
		
		int 16h			;get command from keyboard (ah = 0)
		cmp al,8		;backspace?
		jz undo			;if so, undo
		ja quit			;escape quits

					;L  R  U   D
		mov bl,20		;75 77 72  80
		shr ah,1		;37 38 36  40
		jnc updown		;-1 +1 -20 +20 (in the end)
		mov bl,1
updown:
		cmp ah,38		; ah < 38?
		jnc rightdown		; make it negative
		neg bx
rightdown:
		lea di,[bx+si]

;si = current man location
;di = possible new man location
;bx = delta to new man location
;save current state for undo command

		push word [si]		;save sprite under man
		push word [di]		;save sprite under new man position
		push word [bx+di]	;save sprite under new block position
		push si			;save location of man
		push di			;save new location of man
		push bx			;save move direction
		inc bp			;count move

		cmp byte [di],22h	;moving to a wall?
		jz nomove		;if so, nothing to do
		jb movman		;moving to a block? no, only update SI
		cmp byte [bx+di],22h	;is the new block location free?
		jae nomove		;if not, nothing to do
		add byte [bx+di],4	;floor -> block, dock -> docked block
		sbb byte [di],4		;block -> floor, docked block -> dock
movman:		mov si,di		;update player position
		jmp short nomove	;next move


; read file pointed to by dx at 1d00h
; on exit SI = 1d00h, CX = byte count

read:
		mov ax,3d00h
		int 21h
		jnc load
quit:
		mov ax,3		;back to 80x25 text mode
		int 10h
		int 20h			;and exit
load:
		xchg ax,bx		;handle in BX
		mov ah,3fh		;read from file
		mov dx,1d00h		;offset
		mov cx,dx		;count (only 2560 bytes needed)
		mov si,dx		;save it to return it
		int 21h
		
		xchg ax,cx		;byte count
		mov ah,3eh		;close file
		int 21h			;handle already in BX
		ret

move_ctr:
		mov ax,bp		;move counter in AX
		mov bl,39
		mov cx,10		;radix in CX
divide:
		cwd			;get a digit in DX
		div cx
		pusha
		or dl,'0'		;make it ASCII
		mov al,0fbh		;color (yellow)
		call show		;column in BX
		popa
		dec bx			;next column please
		or ax,ax		;another digit?
		jnz divide		;yes, loop
		xchg dx, ax		;no, print a nul

; BL = column
; AL = color
; DL = character
;
; Wreaks havoc on all the registers :-)

show:
		push dx			;Save character on the stack
		push ss			;Make ES:BP point to it
		pop es
		mov bp,sp
		xchg ax,bx		;AL = column, BL = color
		cbw			;AH = 0 (row), AL = column
		xchg ax,dx		;DH = row, AL = column
		mov cx,1		;CX = char count
		mov ax,1300h		;AX = print string function
		int 10h			;Through BIOS
		pop dx			;Balance stack
		ret


tiles:		db 'SOKO'		; file name for the tiles
		db 0
