; SNIPER
; Forever Young Software
; http://www.cybertrails.com/~fys/index.htm
; fys@cybertrails.com
;
; ENTRY.COM (243 bytes)
; NBASM 00.24.xx   (http://www.cybertrails.com/~fys/newbasic.htm)
; 22 November 2000
;
; ************************
;  I used my own assembler, NBASM, to assemble this file.  It produces
;   code very similar to MASM and TASM.  If you object to me using
;   my own assembler, please let me know and I will continue using
;   MASM in the future.
; ************************
;
; see end of source for comments...
;
; ************************
;     thanks goes to Boreal for his help (A BIG THANKS)
;     thanks goes to claw for his help
; ************************
;
.model tiny
.code
.186
           org  100h

; assume ax=0, bx=0, si=0100h, di=FFFEh, cx = 00FFh

start:     mov  al,'A'                  ; default input file name (puzzle level)
           cmp  byte [si-80h],2         ; is there a single-char argument on the
           jne  short st10              ; command line?  Jump if not--use 'A'
           mov  al,[0082h]              ; else get file name from command line
st10:      mov  [bx],ax                 ; set up ASCIIZ file name at location 0
                                        ; (ah=0, bx=0)
                                        ; of image on screen (cmp ax, es:[di++])


;;;;; works by hand, not with the tester (is on byte less)
;start:     mov  byte [bx],'A'           ; assume 'A'
;           shr  si,1                    ; make si = 80h
;           lodsb                        ; al = size of command line
;           xchg cx,ax                   ; mov length in to cx (ah = 0)
;           lodsw                        ; ah=char, al=space (if a char there)
;           jcxz short ($+4)
;           mov  [bx],ah

           push 0B800h                  ; point to image on text screen
           pop  es

sb00:      mov  ax,0001h                ; set 40x25 text mode
           int  10h                     ; (also clears counter on screen)
           ; ax = 0001h
           ; bx = 000xh  ; first puzzle = 0000h, rest = 000Ah
           ; cx = xxxxh  ; first puzzle = 000xh, rest = counter value(<4001)
           ; dx = xxxxh  ; first puzzle = cs,    rest = 0Exxh

           mov  ax,3D00h                ; DOS function to open file
           cwd                          ; dx = 0; point to file name
           int  21h                     ; ax = file handle
           jc   short exit              ; *exit if file not found*
           xchg bx,ax                   ; save file handle in bx (mov bx, ax)

           ; ax = 000xh  ; first puzzle = 0000h, rest = 000Ah
           ; bx = 00xxh = handle
           ; dx = 0000h
           ; di = FFFEh

           mov  di,(240+80)     ;0140h  ; set up location for grid
lf10:      add  di,(40-20*2/2)  ;  14h  ; 
lf20:      push ax                      ; form location on stack for input byte
           mov  ah,3Fh
           mov  dx,sp                   ; sp = FFFCh
           mov  cx,1                    ; read one byte from file (bx=handle)
           int  21h
           xchg cx,ax                   ; (at eof?) (make cx = 0 for below)
           pop  ax                      ; get input byte
           jcxz short lf40              ; jump if at end of file (EOF)

           cmp  al,'&' ; 38d (26h)      ; record location of man symbol in si
           jne  short lf30
           mov  si,di
lf30:      sub  al,20h                  ; set up table index
           js   short lf10              ; jump if CR or LF (or 1Ah)
           cbw                          ; ax = extend(al)
           xchg bp,ax                   ; (mov bp, ax)
           add  bp,bp                   ; double to index words
           mov  ax,[bp+ObjTbl]          ; get more colorful character from table
           stosw                        ; display character; es:[di++] = ax
           jmp  short lf20              ; loop until EOF
lf40:

           ; ax = 0001h
           ; bx = 000xh = handle
           ; cx = 0000h                 ; from jcxz above
           ; dx = FFFCh                 ; from sp above

           mov  ah,02                   ; turn off flashing cursor
           int  10h                     ; dh = 26d (1Ah) or above

           mov  ah,3Eh                  ; close file handle
           int  21h
           xor  sp,sp                   ; initialize stack (for undoing moves)

           pop  ax                      ; get current file name (level)
           inc  ax                      ;  inc for next puzzle
           push ax                      ; save it back
           dec  ax                      ;  dec for display below
          
           push es                      ; ds = text screen segment
           pop  ds
          
           mov  ah,0Ch                  ; display file name (level) (LRed)
           xor  di,di                   ; al = filename
; enter loop by displaying move counter
           jmp  short (sb80-1)          ; (jump to STOSW to display file name)
                                        
;Exit program
exit:      mov  ax,0003h                ; restore standard 80x25 text mode
           int  10h
           int  20h                     ; exit back to DOS

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Main loop
;assume ah=0
sb10:      int  16h                     ; wait for and get keystroke
           shr  ax,9                    ; put ah in al (/2), clearing ah
           jz   short exit
           sub  al,24h                  
           js   short undo
           xchg bp,ax                   ;   48h            -80
           mov  al,[bp+MovTable]        ;   4Bh            -2
           cbw                          ;   4Dh            +2
           push ax                      ;   50h            +80
           xchg bx,ax
           add  bx,si
           pop  di
           add  di,bx

;Save current state for undo command (Backspace key)
           mov  dx,[si]                 ; save man symbol and its background
           mov  bp,[bx]                 ; save contents at new man location
           mov  ax,[di]                 ; save contents where box might go
           pusha                        ; save locations of man, new man, and box
                                        ; also save move counter
           inc  cx                      ; bump move counter
          
           mov  bp,0F000h               ; set up mask used below

           mov  al,20h
           cmp  [bx],al                 ; S = Screen(Temp)
           je   short sb70              ; if S = floor or dock then go move man

           cmp  byte [bx],0FEh          ; else if S = box then
           jne  short sb80              ; (jump if not)
          
           cmp  [di],al                 ; S = Screen(BoxLoc)
           jne  short sb80              ; if S = floor or dock then

           and  [di],bp                 ; move box
           or   word [di],0EFEh         ;
sb70:                                   ; assume al=20h
           mov  [si],al                 ; move man--blank out old location
           and  [bx],bp                 ; store man at new location saving the
           or   word [bx],0902h         ; current backgnd color in high nibble
          
           mov  si,bx                   ; ManLoc = Temp
           jmp  short sb80

;Undo move
undo:      jcxz short sb80              ; skip if no move to undo
           popa                         ; restore saved state, incl. move counter
           mov  [si],dx                 ; restore man and his background color
           mov  [bx],bp                 ; restore location where man moved to
           stosw                        ; restore location where box moved to
sb80:      ; \--- stosw must be just above sb80

;Display move counter
           std
           mov  ax,cx                   ; get move counter
           mov  di,78                   ; set cursor to least significant digit
           mov  bx,10                   ; set up divisor
sb85:      cwd                          ; dx = 0  ( ax <= 4000 )
           div  bx      ;ax = dx:ax / 10;  dx = remainder
           xchg dx,ax
           add  ax,(0E00h+'0')          ; Screen(di) = Rem(0) + '0' + Yellow<<8
           stosw
           xchg dx,ax
           test ax,ax                   ; loop until all digits displayed
           jnz  short sb85
           stosb                        ; blank possible digit when undoing moves
           cld                          ; byte es:[di++] = 0

           ; ax = 0000h
           ; bx = 000Ah
           ; cx = xxxxh = counter value
           ; dx = 0E3xh
           ; di = 004Dh  ;Need it to point a little passed puzzle on screen

; Detect if level is finished
           mov  di,(80*20-1) ; 1599d ; 063Fh
sb90:      test byte [di],0C6h          ; if 39h (man on dock) or 
           jz   short sb10              ;  30h (empty dock) then continue
           dec  di                      ; else, all docks full, end
           dec  di
           jns  short sb90

           ; di = 0FFFFh
          
           mov  al,07h                  ; no box on floor, thus won, ring bell
           int  29h                     ; and set ah=0 (DOS 3.3 bug destroys bx)

; assume ah=0 (from print counter above)
           int  16h                     ; wait for keystroke

           push cs                      ; restore ds
           pop  ds
           jmp  sb00                    ; loop for all game files

;Object table: Converts characters in input file to more colorful characters
ObjTbl     dw  7020h                    ; sp floor        (White)
           dw  3020h                    ; !  loading dock (Cyan + 20h)
           dw  0720h                    ; "  Background
           dw  47B0h                    ; #  wall  (red + white + 0B0h)
           dw  7EFEh                    ; $  box on floor (White+Box)
           dw  3EFEh                    ; &  box on loading dock (Cyan+Box)
           dw  7902h                    ; %  man on floor (White+Man)
            ;  || \- character (ascii)
            ;  | \-- foreground color
            ;   \--- background color

MovTable   db  -80,-2,2,0,80

.end


Comments:
  I didn't have near the time to work on this than I wanted to.
  However, I do want to thank Boreal for the initial start and
  to claw for the encourgement that he gave.

  See you in HC14, I hope....


