;;
;;  Stefan's Entry for Hugi Size Coding Competition #13 -- Soko Ban
;;
;;  Version 1.
;;
;;  Valid keys are arrows, ESC and backspace. Invalid keys are handled
;;  like ESC or arrows. Undo information is 1 to 7 words per move, thus
;;  we can undo the required 4000 moves using at most 56k stack.
;;
;;  Yes, I have skimmed the example program, so some ideas may have stuck.
;;
;;  Assumes: cld, int 10/0E and int 16/00 don't change flags and/or
;;  registers they shouldn't
;;
;;  Assemble with `tasm /m', `tlink /t'
;;  -> 248 bytes
;;
;;  Can anyone make a (solvable) level with more than 120 empty docks?
;;
;;  Have fun,
;;    Stefan
;;
;;
;;  16/Nov/2k	310  (straightforward implementation)
;;		286,271
;;  17/Nov/2k	262  (DisplayLevel is no longer a subroutine)
;;              259  (sp=0)
;;  21/Nov/2k	254  (solved-check in DisplayLevel)
;;		252-249
;;  04/Dec/2k	248
;;                         _
;;                        ( )__ _____
;;  Little blue man       / ___>     |
;;  moving boxes around  /  |  |     |
;;                      /_/_|  |_____|
;;


		MODEL	TINY
		CODESEG
		ORG	100h
		SMART
		P386

LINELEN = 20			; length of a line in characters
LINEMULT = LINELEN + 2		; length of a line in bytes (incl CRLF)
NUMLINES = 17			; number of lines in a level

SCREEN_ORG = 2*(10 + 40*4)
SCREEN_END = SCREEN_ORG + NUMLINES*80

FLOOR		= 20h
DOCK		= 21h
BACKGROUND	= 22h
WALL		= 23h
BOX_ON_FLOOR	= 24h
BOX_ON_DOCK	= 25h
MAN_ON_FLOOR	= 26h
MAN_ON_DOCK	= 27h

; Returns: si = man position, dl = # empty docks
; Used postconditions: si = man position, bh = 0, dh = 0, bp = 0
; (this was a subroutine initially)
DisplayLevel	MACRO
		mov	si, offset Counter
		push	0B800h
		pop	es

		;... display move counter ...
		mov	di, 39*2
		lodsw
		std

  DispCounter:	cwd
		mov	cx, 10
		idiv	cx
		xchg	dx, ax
		add	ax, 0E30h
		stosw
		xchg	dx, ax
		or	ax, ax
		jnz	DispCounter
		stosw			; clear one digit in front of counter
		cld
		cwd

		;... display level name ...
		xchg	ax, di
		mov	al, FileName
		mov	ah, 12
		stosw

		;... display level ...
		mov	di, 2*(10 + 40*4)	; screen position
		mov	bp, NUMLINES
  DispLine:	mov	cl, LINELEN		; ch=0 from above 
  DispChar:	push	si
		lodsb
		cbw
		xchg	bx, ax
		add	bx, bx
		mov	ax, word ptr CharTab[bx-40h]
		stosw
		cmp	ah, 39h		; empty docks
		jne	NotEmpty
		inc	dx
  NotEmpty:	cmp	al, 2		; man
		jz	ManFound
		pop	ax
  ManFound:
		loop	DispChar
		lodsw
		add	di, 2*(40 - LINELEN)
		;cmp	di, SCREEN_END
		;jb	DispLine
		dec	bp
		jnz	DispLine
		pop	si
		push	ds
		pop	es
ENDM

Start:
		mov	al, ds:[5Dh]	; Filename in first FCB
		cmp	al, 32
		jz	NoFilename
		mov	FileName, al
  NoFilename:

	;=== Level Loop ===
  NextLevel:
		inc	word ptr di[FileName-Counter]
					; somewhere in free space first time,
					; [FileName] then
		xor	sp, sp		; reset stack (why FFFEh? ;-)))
		xor	ax, ax		; video mode 40x25
		int	10h
		mov	ah, 1		; cursor off
		mov	ch, 20h		; bits 6,5 = 01 -> invisible
		int	10h
		mov	dx, offset FileName ; load level
		mov	ax, 3D00h
		int	21h
		jc	Ende

  OpenOk:	xchg	ax, bx		; file handle
		; mov	cx, NUMLINES * LINEMULT ; not needed, cx=20xxh from above
		;mov	dx, offset Level
		mov	dl, LOW offset Level  ; possible because entry <256 bytes
		mov	ah, 3Fh
		int	21h
		mov	ah, 3Eh
		int	21h
		;... Level is now loaded, start the game ...
  ZeroCounter:	mov	[Counter], sp	; sp=0 when we're here
  PlayLoop:	DisplayLevel		; returns si = man position, dx = #empty docks

		or	dx, dx
		mov	ax, 0E07h
		jnz	NotSolved
		int	10h		; *meep*

		;--- input loop ---
  NotSolved:	xchg	ax, dx		; dh is zero because no level can have
  		int	16h		; more than 255 empty docks (maximum
					; is <135, I think)
		mov	di, offset Counter
		jz	NextLevel

		cmp	al, 8		; > 8 -- must be ESC (or invalid key)
		jna	NotEsc
  Ende:		mov	ax, 3
		int 	10h
		int	20h	
  NotEsc:
		jnz	NoBackspace
		dec	word ptr [di]	; Undo possible?
		js	ZeroCounter
		;... undo ...
  UndoLoop:	pop	si
		or	si, si
		jz	BadMove
		pop	word ptr [si]
		jmp	UndoLoop

  NoBackspace:
		mov	bl, 1		; bh is 0 from DisplayLevel
		test	ah, bl		; nonzero for left/right
		jnz	Okay1
		mov	bl, LINEMULT
  Okay1:	test	ah, 4Ch		; 48 for up/left
		jpo	Okay2		; 4C/40 for right/down
		neg	bx
  Okay2:
		; bx = movement offset
		; si = man position
		inc	word ptr [di]	; counter
		lea	di, [bx+si]
		; di = target position
		mov	al, [di]
		push	bp		; bp=0 from DisplayLevel, marks end
					; of undo information for this turn
		test	al, 6
		jz	MovingToEmptySpace
		test	al, 4
		jz	BadMove
		;... box in front of man ...
		add	bx, di
		test	byte ptr [bx], 6
		jnz	BadMove
		;... move the box ...
		push	word ptr [bx]		; bx = new box position
		push	bx
		or	byte ptr [bx], 4
		;... move man onto empty space ...
  MovingToEmptySpace:
		or	al, 6
		push	word ptr [di]		; di = box or empty space
		push	di
		stosb
		push	word ptr [si]		; si = man
		push	si
		and	byte ptr [si], NOT 6
  BadMove:	jmp	PlayLoop

CharTab = $-1	;; first character = anything, color 7
		db	77h
		dw	3920h
FileName	db	'A', 0
		dw	47B0h, 7EFEh, 3EFEh, 7902h, 3902h
Counter		dw	?
Level		db	NUMLINES*LINEMULT dup (?)

		END	Start
