; Entry for Hugi size coding compo13 - Soko Ban game
; By Viking
;
; Compiling : nasm entry.asm -o entry.com
; Size      : 239 bytes

[ORG 0x100]
[BITS 16]

%define LRed            0x0C
%define Yellow          0x0E

;Objects:
%define ManSym          0x0902
%define BoxSym          0x0EFE
%define WallSym         0x47B0
%define FloorSym        0x7020
%define DockSym         0x3020
%define BackGround      0x0720
%define Buffer          0x01EF

[SECTION .text]

        mov     bl, 0x80
        db      0xD7                    ; Is starting level specified on
        cmp     al, 0x02                ; commandlien.
        jne     NoName                  ; Jump if not.
        db      0xD7
        mov     byte [FileName], al

NoName:
        std                             ; Set Direction Flag
        push    word 0xB800             ; Initialize es
        pop     es

GameLoop:
        mov     ax, 0x3D00              ; Open the file
        mov     dx, FileName            ;
        int     0x21                    ;
        jc      AllDone
        xchg    ax, bx                  ; Put file handle to bx

        mov     ah, 0x3F                ; Fill buffer with level file
        mov     cx, 374                 ;
        mov     dl, Buffer              ;
        int     0x21                    ;

        mov     ah, 0x3E                ; Close the file
        int     0x21                    ;

        xor     ax, ax                  ; Switch to 40x25 mode and
        int     0x10                    ; turn off cursor
        xchg    ax, dx                  ; ah = 1
        mov     ch, 0x20                ;
        int     0x10                    ;

        mov     al, byte [FileName]     ; Show level name on the
        mov     ah, LRed                ; upper left corner.
        xor     di, di                  ;
        stosw

        mov     sp, di                  ; Set stack to 0xFFFE

        xor     cx, cx                  ; Zero move counter

Undo:
        jcxz    DrawScreen              ; Are we on starting position or not.
        dec     cx                      ; If not then undo move
        pop     si                      ;
        pop     bx                      ;
        pop     di                      ;
        pop     word [bx+si]            ;
        pop     word [si]               ;
        pop     word [di]               ;
        jmp     SHORT DrawScreen        ; And after that update screen


AllDone:
        mov     ax, 0x03                ; Set 80x25 mode
        int     0x10                    ;
        int     0x20                    ; and quit

SymbolTable:
        db      0x70
        dw      DockSym
        dw      BackGround
        dw      WallSym
        dw      FloorSym-0x20+BoxSym
        dw      DockSym-0x20+BoxSym
        dw      FloorSym-0x20+ManSym
        dw      DockSym-0x20+ManSym

KeyTable:
        db      -22                     ; up
        db      -1                      ; left
        db      1                       ; right

MainLoop:

        int     0x16                    ; 0x16 = 22 = down

        pop     cx                      ; Restore move counter

        aas
        jc      AllDone                 ; Order of thease 2 jumps is very
        jnp     Undo                    ; important. If swapped then esc
                                        ; will do same thing as backspace.

        shr     ax, 9                   ; ah divided by 2 and moved to al.
        mov     bl, KeyTable-36         ; Doesn't give optional vary between
                                        ; scan codes but relocating KeyTable
                                        ; fixes that.
        db      0xD7                    ; XLAT

        cbw
        xchg    ax, bx
        lea     si, [bx+di]

        push    word [di]               ; Save current state
        push    word [si]               ;
        push    word [bx+si]            ;
        push    di                      ;
        push    bx                      ;
        push    si                      ;
        inc     cx                      ;

        mov     ax, 0x0604
        cmp     byte [si], 0x23         ; Is there wall or the box on the
        je      DrawScreen              ; way.
        jb      MoveMan

        cmp     byte [bx+si], 0x23      ; Is there wall on the boxs way.
        jae     DrawScreen              ;

        add     byte [bx+si], al        ; Move the box
        sub     byte [si], al           ; and blank it's old position

MoveMan:
        add     byte [si], ah           ; Move the man
        sub     byte [di], ah           ; and blank it's old position

DrawScreen:
        push    cx                      ; Save move counter
        xchg    ax, cx
        mov     di, 0x4E
        mov     bx, 10

ShowMoveCounterLoop:
        cwd
        idiv    bx
        xchg    ax, dx
        or      ax, Yellow*0x100+0x30
        stosw
        xchg    ax, dx
        test    ax, ax
        jnz     ShowMoveCounterLoop
        stosw

        mov     di, (21*40+9)*2         ; Set screens starting offset
        mov     si, Buffer+373          ; Set buffers starting offset
        mov     cx, 374                 ; Set counter for the loop
        push    cx                      ; and save it for the later use

UpdateScreenLoop:
        lodsb                           ; Get level char
        aaa                             ; Is it CR or LF
        jnc     Draw                    ; If not then goto Draw
        sub     di, byte 20             ; If it's then goto next line on the
        loop    UpdateScreenLoop        ; screen

Draw:
        cmp     al, 0x06                ; Is it man on the docs or on the floor
        jb      NotManSym               ; Jump if not
        push    si                      ; Save current mans position

NotManSym:
        shl     al, 1                   ;
        mov     bx, SymbolTable-1       ;
        add     bl, al                  ;
        mov     ax, word [bx]           ; Get the "drawing" block from the
        stosw                           ; table and display it
        loop    UpdateScreenLoop

        pop     di                      ;
        inc     di                      ; di = mans current position
        pop     cx                      ; Take same counter in use again
        add     si, cx                  ; Set buffers starting offset
                                        ; for CheckLoop

CheckLoop:
        lodsb

        aam     1                       ; This comparasion is made with help
        aad     53                      ; of "The hidden power of BCD
        jnp     MainLoop                ; instructions" article on Hugi 17.
                                        ; So thanks goes to st0ne from this
                                        ; great article what he did.

        loop    CheckLoop

        lahf                            ; ah = 6
        mov     dl, 7                   ;
        int     0x21                    ; Beep

        xchg    ax, cx                  ; Zero ah
        int     0x16                    ; Wait for key

        dec     si
        inc     byte [si]               ; Next level file
        jmp     GameLoop

FileName:
        db      'A'
        db      0x00
