	page	240, 132
;TESTER.ASM	30-NOV-00
;Test suite for Hugi Compo #13 -- The Soko-Ban Game
; by Boreal
;This borrowed code written by Ruud, TAD & possibly others that was
; used in Compo #10. (Thanx guys, I learned a lot!)
;
;REVISIONS:
;31-OCT-00, Released.
;05-NOV-00, Increase undo 'stack' size to allow for 4000 moves.
; Verify cursor position (=0,0) on final screen. Error message for
; ENTRY.COM not found.
;06-NOV-00, Clear direction flag in Int16Hook (It might be set by entry.com).
;09-NOV-00, Allow blank character cells (floor, background, dock) to be any
; character when the background & foreground colors are the same.
;30-NOV-00, Allow entry to use stdin. <Aphex/Boreal>

;Assemble with:
; tasm tester
; tlink /t tester

	.386
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h
Start:
;<Aphex>
;Open a handle for input file
	mov 	si, 80h
	cmp 	byte ptr [si], 0
	je	err40			; if no keys file then exit
	mov	di, si
	mov	al, 0Dh
	mov 	cx, 20			; long enough for a file name
	repnz	scasb
	mov	byte ptr [di - 1], 0	; replace 0D with 00
	mov	dx, 82h
	mov	ax, 3D00h		; open file from cmd line
	int	21h
	jc	err40			; if error opening file then exit
	mov	IHandle, ax		; store handle (will be input handle)
	mov	di, 80h			; clear command line ;) for child
	mov	ax, 0D00h
	stosw
;</Aphex>
	mov	byte ptr ds:[5Dh], 20h	; clear FCB name <Boreal>

;Shrink memory to 128K to provide space for entry.com child program
	mov	ah, 4Ah
	mov	bx, 2000h
	int	21h
	mov	[wCs1], ax		;completely undocumented trick: ax = es
	mov	[wCs2], ax		; unless error code is returned instead
	mov	[wCs3], ax

;Reference example's screen segment := cs + 64K
	mov	ax, cs
	add	ax, 1000h
	mov	ScnSeg, ax

;Set up stack to look like a suspend occurred (see Suspnd routine)
	push	offset Example		;push entry loc for alternate coroutine
	pusha				;save current coroutine's registers
	push	ds
	push	es
	mov	spsave, sp		;save alternate coroutine's stack
	mov	sssave, ss		; pointer and segment

;Hook in new keyboard interrupt (16h) handler
	mov	ax, 3516h		;copy interrupt vector into es:bx
	int	21h
	mov	wOld16, bx		;save it in Old16
	mov	wOld16+2, es

	mov	ax, 2516h		;set interrupt vector 16h to ds:dx
	mov	dx, offset Int16Hook
	int	21h

;Execute entry.com
	mov	ax, 4B00h		;load and execute program
	mov	bx, offset bEpb		;es:bx = parameter block
	push	ds
	pop	es
	mov	dx, offset EntryCom	;ds:dx = file name (entry.com)
	int	21h
	jnc	err00
	or	ErrFlag, 10h		;entry.com not found
err00:
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	push	cs			;another undocumented "feature" of DOS:
	pop	ds			; ds is not necessarily preserved

;Unhook keyboard interrupt (16h) handler (restore vector)
	push	ds
	lds	dx, dword ptr cs:wOld16	;get original interrupt vector
	mov	ax, 2516h		;restore it
	int	21h
	pop	ds

;Display error messages
	mov	ah, 0Fh			;if not video mode 3 then error
	int	10h
	cmp	al, 3
	je	err20
	or	ErrFlag, 01h		;text mode 3 not restored at termination

	mov	ax, 0003h		;set mode 3
	int	10h
err20:
	mov	ah, 03h			;get cursor position
	mov	bh, 0
	int	10h
	cmp	dx, 0000h		;must be in upper-left corner
	je	err22
	or	ErrFlag, 08h
err22:
	mov	dx, offset msgNo	;assume no errors
	cmp	ErrFlag, 0		;return error code to DOS
	je	err30
	mov	dx, offset msgErr
err30:
	mov	ah, 09h
	int	21h

	mov	ah, 09h
	test	ErrFlag, 01h
	je	err32
	mov	dx, offset msg0
	int	21h
err32:
	test	ErrFlag, 02h
	je	err34
	mov	dx, offset msg1
	int	21h
err34:
	test	ErrFlag, 04h
	je	err36
	mov	dx, offset msg2
	int	21h
err36:
	test	ErrFlag, 08h
	je	err38
	mov	dx, offset msg3
	int	21h
err38:
	test	ErrFlag, 10h
	je	err40
	mov	dx, offset msg4
	int	21h
err40:
	mov	ax, ErrFlag
	or	al, ah
	mov	ah, 4Ch			;return to DOS
	int	21h			; (stack can be imbalanced)

;-------------------------------------------------------------------------------
;New keyboard handler. 
;
Int16Hook:
	pushf				;preserve flags

	cmp	ah, 0			;only intercept function 0 (read key)
	jne	Old16

	sti				;re-enable interrupts
	cld				;tester expects this

	call	Suspnd			;run example program & check for errors
	mov	ax, cs:KeyCode		;return key code in ax

	popf				;restore flags
	iret

Old16:	popf
	db	0EAh			;jmp far ptr
wOld16	dw	?, ?			;original int 16h vector

;===============================================================================
;Reference code for Soko-Ban game:
;Arrow keys are used to move the man and push the boxes onto the loading
; docks. Only one box can be pushed at a time. (Of course the man cannot
; walk through walls.)
;The file name for the starting level is entered on the command line. If
; no name is entered, "A" is used as the default. When a level is
; completed, the next level (B) automatically loads.
;All moves since the beginning of the level can be undone using the
; Backspace key. The Esc key terminates the program.

bpmax	equ	0F000h			;maximum stack value for undo command
					; (sp is not used in this version)
;Colors:
Black	equ	0
Blue	equ	1
Green	equ	2
Cyan	equ	3
Red	equ	4
Magenta	equ	5
Brown	equ	6
White	equ	7
Gray	equ	8
LBlue	equ	9			;light blue
LGreen	equ	0Ah
LCyan	equ	0Bh
LRed	equ	0Ch
LMagenta equ	0Dh
Yellow	equ	0Eh
BWhite	equ	0Fh			;bright white

;Objects:
ManSym	equ	LBlue*100h+02h		;man symbol code
BoxSym	equ	Yellow*100h+0FEh
WallSym	equ	Red*1000h+White*100h+0B0h
FloorSym equ	White*1000h+20h
DockSym	equ	Cyan*1000h+20h

Example:
	cmp	byte ptr ds:[80h], 2	;is there a file name on command line?
	jne	NoName
	mov	al, ds:[5Dh]		;use it if so, else use default name
	mov	FileName, al		; FCB contains uppercase level name
NoName:
GameLoop:
	mov	bp, bpmax		;set maximum bp for undo command

	mov	ax, 3D00h		;open input file containing floor plan
	mov	dx, offset FileName
	int	21h
	jc	AllDone			;exit program if no more levels
	push	ax			;save file handle

;	mov	ax, 1			;set 40-column text mode
;	int	10h
;	mov	ah, 1			;turn off irritating flashing cursor
;	mov	ch, 20h
;	int	10h

;Initialize reference screen
	mov	es, ScnSeg
	xor	di, di
	mov	ax, 0720h
	mov	cx, 40*25
	rep stosw			;es:[di++]:= ax;  cx--

;Convert symbols in file to more colorful characters on screen
;	mov	ax, 0B800h		;point to text screen
;	mov	es, ax
	mov	di, (4*40+10)*2		;cursor to line 4, column 10 (start @ 0)
ReadLoop:
	mov	ah, 3Fh			;read a character from file
	pop	bx			;get handle
	push	bx
	mov	cx, 1			;number of bytes
	mov	dx, offset Buffer
	int	21h
	cmp	ax, 0			;number of bytes actually read
	je	ReadDone		;if none then done
	mov	al, Buffer		;get symbol

	cmp	al, 0Dh			;if carriage return then move to start
	jne	cvt1			; of next line down (cursor is already
	add	di, 20*2		; at column 20)
	jmp	ReadLoop
cvt1:
	cmp	al, 0Ah			;ignore line feeds
	jne	cvt2
	jmp	ReadLoop
cvt2:
	cmp	al, 20h			;space character = floor
	jne	cvt3
	mov	ax, FloorSym
	jmp	cvt9
cvt3:
	cmp	al, 22h			;background symbol (")
	jne	cvt4
	mov	ax, 20h
	jmp	cvt9
cvt4:
	cmp	al, '#'
	jne	cvt5
	mov	ax, WallSym
	jmp	cvt9
cvt5:
	cmp	al, '!'
	jne	cvt6
	mov	ax, DockSym
	jmp	cvt9
cvt6:
	cmp	al, '&'
	jne	cvt7
	mov	ax, FloorSym-20h+ManSym	;man on floor
	mov	si, di			;record location of man in si
	jmp	cvt9
cvt7:
	cmp	al, '$'
	jne	cvt8
	mov	ax, FloorSym-20h+BoxSym	;box on floor
	jmp	cvt9
cvt8:
	cmp	al, '%'
	jne	cvt9
	mov	ax, DockSym-20h+BoxSym	;box on loading dock
cvt9:
	stosw				;write colorful character to screen
	jmp	ReadLoop

ReadDone:
	mov	ah, 3Eh			;close file handle
	pop	bx
	int	21h

	mov	al, FileName		;display file name (= current level)
	mov	ah, LRed		; in light red
	mov	es:[0], ax		; in upper-left corner

	mov	MoveCntr, 0		;initialize move counter
	call	ShowCntr		; and display it

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
MainLoop:
;	mov	ah, 0			;get command from keyboard
;	int	16h
	call	KeyIn

	cmp	al, 08h			;backspace = undo last move
	je	Undo

	cmp	al, 1Bh			;esc = exit program
	je	AllDone

;Arrow keys = direction to move man
; si = current man location
; bx = possible new man location
; di = possible new box location
	cmp	ah, 4Bh			;left
	jne	key1
	lea	bx, [si-2]
	lea	di, [bx-2]
	jmp	key9
key1:
	cmp	ah, 4Dh			;right
	jne	key2
	lea	bx, [si+2]
	lea	di, [bx+2]
	jmp	key9
key2:
	cmp	ah, 48h			;up
	jne	key3
	lea	bx, [si-40*2]
	lea	di, [bx-40*2]
	jmp	key9
key3:
	cmp	ah, 50h			;down
	jne	MainLoop		;illegal keys are ignored
	lea	bx, [si+40*2]
	lea	di, [bx+40*2]
key9:
;Save current state for Undo command
;	push	word ptr es:[si]	;save man and his background
;	push	word ptr es:[bx]	;save contents at new man location
;	push	word ptr es:[di]	;save contents where box might go
;	push	si			;save location of man
;	push	bx			;save new location of man
;	push	di			;save new location of box
;	push	MoveCntr		;save move counter

	mov	ax, es:[si]
	sub	bp, 2
	mov	[bp], ax

	mov	ax, es:[bx]
	sub	bp, 2
	mov	[bp], ax

	mov	ax, es:[di]
	sub	bp, 2
	mov	[bp], ax

	sub	bp, 2
	mov	[bp], si

	sub	bp, 2
	mov	[bp], bx

	sub	bp, 2
	mov	[bp], di

	mov	ax, MoveCntr
	sub	bp, 2
	mov	[bp], ax

	inc	MoveCntr		;count move

;Make actual move
	mov	al, es:[bx]		;is new man location on floor or dock?
	cmp	al, 20h
	je	MoveMan			;jump if so

	cmp	al, low BoxSym		;is a box being pushed?
	jne	SkipUndo		;jump if not -- can't move

	mov	al, es:[di]		;is new box location on floor or dock?
	cmp	al, 20h
	jne	SkipUndo		;jump if not -- can't move

	and	word ptr es:[di], 0F000h ;move box (keep background color)
	or	word ptr es:[di], BoxSym
MoveMan:
	mov	byte ptr es:[si], 20h	;blank out old location
	and	word ptr es:[bx], 0F000h ;move man (keep background color)
	or	word ptr es:[bx], ManSym
	mov	si, bx			;update man's location
	jmp	SkipUndo

Undo:	cmp	bp, bpmax		;skip if nothing to undo
	je	SkipUndo		;(don't blow the stack)
;	pop	MoveCntr		;restore state for previous move
;	pop	di
;	pop	bx
;	pop	si
;	pop	word ptr es:[di]
;	pop	word ptr es:[bx]
;	pop	word ptr es:[si]

	mov	ax, [bp]
	add	bp, 2
	mov	MoveCntr, ax

	mov	di, [bp]
	add	bp, 2

	mov	bx, [bp]
	add	bp, 2

	mov	si, [bp]
	add	bp, 2

	mov	ax, [bp]
	add	bp, 2
	mov	es:[di], ax

	mov	ax, [bp]
	add	bp, 2
	mov	es:[bx], ax

	mov	ax, [bp]
	add	bp, 2
	mov	es:[si], ax
SkipUndo:
	call	ShowCntr		;display move counter

;Detect if level is finished
;Go back to MainLoop if any dock isn't loaded with a box
	mov	di, 24*40*2
fin:	mov	ax, es:[di]		;get character cell location
	and	ah, 0F0h		;is it a dock location?
	cmp	ah, high DockSym
	jne	fin10			;jump in not
	cmp	al, low BoxSym		;is there a box on it?
	jne	MainLoop		;loop back if not
fin10:	sub	di, 2			;next cell
	jne	fin

	mov	ah, 2			;else beep speaker
	mov	dl, 7
	int	21h

;	mov	ah, 0			;wait for keystroke
;	int	16h			; (and admire your handiwork)
	call	KeyIn

	inc	FileName		;form next file name for next level
	jmp	GameLoop		;loop for all levels
AllDone:
;	mov	ax, 3			;restore 80-column text mode
;	int	10h
	ret				;return to tester

;--------------------;
;Display move counter;
;--------------------;
ShowCntr:
	pusha
	mov	ax, MoveCntr
	mov	di, 39*2		;set cursor to upper-right corner
	mov	bx, 10
mc10:	cwd
	idiv	bx
	add	dl, '0'
	mov	dh, Yellow
	mov	es:[di], dx		;write digit
	sub	di, 2
	cmp	ax, 0
	jne	mc10
	mov	ax, 0720h		;blank possible digit when undoing moves
	stosw
	popa
	ret

;-------------------------------------------------------------------------------
;Get keystroke and return it in ax
;
KeyIn:	call	Check			;first, check for errors in entry.com

;<Aphex>
	pusha				;save all flags
	mov	cx, 1
	mov	bx, IHandle
	mov	ah, 3Fh
	mov	dx, offset ReadKey	;read a key from input handle
	int	21h
	mov	si, offset ReadKey
	lodsb				;get the key
	call	GetScanCode		;get its scan code
	mov	KeyCode, ax		;pass keystroke to entry.com
	popa				;restore all flags
;</Aphex>
;ki10:	mov	ah, 06h			;get command from keyboard
;	mov	dl, 0FFh
;	int	21h
;	je	ki10			;loop until key

;	call	GetScanCode
;	mov	KeyCode, ax		;pass keystroke to entry.com

	call	Suspnd			;run the coroutine (entry.com) awhile
;<Aphex>
	mov	ax, KeyCode		;int16 is supposed to return this ;)
;</Aphex>
	ret

;-------------------------------------------------------------------------------
;Convert numeric keypad keys in al to arrow scan codes in ax
;
GetScanCode:
	cmp	al, '2'
	jne	gsc10
	mov	ax, 5000h		;down
	jmp	gsc90
gsc10:
	cmp	al, '4'
	jne	gsc20
	mov	ax, 4B00h		;left
	jmp	gsc90
gsc20:
	cmp	al, '6'
	jne	gsc30
	mov	ax, 4D00h		;right
	jmp	gsc90
gsc30:
	cmp	al, '8'
	jne	gsc40
	mov	ax, 4800h		;up
	jmp	gsc90
gsc40:
	cmp	al, 08h			;backspace
	jne	gsc50
	mov	ax, 0E08h
	jmp	gsc90
gsc50:
	mov	ah, 01h			;any other key gets esc scan code
gsc90:
	ret

;-------------------------------------------------------------------------------
;Check if ScnSeg (es) compares with B800h. Display error message if not.
;
Check:	pusha

	mov	ah, 0Fh			;if not video mode 0 or 1 then error
	int	10h
	or	al, 01h
	cmp	al, 01h
	je	ck10
	or	ErrFlag, 04h		;'Video mode 1 (or 0) not set'
	jmp	ck80
ck10:
	push	0B800h
	pop	ds
	xor	di, di
	xor	si, si

;If entry's level name is lowercase then convert example's name to lowercase
	mov	al, [si]		;get entry's level name
	cmp	al, 'a'
	jb	ck12			;jump if not lowercase letter
	cmp	al, 'z'
	ja	ck12
;entry's name is lowercase
	mov	al, es:[di]		;get example's level name
	cmp	al, 'A'
	jb	ck12			;jump if not uppercase letter
	cmp	al, 'Z'
	ja	ck12
	or	al, 20h			;convert example's name to lowercase
	mov	es:[di], al
ck12:
;do a word-for-word compare
	mov	cx, 40*25
ck15:	repe cmpsw			;cmp ds:[si++], es:[di++]; cx--
	je	ck90			;jump in no nonmatch is found

;The background, floor, and docks can be displayed several ways
; ds:[si] -> entry
; es:[di] -> example
	sub	si, 2			;backup to mismatched words
	sub	di, 2
	cmp	byte ptr es:[di], 20h	;is example a space?
	jne	ck30			;jump if not -- error
	mov	al, [si]		;get entry's character
	cmp	al, 20h			;is it a space?
	je	ck20
	cmp	al, 00h			;is it a null?
	je	ck20
	cmp	al, 0FFh		;is it weird?
	je	ck20			;if so then go check background color

	mov	al, [si+1]		;does entry's foreground color = its
	mov	ah, al			; background color?
	shr	ah, 4
	and	al, 0Fh
	cmp	al, ah
	je	ck20			;jump if so

	lodsb				;is entry's character = DBh?
	cmp	al, 0DBh		; (solid block)
	jne	ck30			;error if not

	lodsb				;does foreground color for entry
	test	al, 80h			; = background color for example?
	jne	ck30			; (error if entry is flashing)
	and	al, 0Fh
	mov	ah, es:[di+1]
	add	di, 2
	shr	ah, 4
	cmp	al, ah
	je	ck15			;jump if so--continue checking
	jmp	ck30			;error if not
ck20:					;are background colors equal for entry
	inc	si			; and example?
	inc	di
	lodsb				;get entry's attribute; al:= ds:[si++]
	and	al, 0F0h		;look at background color
	mov	ah, es:[di]		;get example's background color
	inc	di
	and	ah, 0F0h
	cmp	al, ah			;jump if background colors are same
	je	ck15			; continue checking
ck30:
	push	cs
	pop	ds

;Display error screen
	or	ErrFlag, 02h		;'Screen error'

	mov	ah, 02h			;cursor to center (14, 0)
	xor	bx, bx			;page 0
	mov	dx, 000Dh
	int	10h

	mov	ah, 09h			;display error message
	mov	dx, offset ScnErr
	int	21h

;Toggle example and entry displays until keystroke
err10:
	mov	cx, 9			;delay about 1/2 second
wait00:	push	es			;wait for next system timer interrupt
	push	0
	pop	es
	mov	al, es:[46Ch]		;read system timer byte
wait10:	cmp	al, es:[46Ch]		;wait for it to change
	je	short wait10
	pop	es
	loop	wait00

; ds:si = B800:0
; es:di = ScnSeg:0
	xor	si, si
	xor	di, di
	push	ds
	push	0B800h
	pop	ds
	mov	cx, 40*25
swap10:	mov	ax, [si]		;read hardware screen
	mov	dx, es:[di]		;read simulated screen 
	mov	[si], dx
	stosw
	add	si, 2
	loop	swap10
	pop	ds

	mov	ah, 01h			;loop until key press
	int	16h
	je	err10
ck80:
	mov	ax, 0003h		;restore text mode
	int	10h

	mov	ah, 4Ch			;terminate entry.com
	int	21h			;(return to tester)
ck90:
	push	cs
	pop	ds
	popa
	ret

ScnErr	db	'Screen error$'

;-------------------------------------------------------------------------------
;Suspend the current coroutine and resume the alternate coroutine
;
Suspnd:	pusha				;save current coroutine's registers
	push	ds
	push	es

	mov	ax, ss
	xchg	cs:sssave, ax		;save current ss and get alternate ss
	mov	ss, ax			;restore alternate coroutine's registers
	xchg	sp, cs:spsave		;(interrupts are momentarily disabled)

	pop	es
	pop	ds
	popa
	ret

ErrFlag	dw	0			;flag bits for each type of error

sssave	dw	?			;save stack segment for coroutines
spsave	dw	?			;save stack pointer
KeyCode	dw	?			;low byte = ASCII, high byte = scan code
ScnSeg	dw	?			;segment address for simulated screen
;<Aphex>
IHandle	dw	?			;keys file handle
ReadKey	db	?			;key read
;</Aphex>

msgNo:	db	'No '
msgErr:	db	'Errors Detected', 0Dh, 0Ah, '$'
msg0	db	'Text mode 3 not restored at termination', 0Dh, 0Ah, '$'
msg1	db	'Screen error', 0Dh, 0Ah, '$'
msg2	db	'Video mode 1 (or 0) not set', 0Dh, 0Ah, '$'
msg3	db	'Final screen not completely blank', 0Dh, 0Ah, '$'
msg4	db	'ENTRY.COM not found', 0Dh, 0Ah, '$'

EntryCom db	'entry.com', 0

bEpb	dw	0			;segment pointer to environment block
	dw	80h			;offset of command line tail
wCs1	dw	?			;segment of command line tail
	dw	5Ch			;offset of 1st FCB copied into new PSP
wCs2	dw	?			;segment of 1st FCB
	dw	6Ch			;offset of 2nd FCB copied into new PSP
wCs3	dw	?			;segment of 2nd FCB
	dw	$-bEpb

;Reference example's variables:
FileName db	'A', 0			;default file name
Buffer	 db	0			;for reading file
MoveCntr dw	0			;move counter

cseg	ends
	end	Start
