;-----------------------------------------------------------------------;
;									;
; Entry for HUGI size coding competition #14 - a SPU assembler		;
; To compile with MASM: ml entry.asm					;
;									;
; By Jeff (USA)								;
;									;
;-----------------------------------------------------------------------;
		.model	tiny
		.386

		.code
		.startup
ProgStart:

		shr	si, 1			; si = 0100h on start, ax=0000h
		lodsb				; bx = 0000h
		xchg	bp, ax
		mov	[si + bp], bl		; NULL terminate file name

		mov	dx, 82h
		mov	ax, 3d00h
		int	21h			; Open file on cmd line
		xchg	bx, ax			; BX = handle (0005h)
		mov	word ptr [si+bp-2], 'UP'; make SPU extension
						; assumes input is .SAM

		mov	di, SpuZeroes
		mov	ch, 0f0h		; cx = 0f0ffh
		rep	stosb			; zero out data (more than necessary)
		pusha				; save CX and DX registers

		mov	dh, SourceFile/256	; DX = SourceFile, dh = 40h
		dec	cx
		mov	ah, 3fh
		int	21h			; Read entire file

		inc	byte ptr [di - 0f0ffh - TextLen + 0f05h]

ProcessFile:
		mov	bp, dx			; BP points to top of label storage
		mov	si, dx			; SI is pointer into SourceFile
		mov	di, OFFSET SpuProg + 100h
NextLine:	cmp	[si], dh		; Is there a label?
		jne	NoLabel

		push	di
		sub	bp, 20
		xchg	ax, di
		mov	di, bp
		stosw				; store inst pointer
NotEndLabel:	stosb				; store label
		call	IsAlphaDigit
		jnc	NotEndLabel
		pop	di
		dec     si
NoLabel:

;--------Beginning of Instruction Processing---------

IsSpace:	lodsb
		cmp	al, ' '
		je	IsSpace
		xor	ax, ax
		xor	cx, cx			; Note: CH = 0 from here out
		dec	si
lp:		sub	al, cl			; Calculate hash of instruction
		xchg	ax, cx			; This is explained in more
		call	IsAlphaDigit		; detail below
		jnc	lp
	
		jcxz	InstRet			; No Instruction
		push	di
		mov	di, OFFSET InstChars
		xchg	ax, cx
		mov	cl, 35 + 0A0h
		repnz	scasb			; scan for instruction
		pop	di

		mov	ax, cx
		shl	ax, 12
		cmp	cl, 33 + 0A0h
		je	op_RETURN		; DB and RETURN are special
		pushf				; cases
		call	ProcessOp		; Get operand
		popf
op_RETURN:	stosb
		ja	op_DB
		dec	di
		stosw
op_DB:
InstRet:	
;--------End of Instruction Processing---------


NextLineLoop:	lodsb
		cmp	al, 0ah
		ja	NextLineLoop		; Skip to next line
		je	NextLine
		dec	bx			; BX is our counter
		jnz	ProcessFile		; This is a 5-pass assembler!

		popa				; restore CX and DX
		mov	ah, 3ch
		int	21h			; create SPU file
		xchg	ax, bx
		mov	ah, 40h
		mov	dx, OFFSET SpuProg
		mov	ch, PROGSIZE/256
		int	21h			; save it
;		ret				; all done!
						; fallthrough to procedure
						; and use it's RET


; This procedure returns the carry flag set if the next char
; is "bad" - a semi-colon, space or CR.  If good, it converts it
; to uppercase.  Note: Uppercase 0-9 is hex 10h-19h.

IsAlphaDigit	PROC	NEAR
		lodsb
		cmp	al, ';'
		stc
		je	NotValid
		and	al, 5fh
		cmp	al, 10h
NotValid:	ret
IsAlphaDigit	ENDP


ProcessOp	PROC	NEAR			; Note: CH = 0 when called
IsSpace1:	lodsb
		cmp	al, ' '
		je	IsSpace1		; skip spaces (again)
		sub	al, 25h			; AL = # (23h), % (25h)
		jz	GetReg			; ' (27h) or @ (40h)
		js	GetImmed
		jpo	GetString
;-----------------------------------------------
GetLabel:	push	di			; Search through labels
		mov	di, SourceFile - 20 + 4	; AL = 1Bh on entry
LabelTop:
		pusha				; save SI and DI
NextLabelChar:
		call	IsAlphaDigit
		jc	TestGoodLabel
		scasb
		je	NextLabelChar
TryNextLabel:
		popa
		sub	di, 20
		jns	LabelTop		; We go a little too far, but if it isn't found, who cares
		pusha				; To offset the popa later
TestGoodLabel:
		cmp	[di], ch		; CH = 0 on entry
		jne	TryNextLabel
		popa
		add     ax, [di - 4]
		sub	ax, OFFSET SpuProg + 1Bh; 1Bh due to AL on entry
NoLabel1:	pop	di
		cmp	cl, 0AFh
		ja	NotRelative
		add	al, LoSpuProg - 2
		sub	ax, di			; Fix up offset for JPcc
		mov	ah, cl			; instructions
NotRelative:	ret
;-----------------------------------------------
NextDBChar:	stosb
GetString:	lodsb				; Store the string
		cmp	byte ptr [si], 27h
		jne	NextDBChar
		ret
;-----------------------------------------------
GetReg:		add	ax, 0f00h + 64 + 16	; AX = xF50h
lp1:		shr	al, 1
		inc	si
		cmp	[si], dh		; dh = 40h
		ja	lp1			; Computes Value based on strlen(register)
		and	al, 7
		ret
;-----------------------------------------------
NextDigit:	add	al, 23			
		db	0D4h, 39		; aam 39, AL = (AL+23) MOD 39
		shl	cx, 4
		add	cl, al
GetImmed:	call	IsAlphaDigit
		jnc	NextDigit
		xchg	ax, cx
		ret
ProcessOp	ENDP

;-----------------------------------------------------------------------;
;									;
; The idea here is to hash each possible instruction to a single byte	;
; value.  It's position in the list gives the opcode for that		;
; instruction (with a little fixing up).				;
;									;
; A simple sum of all the bytes comes close, but "JPLE" and "JPNC"	;
; have the same sum.  However, alternating sums and differences give 	;
; unique values.							;
;									;
;-----------------------------------------------------------------------;

InstChars	DB	0FEh		; DB
		DB	0F0h		; RETURN
		DB	006h		; JP

		DB	0E6h		; XORA
		DB	00Ah		; ANDA
		DB	03Eh		; ORA
		DB	0EEh		; SBBA
		DB	001h		; ADCA
		DB	000h		; JPcc	--- Unused entry
		DB	016h		; ADDW
		DB	05Bh		; RDSYS
		DB	04Eh		; WRI
		DB	057h		; RDI
		DB	040h		; STA
		DB	049h		; LDA
		DB	0F1h		; POPB
		DB	048h		; PUSHB
		DB	038h		; GOSUB
		DB	002h		; OSCALL

		DB	041h		; JPG
		DB	0FFh		; JPLE
		DB	004h		; JPGE
		DB	046h		; JPL
		DB	008h		; JPNP
		DB	04Ah		; JPP
		DB	00Bh		; JPNS
		DB	04Dh		; JPS
		DB	03Bh		; JPA
		DB	009h		; JPBE
		DB	012h		; JPNZ
		DB	054h		; JPZ
		DB	0FBh		; JPNC
		DB	03Dh		; JPC
		DB	007h		; JPNO
;		DB	00Dh		; JPOV - This was lucky!

PROGSIZE	EQU	4096
LoSpuProg	EQU	($ - ProgStart) mod 256
SpuProg		DB	0DH, 0AH, 'Hugi Compo #14...', 1AH
SpuZeroes	EQU	$
TextLen		EQU 	$ - OFFSET SpuProg
Labels		EQU	OFFSET SpuProg + PROGSIZE
SourceFile	EQU	4082h

		END
