;ROT13.ASM
;32-byte version of ROT13 encrypt/decrypt program
;Requires 8088 PC with DOS 2.0 (or better).
;Files must be terminated with a Ctrl+Z (1Ah).
;Usage: ROT13 <infilename.ext >outfilename.ext
;Assemble with nasm: nasm -fbin -orot13.com rot13.asm

		org	100h

		mov	cl, 2h		;send dl to standard output
@loop:		xor	cl, 2^8		;get al from standard input
		call	5
					;(dummy iteration if cl was 2 = print)
		mov	dl, al		;save character in dl
		and	al, 0dfh

		sub	al, 'A'		;jump if character is not in range a..z
		cmp	al, 26
		jae	@check

		aam  13
		mov	al, -13		;will be added by aad
		xor	ax, si		;toggle 0/13 in ah
		aad	26
		add	dl, al

@check:
		cmp	al, 26-'A'	;loop until end-of-file (Ctrl+Z)
		jne	@loop
		
		ret
