; Submission for Hugi Compo #15
; Author: bazs (b.a.z.s@freemail.hu)
; Last modified: Tue Sep 09 2001
; Compile: nasm entry.asm -o entry.com
; Size: 186 bytes


ORG 100h


cmdline equ	  82h
bmpsize equ	4436h
imgsize equ	4000h


SECTION .text


; Preparing the 1st commandline parameter

  mov	bl,cmdline-1
  call	get_string
  push	bx

; Loading bmp

  mov	ah,3Dh		; open file
  int	21h
  xchg	ax,bx
  mov	ah,3Fh
  call	io

; Setting graphics mode & pallette

  mov	ax,13h
  int	10h
  salc			; al = 0
  out	dx,al
  inc	dx
setpal:
  mov	cx,0Ch
  out	dx,al
  loop	$-1
  inc	al
  jns	setpal		; set the pallette 2 times

; Main loop: Display & Transform

main:

; Displaying image on the screen

  push	word (0A000h+(36*320+96)/16)
  pop	ES
  xor	di,di		; es:di points to pixel (96,36)
  mov	si,buffer	; ds:si points to the end of the image
  push	si		; i will use this value later for di
draw:			; al is always 80h here
  mov	cl,128		; ch is always 00h here
  sub	si,cx
  push	si
  rep	movsb
  add	di,320 - 128
  pop	si
  dec	al
  jnz	draw

  push  DS              ; restore ES
  pop   ES

  mov	ah,08h		; wait for input
  int	21h

  pop	di		; di = buffer, also si = image.data

  cmp	al,20h		; quit if space, also cf = 0
  jz	quit

  mov	ah,01h		; put the transform function to cx
  mov	bx,keytab-30h
  xlatb
  xchg	ax,cx		; ah = 0 (y-coordinate), cx = @ of function
transform:
  salc			; al = 0 (x-coordinate)
lines:
  pusha
  call	cx		; transform (x;y)
  and	ah,7Fh		; y wrap around
  add	al,al		; x wrap around
  shr	ax,1		; ax = 128*ah + al
  add	di,ax           ; di = address, also cf = 0
  movsb
  popa
  inc	si
  inc	al
  jns	lines		; while x<128
  inc	ah
  jns	transform	; while y<128

  mov	cx,imgsize	; copying buffer(=si=di) -> image.data
  sub	di,cx		; di = image.data
  rep	movsb

  jmp	main

; Saving output and quitting

quit:
  pop	bx
  xchg	ax,cx		; ax = 00h , cl = 20h
  mov	al,03h
  int	10h
again:
  call	get_string
  mov	ah,3Ch		; creating file
  int	21h
  jc	again		; if not valid (starts with 0) then jump back
  xchg	ax,bx		; writing file
  mov	ah,40h
io:
  mov	cx,bmpsize
  mov	dx,image
  int	21h
  mov	ah,3Eh		; closing file
  int	21h


; Finding the new coordinates for one point
; A little bit spaghetti-style code but small & works

scroll_rg:	;2 bytes
  inc	ax
  ret
rot_270:	;2 bytes
  not	ax
rot_90:		;2 bytes
  xchg	al,ah
x_flip:		;2 bytes
  not	ax
y_flip:		;2 bytes
  not	al
rot_180:	;3 bytes
  not	ax
  ret
scroll_up:	;3 bytes
  inc	ah
  ret
scroll_dn:	;3 bytes
  dec	ah
  ret
scroll_lf:	;3 bytes
  dec	al
  ret


; A procedure to find parameter strings

get_string:
  lea	dx,[bx+1]
.find:
  inc	bx
  cmp	[bx],byte 20h
  ja	.find
  mov	[bx],bh		; bx < 100h, so bh=0
  ret


; Key table

keytab:
	db	y_flip-$$		;0
	db	rot_180-$$		;1
	db	scroll_dn-$$		;2
	db	rot_270-$$		;3
	db	scroll_lf-$$		;4
	db	x_flip-$$		;5
	db	scroll_rg-$$		;6
	db	rot_180-$$		;7
	db	scroll_up-$$		;8
	db	rot_90-$$		;9


SECTION .bss

  absolute 03C8h	; saves 3 bytes

  image:
	.header:	resb 36h
	.pallette:	resb 400h
	.data:		resb imgsize
	.end:

  buffer:	resb	imgsize


; The end -
; Thank you, it was good to compete with you guys.
