       .586
code   SEGMENT use16
       ASSUME  cs:code,ds:code,es:code,ss:code
       ORG     100h
salc   equ     <db 0d6h>
;--------------------------------------------------------------------
BMP_FILESIZE    equ     17462

bmpbuffer	equ 17462
bmppalette	equ bmpbuffer + 36h
bmpimage		equ bmppalette + 1024
workspace	equ bmpimage + 16384 
;--------------------------------------------------------------------
start:
;--------------------------------------------------------------------
	push	0A000h + (((320*35)+96)/16)     ;*NOTE y=36 - 1
	pop	es

	mov	bl,80h
	mov	cl,20h
	mov	ah,3eh	; for dec to 3dh
	mov	ch,ah		; for inc to 3fh
	pusha
start1:
	mov	ax,3
	int	10h
	popa
spaces:
	inc	bx
 	cmp	[bx],cl
	mov	dx,bx
	jbe	spaces
fname:
	inc	bx
	cmp	[bx],cl
	ja		fname
	mov	[bx],al
	
	dec	ah
	inc	ch
	pusha			; save ah == 3dh, ch == 3fh, dx = name, bx == next spaces
	int	21h	; open/create file

	xchg	ax,bx
	mov	ah,ch
	mov	dx,bmpbuffer
	mov	cx,dx
	sahf
@123:
	int	21h	; read/write file/quit
	jnp	@123
;--------------------------------------------------------------------
; set mode 13h 
;--------------------------------------------------------------------
	mov	ax,13h
	int	10h
;-------------------------------------------------------------------
; Main loop
;-------------------------------------------------------------------
MainLoop:
	mov	si,bmpimage
	mov	di,128*320
drawbmp:
	mov	cx,128
copy_x:
	lodsb
	mov	[si+16384-1],al    ; copy bitmap --> workspace 
	shr	al,4
	add	al,16
	stosb
	loop	copy_x
	sub	di,320+128
	jnz	drawbmp

	mov	ah,8
	int	21h

	sub	al,'0'
	cmp	al,9
	ja		start1
;--------------------------------------------------------------------
; TransImage
;--------------------------------------------------------------------
   cbw
   cwd
   xchg	ax,bp
	mov	di,bmpimage

y_loop:
	xor	dl,dl
x_loop:

	mov	bx,dx	
   mov	cl,[bp+transTable]
trans:
	shl	cl,1           ;
	salc		            ; salc instruction
	shl	cl,1           ;
	sbb	bl,al          ; (1) add <coord>, Ssssssss (binary)

	shl	cl,1
	jnc	no_neg
	neg	bl             ; (2) neg <coord>
no_neg:
	shl	cl,1
	jnc	no_swap
	xchg	bl,bh          ; (3) xchg x,y
no_swap:
	jnz	trans

   and	bh,127
	shl	bl,1 
	shr	bx,1 
	mov	al,[bx+si]
	mov	[di],al
	inc	di   
	inc	dl
	jns	x_loop
	inc	dh
	jns	y_loop

	jmp	MainLoop
;--------------------------------------------------------------------
;       76543210
;       SsNXSsNX        ; key   operations
transTable label byte
     db 00011011b       ; [0]   xchg inc  neg  xchg
     db 10111011b       ; [1]   inc  neg  xchg inc  neg  xchg
     db 00011001b       ; [2]   xchg inc       xchg
     db 00011010b       ; [3]   xchg inc  neg
     db 10000000b       ; [4]   inc
     db 10100000b       ; [5]   inc  neg
     db 01000000b       ; [6]   dec
     db 10111011b       ; [7]   inc  neg  xchg inc  neg  xchg
     db 00010101b       ; [8]   xchg dec  xchg
     db 10110000b       ; [9]   inc  neg  xchg
                        ;
                        ; Ss
                        ; 00 =  0               N = neg
                        ; 01 = -1 (dec)
                        ; 10 = +1 (inc)         X = xchg
                        ; 11 =  0
;--------------------------------------------------------------------
code ends
end start

