;-----------------------------------------------------------------------;
;                                                                       ;
; Entry for HUGI size coding competition #15 - a 128x128 Bitmap         ;
;   Manipulator							        ;
; To compile with MASM: ml entry.asm                                    ;
;                                                                       ;
; By Jeff (USA)                                                         ;
;                                                                       ;
;-----------------------------------------------------------------------;
		.model	tiny
		.code
		.386
		.startup


; Four transforms are encoded using four bits each, overlapping every two
;   bits.  The last transform must be of the form xx00b.
; The high four bits are tested and used as follows:
;	Q (0000) = Quit
; 	R (xxxx) = Odd Parity - Rotate 270 
; 	S (xxxx) = Sign Bit Set and Even Parity - Scroll up and Rotate 270
;	F (xxxx) = No Sign Bit, Even Parity, Non Zero - Vertical Flip and Rotate 270
;
; This gives a greater flexibilty as far as choices for the various
;  transformations, which allows the table to double as valid instructions
;  to initialize a few registers to useful values.
;
;
;TranslateTable	DB	086h		; 0 - Vertical Flip	RRFR
;		DB	020h		; 1 - Rotate 180	RR--
;		DB	0b9h		; 2 - Scroll Down	RRSR
;		DB	0b8h		; 3 - Rotate 90		RRR-
;		DB	0bbh 	  	; 4 - Scroll Left	RRRS
;		DB	04dh		; 5 - Horizontal Flip	RFRR
;		DB	0bdh		; 6 - Scroll Right	RSRR
;		DB	0d0h		; 7 - Rotate 180	RR--
;		DB	0a2h		; 8 - Scroll Up		SRRR
;		DB	040h		; 9 - Rotate 270	R---
;
; The table breaks out to the following instructions:
;		xchg	ah, [bx + si]
;		mov	cx, 0bbb8h
;		dec	bp
;		mov	bp, 0a2d0h		- New ES
;		inc	ax


; Parse Command Line
		shr	si, 1
		lodsb
		xchg	ax, bx
; The table
TranslateTable	DB	086h, 020h, 0b9h, 0b8h, 0bbh
		DB	04dh, 0bdh, 0d0h, 0a2h, 040h

		lodsb			; Note: assumes space after program
		mov	dx, si		; DX = First filename

		xchg	di, si		; SI = -2, word ptr [SI] = 0
		repnz	scasb
		dec	di
		movsb
		repz	scasb		; Note: assumes only spaces between filenames
		dec	di		; DI = Second filename
		push	di		; pointer to second file name
		mov	fs, bp		; fs = Video segment

; Open File
		mov	ch, 3fh		; 3F = read
		call	ReadWrite
		

; Perform Rotation, Reflextion, or Shift
NextMotion:
		mov	si, BitMapData
		mov	di, 36*320 + 96 + 127*320 - 2d00h 	; = 9f20h
		mov	ch, 40h
		pusha
		rep	movsb
		popa
NextPoint:	mov	bx, cx
		dec	bx
		mov	ah, [di + bx]
		ror	bx, 7
		shr	bh, 1

		test	al, 0f0h
		jz	quit
		jpo	DoRotate
		jns	DoOnlyXchg
		inc	bx
DoRotate:	not	bl
DoOnlyXchg:		

		pusha
		movzx	bp, bh
		imul	bp, -448
		shl	bl, 1
		shr	bx, 1
		mov	[si + bx], ah
		add	bp, bx
		shr	ax, 10
		mov	fs:[di + bp], al
		out	dx, al			; Set Palette Entry
		inc	dx
		out	dx, al
		out	dx, al
		out	dx, al
		popa
		loop	NextPoint
		shl	al, 2
		jnz	NextMotion

; Read character
		mov	ah, 8
		int	21h
		mov	bl, 0d4h		; OFFSET TranslateTable - 30h
		xlat
		jmp	NextMotion

quit:
; Save File
		pop	dx


ReadWrite	PROC	NEAR		; ch = read/write, dx = ptr to file
		shr	al, 1
		add	al, 3
		cbw
		int	10h
		mov	ah, 3eh + 3eh
		sub	ah, ch
		int	21h
		xchg	ax, bx
		xchg	cx, ax
		mov	dx, BitMap
		mov	cx, 4436h
		int	21h
		ret
ReadWrite	ENDP



BitMap		EQU	03c8h
BitMapData	EQU	BitMap + 1078	; 07feh
		
		END