;--------------------------------------------------------------------
;                            "TRANS-ADOK"
;
; Test suite for Hugi Size Coding Compo #15
;--------------------------------------------------------------------
; compile:
;       nasm -fbin -ocompare.com compare.asm
;
; usage:
;       compare <infile.bmp>  <outfile.bmp>
;--------------------------------------------------------------------

BMP_FILESIZE    equ     17462

        org	256
        mov	di, 0082h
	
        mov	dx, bmpbuffer1
        call	ReadFile
	
        mov	dx, bmpbuffer2
        call	ReadFile

        mov	si, bmpbuffer1
        mov	di, bmpbuffer2
        mov	cx, BMP_FILESIZE
        repe	cmpsb

exit:
        or	cl, ch
        mov	al, cl
        mov	ah, 4ch
        int	21h

;--------------------------------------------------------------------
ReadFile:
        push	 dx
	
        ;; [DS:DX] = scan & mark end of command-line filename[DS:DI]
        mov     dx, di
        mov     al, 20h
FindSpace:
        scasb
        jb     short FindSpace
        mov     byte [di-1], 00h
	
        ;; open file
        mov     ax, 3D00h
        int     21h

        ;; read file
        pop	 dx
        mov     bx, ax
        mov     cx, BMP_FILESIZE+1
        mov     ah, 3Fh
        int     21h

        ;; close <input> file ;;
        push    ax	
        mov     ah, 3Eh
        int     21h
        pop     ax
	
        ;; check that the file's size was correct
        cmp     ax, BMP_FILESIZE
        jne     exit			; CL != 0
        ret
	
; ---------------------------------------------------------------

section .bss
bmpbuffer1:	resb BMP_FILESIZE
bmpbuffer2:	resb BMP_FILESIZE


