@echo off

:: This batch file has two subroutines, run the one that was
:: requested (this is a trick to set the command line as needed)
::
if not %1*==* goto %1

echo Test results > results.txt

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: First test suite -- run each transformation once
::
call %0 run 1.0 0
call %0 run 1.1 1
call %0 run 1.2 2
call %0 run 1.3 3
call %0 run 1.4 4
call %0 run 1.5 5
call %0 run 1.6 6
call %0 run 1.7 7
call %0 run 1.8 8
call %0 run 1.9 9

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Second test suite -- run each transformation enough times
:: to recover the original image
::
call %0 run 2.0 00
call %0 run 2.1 11
call %0 run 2.2 22222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222
call %0 run 2.3 3333
call %0 run 2.4 44444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444
call %0 run 2.5 55
call %0 run 2.6 66666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666
call %0 run 2.7 77
call %0 run 2.8 88888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888
call %0 run 2.9 9999

type results.txt
del results.txt
goto exit

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: RUN subroutine
:: Parameters:
::     %2 Test name
::     %3 Commands to be passed
::
:run
echo %3 dummy | example adokh22.bmp     out1.bmp
echo %3 dummy | entry adokh22.bmp      out2.bmp
compare out1.bmp out2.bmp
if errorlevel 1 %0 log Test %2 FAILED (incorrect file size or data)

:: Use DIR to check if the attributes are correct
:: (archive, read-write, not hidden, not system)

dir /a:a-d-h-s-r | find /i "OUT2.BMP" > nul
if errorlevel 1 %0 log Test %2 FAILED (file has incorrect attributes)

%0 log Test %2 passed.

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: LOG subroutine
:: Parameters:
::     A line that is written to the results.txt file
::
:log
echo %2 %3 %4 %5 %6 %7 %8 %9 >> results.txt
attrib -h -s -r -a out2.bmp
del out1.bmp
del out2.bmp

:exit
