;====================================================================
;
; entry for hugi #15
; by entro-p [ clive crous ]
; entro-p at asmz dot com
;
;   compile with :      nasm -fbin -oentry.com entry.asm
;
;====================================================================
;
; first working version                                    290 bytes
; visits to code for byte removal ;)
;
; 1                                                        253 bytes
;
;====================================================================
[BITS 16]
[ORG 0x0100]
%define FINAL ; uncomment for no extra code / final version!
%ifndef FINAL
%define DEBUG
%define INIT  ; uncomment for w2k & td
%endif
[SECTION .bss]
ALIGN 1
bmp_header    resb      1078
bmp_data      resb      128*128
bmp_data2     resb      128*128
[SECTION .text]
start:
%ifdef INIT
              xor       ax, ax
              xor       bx, bx
              mov       cx, 0x00FF
              mov       si, 0x0100
              mov       di, 0xFFFE
              and       bp, 0x00FF
              or        bp, 0x0900
              mov       sp, 0xFFFE
%endif
%ifdef DEBUG
              mov       al, 03h
%else
              mov       al, 13h
%endif
              int       10h
              mov       dx, 3C8h
              xor       ax, ax
              out       dx, al
              inc       dx
palette:      mov       cl, 12
colour:       out       dx, al
              loop      colour
              inc       ax
              jnz      palette

              mov       bp, 81h
              mov       ah, 0x3D
              call      fileio
              call      vertflip
mainloop:     push      word 0A000h
              pop       es
              mov       di, 36*320+96
              mov       si, bmp_data
              mov       cx, 128                  ;KRKT!
blitline:     push      cx
              mov       cl, 32
              rep       movsd
              add       di, 320-128   ; 0xC0
              pop       cx
              loop      blitline
              mov       ah, 08h
              int       21h
              cmp       al, ' '
              je        exit
              mov       bx, keycalls-'0'
              add       bl, al
              mov       al, [bx]
              add       bl, al
              call      bx
              jnc       mainloop
exit:         inc       byte [fiomode]
              call      vertflip
              mov       ah, 0x3C
              call      fileio
              mov       ax, 0003h
              int       10h
              ret
preparedata:  push      ds
              pop       es
              mov       di, bmp_data2
              mov       si, bmp_data
              mov       ch, 16
              rep       movsd
              ret
keycalls:     db        vertflip-$
              db        rot180-$
              db        vertscrolld-$
              db        rotcc90-$
              db        horzscrolll-$
              db        horzflip-$
              db        horzscrollr-$
              db        rot180-$
              db        vertscrollu-$
              db        rotc90-$
horzflip:     call      rotcc90
              push      word rotc90
vertflip:     call      preparedata
              mov       cl, 128
              mov       di, bmp_data
              mov       si, bmp_data2 + 127*128
_vp:          push      cx
              mov       cl, 32
              rep       movsd
              sub       si, 128*2
              pop       cx
              loop      _vp
              ret
horzscrollr:  call      rot180
              push      word rot180
horzscrolll:  call      rotc90
              push      word rotcc90
vertscrolld:  mov       cl, 126
vertscrollp:  push      word vertscrollu
              loop      vertscrollp
vertscrollu:  call      preparedata
              mov       di, bmp_data
              mov       si, bmp_data+128
              mov       ch, 16
              rep       movsd
donothing:    ret
rotcc90:      push      word rotc90
rot180:       push      word rotc90
rotc90:       call      preparedata
              mov       si, bmp_data2
              mov       di, bmp_data+127*128
              mov       cl, 128
dim1:         push      cx
              mov       cl, 128
dim2:         movsb
              sub       di, 129
              loop      dim2
              add       di, 128*128+1
              pop       cx
              loop      dim1
              ret
fileio:       mov       dx, bp
              inc       dx
filenl:       inc       bp
              cmp       byte [bp], 20h
              ja        filenl
              mov       byte [bp], cl
              int       21h
              mov       bx, ax
              mov       dx, bmp_header
              mov       cx, 17462                ;k
              mov       bx, ax
              db        0xB4
fiomode:      db        0x3F
              int       21h
              mov       ah, 3Eh
              int       21h
              ret
