; convert hex number on command-line & displays it as decimal by TAD 2K2
; size : 61 bytes
;
; compile:
;       tasm /m9 dec
;       tlink /t dec
;
; usage:
;       DEC <hexnumber>
;
salc    equ     <db 0D6h>

        .model tiny
        .code
        .386
        org 256
go:
        db      13,10,'$'       ; OR AX, 240Ah

        sub     edx, edx        ; n = 0
        salc
hex:
        shl     edx, 4          ; n = (n * 16) + al
        or      dl, al          ;

        mov     al, [bx+05Dh]   ; DS:BX+5Dh --> FCB1 (auto skip spcs ;)
        inc     bx              ; next char

        sub     al, 30h         ; ** Convert hex ASCII char into nibble
        aam     30h             ; ** 
        aad     10h             ; ** (it also deals with upper/lowercase)
        aam     11h             ; ** '0123456789ABCDEF'
        daa                     ; **        and
        aad     0Ah             ; ** '0123456789abcdef'

        cmp     al, 10h         ;
        jc      short hex       ; a valid hex ASCII char ?

        xchg    eax, edx
        push    10		; [DS:DI-2] = 0000 000A (divisor)
deci:
        dec     si              ; work backwards from 1's digit
        sub     edx, edx
        div     dword ptr [di-2]
        add     dl, '0'
        mov     [si], dl        ; decimal char = '0' + (n mod 10)
        test    eax, eax        ; (n div 10) <> 0 ?
        jnz     short deci      ; repeat until it is..

        mov     dx, si
quit:
        xchg    ax, bp
        int     21h             ; print to STDOUT
        jmp     short quit      ; nice clean exit :)
        end     go
